/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.minioclcs.xtext.tx;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Connection;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Interval;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.SimpleConnection;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.SimpleIncrementalConnection;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.StrictConnection;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.StrictIncrementalConnection;

public interface ModeFactory {
    public static final @NonNull ModeFactory INCREMENTAL = new Incremental();
    public static final @NonNull ModeFactory NON_INCREMENTAL = new NonIncremental();

    public @NonNull Connection createConnection(@NonNull Interval var1, @NonNull String var2, @NonNull TypeId var3, boolean var4);

    public static class Incremental
    implements ModeFactory {
        @Override
        public @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            if (isStrict) {
                return new StrictIncrementalConnection(interval, name, typeId);
            }
            return new SimpleIncrementalConnection(interval, name, typeId);
        }
    }

    public static class NonIncremental
    implements ModeFactory {
        @Override
        public @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            if (isStrict) {
                return new StrictConnection(interval, name, typeId);
            }
            return new SimpleConnection(interval, name, typeId);
        }
    }
}

