/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.oclany.OclElementOclContainerProperty;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SpeculateStatement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.EntryPointsAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class EntryPointAnalysis {
    protected final @NonNull EntryPointsAnalysis entryPointsAnalysis;
    protected final @NonNull EntryPoint entryPoint;
    protected final @NonNull List<@NonNull Mapping> mappings = new ArrayList<Mapping>();
    private final @NonNull Map<@NonNull OppositePropertyCallExp, @NonNull Integer> oppositePropertyCallExp2cacheIndex = new HashMap<OppositePropertyCallExp, Integer>();
    private final @NonNull Set<@NonNull Mapping> hazardousMappings = new HashSet<Mapping>();
    private final @NonNull Map<@NonNull Mapping, @NonNull Set<@NonNull NavigationCallExp>> mapping2property = new HashMap<Mapping, Set<NavigationCallExp>>();
    private final @NonNull Map<@NonNull Mapping, @NonNull Set<@NonNull SetStatement>> mapping2propertyAssignments = new HashMap<Mapping, Set<SetStatement>>();
    private final @NonNull Map<@NonNull Operation, @NonNull Set<@NonNull NavigationCallExp>> operation2property = new HashMap<Operation, Set<NavigationCallExp>>();
    private final @NonNull Map<@NonNull Property, @NonNull Set<@NonNull SetStatement>> property2propertyAssignments = new HashMap<Property, Set<SetStatement>>();
    private final @NonNull Map<@NonNull Type, @NonNull List<@NonNull Type>> parentClass2childClasses = new HashMap<Type, List<Type>>();
    private final @NonNull List<@NonNull SpeculateStatement> speculateStatements = new ArrayList<SpeculateStatement>();
    private @Nullable UniqueList<@NonNull EAttribute> speculatedEAttributes = null;

    public EntryPointAnalysis(@NonNull EntryPointsAnalysis entryPointsAnalysis, @NonNull EntryPoint entryPoint) {
        this.entryPointsAnalysis = entryPointsAnalysis;
        this.entryPoint = entryPoint;
    }

    public boolean addMapping(@NonNull Mapping iMapping) {
        assert (!this.mappings.contains(iMapping));
        return this.mappings.add(iMapping);
    }

    public void analyze() {
        ArrayList<@NonNull SetStatement> setStatements = new ArrayList<SetStatement>();
        Class oclElementType = this.entryPointsAnalysis.environmentFactory.getStandardLibrary().getOclElementType();
        Class modelType = this.entryPointsAnalysis.environmentFactory.getStandardLibrary().getLibraryType("Model");
        OperationId allInstancesOperationId = oclElementType.getTypeId().getOperationId(0, "allInstances", IdManager.getParametersId((TypeId[])new TypeId[0]));
        OperationId objectsOfKindOperationId = modelType.getTypeId().getOperationId(1, "objectsOfKind", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        OperationId objectsOfTypeOperationId = modelType.getTypeId().getOperationId(1, "objectsOfType", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        for (Mapping iMapping : this.getMappings()) {
            for (EObject eObject : new TreeIterable((EObject)iMapping, true)) {
                OCLExpression argument;
                OperationCallExp operationCallExp;
                Operation referredOperation;
                Mapping mapping;
                if (eObject instanceof Mapping) {
                    mapping = (Mapping)eObject;
                    this.analyzeMappingPropertyAccesses(mapping);
                    this.analyzeMappingSetStatements(mapping);
                    if (!QVTimperativeUtil.isObserver(mapping)) continue;
                    this.hazardousMappings.add(mapping);
                    continue;
                }
                if (eObject instanceof OppositePropertyCallExp) {
                    OppositePropertyCallExp oppositePropertyCallExp = (OppositePropertyCallExp)eObject;
                    Property navigableProperty = oppositePropertyCallExp.getReferredProperty();
                    if (navigableProperty == null || navigableProperty.isIsComposite()) continue;
                    int cacheIndex = this.entryPointsAnalysis.allocateCacheIndex(oppositePropertyCallExp.getOwnedSource(), navigableProperty);
                    this.oppositePropertyCallExp2cacheIndex.put(oppositePropertyCallExp, cacheIndex);
                    continue;
                }
                if (eObject instanceof SetStatement) {
                    setStatements.add((SetStatement)eObject);
                    continue;
                }
                if (eObject instanceof SpeculateStatement) {
                    this.speculateStatements.add((SpeculateStatement)eObject);
                    continue;
                }
                if (eObject instanceof AppendParameter) {
                    mapping = QVTimperativeUtil.getContainingMapping(eObject);
                    if (this.entryPoint != mapping) continue;
                    this.entryPointsAnalysis.addAllInstancesClass((TypedElement)((AppendParameter)eObject));
                    continue;
                }
                if (!(eObject instanceof OperationCallExp) || (referredOperation = (operationCallExp = (OperationCallExp)eObject).getReferredOperation()) == null) continue;
                OperationId operationId = referredOperation.getOperationId();
                if (operationId == allInstancesOperationId) {
                    OCLExpression source = operationCallExp.getOwnedSource();
                    if (source == null) continue;
                    this.entryPointsAnalysis.addAllInstancesClass((TypedElement)source);
                    continue;
                }
                if (operationId != objectsOfKindOperationId && operationId != objectsOfTypeOperationId || (argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0)) == null) continue;
                this.entryPointsAnalysis.addAllInstancesClass((TypedElement)argument);
            }
            this.entryPointsAnalysis.analyzeStatements(setStatements);
            this.analyzeProperties();
        }
    }

    private @NonNull Set<@NonNull NavigationCallExp> analyzeMappingPropertyAccesses(@NonNull Mapping mapping) {
        Set<@NonNull NavigationCallExp> accessedProperties = this.mapping2property.get(mapping);
        if (accessedProperties != null) {
            return accessedProperties;
        }
        accessedProperties = new HashSet<NavigationCallExp>();
        this.mapping2property.put(mapping, accessedProperties);
        this.analyzeTree(accessedProperties, (TreeIterator<EObject>)mapping.eAllContents());
        return accessedProperties;
    }

    private @NonNull Set<@NonNull SetStatement> analyzeMappingSetStatements(@NonNull Mapping mapping) {
        Set<@NonNull SetStatement> assignedProperties = this.mapping2propertyAssignments.get(mapping);
        if (assignedProperties == null) {
            assignedProperties = new HashSet<SetStatement>();
            this.mapping2propertyAssignments.put(mapping, assignedProperties);
        }
        TreeIterator treeIterator = mapping.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof SetStatement)) continue;
            assignedProperties.add((SetStatement)eObject);
        }
        return assignedProperties;
    }

    private @NonNull Set<@NonNull NavigationCallExp> analyzeOperation(@NonNull Operation operation) {
        Set<@NonNull NavigationCallExp> operationProperties = this.operation2property.get(operation);
        if (operationProperties != null) {
            return operationProperties;
        }
        operationProperties = new HashSet<NavigationCallExp>();
        this.operation2property.put(operation, operationProperties);
        this.analyzeTree(operationProperties, (TreeIterator<EObject>)operation.eAllContents());
        return operationProperties;
    }

    private void analyzeProperties() {
        for (Set<SetStatement> propertyAssignments : this.mapping2propertyAssignments.values()) {
            for (SetStatement propertyAssignment : propertyAssignments) {
                Property property = propertyAssignment.getTargetProperty();
                assert (property != null);
                Set<@NonNull SetStatement> assignments = this.property2propertyAssignments.get(property);
                if (assignments == null) {
                    assignments = new HashSet<SetStatement>();
                    this.property2propertyAssignments.put(property, assignments);
                }
                assignments.add(propertyAssignment);
            }
        }
    }

    protected void analyzeTree(@NonNull Set<NavigationCallExp> properties, TreeIterator<EObject> treeIterator) {
        while (treeIterator.hasNext()) {
            Property referredProperty;
            OppositePropertyCallExp asOppositePropertyCallExp;
            Property referredOppositeProperty;
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof OperationCallExp) {
                Operation referredOperation = ((OperationCallExp)eObject).getReferredOperation();
                if (referredOperation == null) continue;
                properties.addAll(this.analyzeOperation(referredOperation));
                continue;
            }
            if (eObject instanceof PropertyCallExp) {
                PropertyCallExp asPropertyCallExp = (PropertyCallExp)eObject;
                Property referredProperty2 = asPropertyCallExp.getReferredProperty();
                if (referredProperty2 == null) continue;
                LibraryFeature implementation = referredProperty2.getImplementation();
                if (implementation instanceof OclElementOclContainerProperty) {
                    Type childType = asPropertyCallExp.getOwnedSource().getType();
                    assert (childType != null);
                    Type parentType = asPropertyCallExp.getType();
                    assert (parentType != null);
                    List<@NonNull Type> childClasses = this.parentClass2childClasses.get(parentType);
                    if (childClasses == null) {
                        childClasses = new ArrayList<Type>();
                        this.parentClass2childClasses.put(parentType, childClasses);
                    }
                    if (childClasses.contains(childType)) continue;
                    childClasses.add(childType);
                    continue;
                }
                properties.add((NavigationCallExp)asPropertyCallExp);
                continue;
            }
            if (!(eObject instanceof OppositePropertyCallExp) || (referredOppositeProperty = (asOppositePropertyCallExp = (OppositePropertyCallExp)eObject).getReferredProperty()) == null || (referredProperty = referredOppositeProperty.getOpposite()) == null) continue;
            properties.add((NavigationCallExp)asOppositePropertyCallExp);
        }
    }

    public Set<@NonNull CompleteClass> getAllInstancesCompleteClasses() {
        return this.entryPointsAnalysis.getAllInstancesCompleteClasses();
    }

    public @Nullable Integer getCacheIndex(@NonNull OppositePropertyCallExp oppositePropertyCallExp) {
        return this.oppositePropertyCallExp2cacheIndex.get(oppositePropertyCallExp);
    }

    public @NonNull EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public @NonNull EntryPointsAnalysis getEntryPointsAnalysis() {
        return this.entryPointsAnalysis;
    }

    public @NonNull List<@NonNull Mapping> getMappings() {
        return this.mappings;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull EAttribute> getSpeculatedEAttributes() {
        @NonNull UniqueList speculatedEAttributes2 = this.speculatedEAttributes;
        if (speculatedEAttributes2 == null) {
            this.speculatedEAttributes = speculatedEAttributes2 = new UniqueList();
            for (SpeculateStatement speculateStatement : this.speculateStatements) {
                Mapping asMapping = QVTimperativeUtil.getContainingMapping((EObject)speculateStatement);
                for (MappingParameter mappingParameter : QVTimperativeUtil.getOwnedMappingParameters(asMapping)) {
                    Property successProperty;
                    if (!(mappingParameter instanceof GuardParameter) || (successProperty = ((GuardParameter)mappingParameter).getSuccessProperty()) == null) continue;
                    EObject eStructuralFeature = successProperty.getESObject();
                    EAttribute eAttribute = (EAttribute)eStructuralFeature;
                    assert (eStructuralFeature instanceof EAttribute && eAttribute.getEType() == EcorePackage.Literals.EBOOLEAN_OBJECT);
                    speculatedEAttributes2.add((Object)((EAttribute)eStructuralFeature));
                }
                for (OCLExpression speculateExpression : QVTimperativeUtil.getOwnedExpressions(speculateStatement)) {
                    for (EObject speculateEObject : new TreeIterable((EObject)speculateExpression, true)) {
                        if (!(speculateEObject instanceof NavigationCallExp)) continue;
                        Property speculateProperty = PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)speculateEObject));
                        EObject eStructuralFeature = speculateProperty.getESObject();
                        EAttribute eAttribute = (EAttribute)eStructuralFeature;
                        if (!(eStructuralFeature instanceof EAttribute) || eAttribute.getEType() != EcorePackage.Literals.EBOOLEAN_OBJECT) continue;
                        speculatedEAttributes2.add((Object)((EAttribute)eStructuralFeature));
                    }
                }
            }
            Collections.sort(speculatedEAttributes2, NameUtil.TO_STRING_COMPARATOR);
        }
        return speculatedEAttributes2;
    }

    public boolean isHazardous(@NonNull Mapping mapping) {
        return this.hazardousMappings.contains(mapping);
    }

    public String toString() {
        return this.entryPoint.toString();
    }
}

