/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class XMIUtils {
    public static final UUIDCreator uuidCreator = new UUIDCreator();

    public static void assignIds(Resource resource, IdCreator idCreator, IdFilter idFilter) {
        String id;
        if (!(resource instanceof XMLResource)) {
            return;
        }
        XMLResource xmlResource = (XMLResource)resource;
        HashSet<String> knownIds = new HashSet<String>(256);
        ArrayList<EObject> idLess = new ArrayList<EObject>(100);
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            id = xmlResource.getID(eObject);
            if (id != null) {
                knownIds.add(id);
                continue;
            }
            if (idFilter != null && !idFilter.createId(eObject)) continue;
            idLess.add(eObject);
        }
        for (EObject eObject : idLess) {
            id = idCreator.createId(eObject, knownIds);
            if (id == null) continue;
            String uniqueId = id;
            int i = 1;
            while (knownIds.contains(uniqueId)) {
                uniqueId = String.valueOf(id) + '_' + i;
                ++i;
            }
            xmlResource.setID(eObject, uniqueId);
            knownIds.add(uniqueId);
        }
    }

    public static void assignIds(Resource resource, String xmiIdPrefix) {
        if (xmiIdPrefix == null) {
            xmiIdPrefix = "_";
        }
        XMIUtils.assignIds(resource, new ShortPrefixedIdCreator(xmiIdPrefix), new ExcludedEClassIdFilter(new EClass[]{XMLTypePackage.Literals.ANY_TYPE, EcorePackage.Literals.EGENERIC_TYPE}));
    }

    public static void assignLinearIds(Resource resource, String xmiIdPrefix) {
        if (xmiIdPrefix == null) {
            xmiIdPrefix = "_";
        }
        XMIUtils.assignIds(resource, new LinearPrefixedIdCreator(xmiIdPrefix), new ExcludedEClassIdFilter(new EClass[]{XMLTypePackage.Literals.ANY_TYPE, EcorePackage.Literals.EGENERIC_TYPE}));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcludedEClassIdFilter
    implements IdFilter {
        protected final Set<EClass> excludedClasses;

        public ExcludedEClassIdFilter(EClass[] excludedClasses) {
            this.excludedClasses = new HashSet<EClass>();
            EClass[] eClassArray = excludedClasses;
            int n = excludedClasses.length;
            int n2 = 0;
            while (n2 < n) {
                EClass excludedClass = eClassArray[n2];
                this.excludedClasses.add(excludedClass);
                ++n2;
            }
        }

        public ExcludedEClassIdFilter(Set<EClass> excludedClasses) {
            this.excludedClasses = excludedClasses;
        }

        @Override
        public boolean createId(EObject eObject) {
            EClass eClass = eObject.eClass();
            for (EClass excludedClass : this.excludedClasses) {
                if (!excludedClass.isSuperTypeOf(eClass)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HierachicalENamedElementIdCreator
    implements IdCreator {
        @Override
        public String createId(EObject eObject, Set<String> knownIds) {
            ArrayList<String> uriFragmentPath = new ArrayList<String>();
            EObject container = eObject.eContainer();
            while (container != null) {
                uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment((EStructuralFeature)eObject.eContainmentFeature(), eObject));
                eObject = container;
                container = eObject.eContainer();
            }
            StringBuffer result = eObject instanceof ENamedElement ? new StringBuffer(((ENamedElement)eObject).getName()) : new StringBuffer("_" + Integer.toString(eObject.eResource().getContents().indexOf((Object)eObject)));
            ListIterator i = uriFragmentPath.listIterator(uriFragmentPath.size());
            while (i.hasPrevious()) {
                result.append('.');
                result.append((String)i.previous());
            }
            return result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IdCreator {
        public String createId(EObject var1, Set<String> var2);
    }

    public static interface IdFilter {
        public boolean createId(EObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinearPrefixedIdCreator
    implements IdCreator {
        protected final String prefix;
        private int next;

        public LinearPrefixedIdCreator(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String createId(EObject eObject, Set<String> knownIds) {
            String id;
            do {
                id = String.valueOf(this.prefix) + ++this.next;
            } while (knownIds != null && knownIds.contains(id));
            return id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortPrefixedIdCreator
    implements IdCreator {
        protected final String prefix;

        public ShortPrefixedIdCreator(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String createId(EObject eObject, Set<String> knownIds) {
            int knownSize = knownIds != null ? knownIds.size() : 1;
            int multiplier = Math.max(10, 10 * knownSize);
            while (true) {
                int tries = 0;
                while (tries < 10) {
                    String id = String.valueOf(this.prefix) + (int)(Math.random() * (double)multiplier);
                    if (knownIds == null || !knownIds.contains(id)) {
                        return id;
                    }
                    ++tries;
                }
                multiplier *= 10;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UUIDCreator
    implements IdCreator {
        @Override
        public String createId(EObject eObject, Set<String> knownIds) {
            String uuid;
            do {
                uuid = EcoreUtil.generateUUID();
            } while (knownIds != null && knownIds.contains(uuid));
            return uuid;
        }
    }
}

