/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.commands;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class PageChangeDialog
extends MessageDialog {
    protected static final String[] buttonLabels = new String[]{"Update", "Revert", "Resume"};
    protected static final int UPDATE_BUTTON = 0;
    protected static final int REVERT_BUTTON = 1;
    protected static final int RESUME_BUTTON = 2;
    protected boolean canRevert;
    protected boolean canUpdate;
    protected String reasonNotToDeactivate;

    public PageChangeDialog(Shell shell, String newTitle, String oldTitle, String fileName, String reasonNotToDeactivate, boolean canUpdate, boolean canRevert) {
        super(shell, "Update " + fileName + " Resource", null, null, reasonNotToDeactivate != null ? 1 : 3, buttonLabels, reasonNotToDeactivate != null ? 2 : 0);
        this.canRevert = canRevert;
        this.canUpdate = canUpdate;
        StringBuffer s = new StringBuffer();
        if (reasonNotToDeactivate != null) {
            s.append(String.valueOf(reasonNotToDeactivate) + "\n");
        } else {
            s.append("'" + oldTitle + "' page has been modified.\n");
        }
        s.append("\n  Update - accept changes to '" + oldTitle + "' page");
        s.append("\n               - reconcile and edit '" + newTitle + "' page");
        s.append("\n\n  Revert - discard changes to '" + oldTitle + "' page");
        s.append("\n            - revert to editing '" + newTitle + "' page");
        s.append("\n\n  Resume - continue editing '" + oldTitle + "' page");
        this.message = s.toString();
    }

    public void create() {
        super.create();
        if (!this.canUpdate) {
            this.getButton(0).setEnabled(false);
        }
        if (!this.canRevert) {
            this.getButton(1).setEnabled(false);
        }
    }

    public boolean isResume() {
        return this.getReturnCode() == 2;
    }

    public boolean isRevert() {
        return this.getReturnCode() == 1;
    }

    public boolean isUpdate() {
        return this.getReturnCode() == 0;
    }
}

