/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.utils.StreamUtils;

public class BuilderUtils {
    public static String extractContentsToString(String inFileName) {
        if (inFileName == null || inFileName.length() == 0) {
            throw new IllegalArgumentException("BuilderUtils.extractContentsToString(): file name is null or empty");
        }
        File inFile = new File(inFileName);
        if (!inFile.exists() || !inFile.canRead()) {
            throw new IllegalArgumentException("BuilderUtils.extractContentsToString(): file does not exist or cannot be read (name = " + inFileName + ")");
        }
        return BuilderUtils.getFileContents(inFile);
    }

    public static String getFileContents(IFile file) {
        try {
            return StreamUtils.readStreamContents(file.getContents());
        }
        catch (CoreException e) {
            System.err.println(e.getMessage());
            return "";
        }
    }

    public static String getFileContents(File file) {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fnf) {
            System.err.println(fnf.getMessage());
            return "";
        }
        return StreamUtils.readStreamContents(fileStream);
    }

    public static String getFileContents(Reader reader) {
        StringBuilder sb = new StringBuilder(4096);
        char[] buff = new char[4096];
        while (true) {
            int len;
            try {
                len = reader.read(buff);
            }
            catch (IOException iOException) {
                break;
            }
            if (len < 0) break;
            sb.append(buff, 0, len);
        }
        return sb.toString();
    }
}

