/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IOutliner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class OutlineController
implements IContentOutlinePage,
IModelListener {
    protected Tree tree;
    private IParseController controller;
    private IOutliner outliner;
    private UIJob job;
    private int DELAY = 50;

    public OutlineController(ITextEditor editor, Language language) {
        this.outliner = ServiceFactory.getInstance().getOutliner(language);
        if (this.outliner != null) {
            this.outliner.setEditor(editor);
        }
    }

    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.SYNTACTIC_ANALYSIS;
    }

    public void createControl(Composite parent) {
        this.tree = new Tree(parent, 0);
        if (this.outliner != null) {
            this.outliner.setTree(this.tree);
        }
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.tree;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public void update(IParseController result, IProgressMonitor monitor) {
        if (this.outliner == null) {
            return;
        }
        this.controller = result;
        if (this.job != null) {
            this.job.cancel();
        } else {
            this.job = new UIJob("Outline View Controller" + result.toString()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    int offset = 0;
                    try {
                        OutlineController.this.outliner.createOutlinePresentation(OutlineController.this.controller, offset);
                    }
                    catch (Throwable e) {
                        ErrorHandler.reportError("Outline View Controller", e);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.job.schedule((long)this.DELAY);
    }
}

