/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.model.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.IWorkspaceModel;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.model.internal.ResourceUtility;
import org.eclipse.imp.runtime.RuntimePlugin;

public class SourceFolder
implements ISourceFolder {
    private static final ISourceEntity[] NO_CHILDREN = new ISourceEntity[0];
    private final ISourceProject fSrcProject;
    private final IPath fProjRelPath;

    public SourceFolder(ISourceProject srcProject, IPath projRelPath) {
        this.fSrcProject = srcProject;
        this.fProjRelPath = projRelPath;
    }

    public String getName() {
        return this.fProjRelPath.lastSegment();
    }

    public ISourceEntity[] getChildren() {
        Set<IResource> children = ResourceUtility.getImmediateChildren(this.fSrcProject.getRawProject().findMember(this.fProjRelPath));
        HashSet<ISourceEntity> result = new HashSet<ISourceEntity>();
        for (IResource child : children) {
            try {
                result.add(ModelFactory.open(child));
            }
            catch (ModelFactory.ModelException e) {
                RuntimePlugin.getInstance().logException(e.getMessage(), e);
            }
        }
        return result.toArray(new ISourceEntity[children.size()]);
    }

    public ISourceEntity getParent() {
        try {
            if (this.fProjRelPath.segmentCount() > 1) {
                return ModelFactory.open(this.fSrcProject.getRawProject().findMember(this.fProjRelPath.removeLastSegments(1)));
            }
            return this.fSrcProject;
        }
        catch (ModelFactory.ModelException e) {
            RuntimePlugin.getInstance().logException("Error retrieving parent of source folder " + this, e);
            return null;
        }
    }

    public ISourceEntity getAncestor(Class ofType) {
        if (ofType == ISourceProject.class) {
            return this.fSrcProject;
        }
        if (ofType == IWorkspaceModel.class) {
            return ModelFactory.getModelRoot();
        }
        if (ofType == ISourceFolder.class) {
            return this;
        }
        return null;
    }

    public IPath getPath() {
        return this.fProjRelPath;
    }

    public ISourceProject getSrcProject() {
        return this.fSrcProject;
    }

    public IResource getResource() {
        return this.fSrcProject.getRawProject().findMember(this.fProjRelPath);
    }

    public void commit(IProgressMonitor monitor) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceFolder)) {
            return false;
        }
        SourceFolder other = (SourceFolder)obj;
        return this.fSrcProject.equals(other.fSrcProject) && this.fProjRelPath.equals((Object)other.fProjRelPath);
    }

    public int hashCode() {
        int result = 199;
        result = result * 5827 + this.fSrcProject.hashCode();
        result = result * 4639 + this.fProjRelPath.hashCode();
        return result;
    }

    public String toString() {
        return "<source folder @ " + this.fSrcProject.getRawProject().getName() + " : " + this.fProjRelPath.toPortableString() + ">";
    }
}

