/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.BasicRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.RootRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Region2Depth;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameReservation;

public class QVTs2QVTiVisitor
extends AbstractExtendingQVTscheduleVisitor<Element, Object> {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull QVTimperativeHelper helper;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull Transformation qvtmTransformation;
    protected final @NonNull SymbolNameReservation symbolNameReservation;
    protected final @NonNull Transformation qvtiTransformation;
    protected final @NonNull Map<@NonNull TypedModel, @NonNull ImperativeTypedModel> qvtmTypedModel2qvtiTypedModel = new HashMap<TypedModel, ImperativeTypedModel>();
    protected final @NonNull List<@NonNull ImperativeTypedModel> checkableTypedModels = new ArrayList<ImperativeTypedModel>();
    protected final @NonNull List<@NonNull ImperativeTypedModel> checkableAndEnforceableTypedModels = new ArrayList<ImperativeTypedModel>();
    protected final @NonNull List<@NonNull ImperativeTypedModel> enforceableTypedModels = new ArrayList<ImperativeTypedModel>();
    protected final @NonNull Map<@NonNull Region, @NonNull AbstractRegion2Mapping> region2region2mapping = new HashMap<Region, AbstractRegion2Mapping>();
    private @Nullable Set<@NonNull String> reservedNames = null;
    private @NonNull Map<@NonNull Operation, @NonNull Operation> qvtmOperation2qvtiOperation = new HashMap<Operation, Operation>();
    private final @NonNull Region2Depth region2depth = new Region2Depth();
    private final @NonNull Set<@NonNull Transformation> otherTransformations = new HashSet<Transformation>();
    private final @NonNull Map<@NonNull String, @NonNull Operation> name2operation = new HashMap<String, Operation>();
    private ImperativeTypedModel qvtiMiddleTypedModel = null;

    public QVTs2QVTiVisitor(@NonNull ScheduleManager scheduleManager, @NonNull ProblemHandler problemHandler, @NonNull QVTimperativeHelper helper, @NonNull Transformation qvtmTransformation, @NonNull SymbolNameReservation symbolNameReservation) {
        super(null);
        this.scheduleManager = scheduleManager;
        this.helper = helper;
        this.environmentFactory = helper.getEnvironmentFactory();
        this.problemHandler = problemHandler;
        this.qvtmTransformation = qvtmTransformation;
        this.symbolNameReservation = symbolNameReservation;
        String transformationName = qvtmTransformation.getName();
        assert (transformationName != null);
        this.qvtiTransformation = helper.createTransformation(transformationName);
        this.createTypedModels();
    }

    private void accumulateOperations(@NonNull Transformation transformation) {
        if (this.otherTransformations.add(transformation)) {
            TreeIterator tit = transformation.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Operation)) continue;
                Operation operation = (Operation)eObject;
                String name = String.valueOf(operation);
                this.name2operation.put(name, operation);
            }
        }
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    public @Nullable Operation create(@Nullable Operation pOperation) {
        if (pOperation == null) {
            return null;
        }
        Operation iOperation = this.qvtmOperation2qvtiOperation.get(pOperation);
        if (iOperation == null) {
            Transformation containingTransformation = QVTbaseUtil.basicGetContainingTransformation((EObject)pOperation);
            if (containingTransformation == this.qvtmTransformation) {
                iOperation = (Operation)EcoreUtil.copy((EObject)pOperation);
                assert (iOperation != null);
                this.qvtmOperation2qvtiOperation.put(pOperation, iOperation);
                this.qvtiTransformation.getOwnedOperations().add(iOperation);
            } else {
                Operation otherOperation;
                if (containingTransformation != null) {
                    this.accumulateOperations(containingTransformation);
                }
                if ((otherOperation = this.name2operation.get(pOperation.toString())) != null) {
                    iOperation = (Operation)EcoreUtil.copy((EObject)pOperation);
                    assert (iOperation != null);
                    this.qvtmOperation2qvtiOperation.put(pOperation, iOperation);
                    this.qvtiTransformation.getOwnedOperations().add(iOperation);
                } else {
                    iOperation = pOperation;
                    this.qvtmOperation2qvtiOperation.put(pOperation, iOperation);
                }
            }
        }
        return iOperation;
    }

    public void createRegion2Mapping(@NonNull Region region) {
        AbstractRegion2Mapping region2mapping = this.region2region2mapping.get(region);
        assert (region2mapping == null) : "Re-AbstractRegion2Mapping for " + region;
        region2mapping = region.isLoadingRegion() ? new RootRegion2Mapping(this, (LoadingRegion)region) : new BasicRegion2Mapping(this, region);
        region2mapping.synthesizeLocalStatements();
        this.region2region2mapping.put(region, region2mapping);
        this.qvtiTransformation.getRule().add((Object)region2mapping.getMapping());
        region.accept((Visitor)this);
    }

    protected void createTypedModels() {
        for (TypedModel qvtmTypedModel : this.qvtmTransformation.getModelParameter()) {
            String typedModelName = qvtmTypedModel.getName();
            assert (typedModelName != null);
            ImperativeTypedModel qvtiTypedModel = this.helper.createTypedModel(typedModelName);
            qvtiTypedModel.getUsedPackage().addAll((Collection)qvtmTypedModel.getUsedPackage());
            if ("middle".equals(typedModelName)) {
                assert (this.qvtiMiddleTypedModel == null);
                this.qvtiMiddleTypedModel = qvtiTypedModel;
            }
            this.qvtmTypedModel2qvtiTypedModel.put(qvtmTypedModel, qvtiTypedModel);
            this.qvtiTransformation.getModelParameter().add((Object)qvtiTypedModel);
        }
        for (Rule rule : this.qvtmTransformation.getRule()) {
            for (Domain domain : rule.getDomain()) {
                ImperativeTypedModel enforceableTypedModel;
                ImperativeTypedModel checkableTypedModel;
                if (domain.isIsCheckable() && (checkableTypedModel = this.qvtmTypedModel2qvtiTypedModel.get(QVTcoreUtil.getTypedModel((Domain)domain))) != null && !this.checkableAndEnforceableTypedModels.contains(checkableTypedModel)) {
                    checkableTypedModel.setIsChecked(true);
                    if (this.enforceableTypedModels.contains(checkableTypedModel)) {
                        this.checkableAndEnforceableTypedModels.add(checkableTypedModel);
                        this.enforceableTypedModels.remove(checkableTypedModel);
                    } else if (!this.checkableTypedModels.contains(checkableTypedModel)) {
                        this.checkableTypedModels.add(checkableTypedModel);
                    }
                }
                if (!domain.isIsEnforceable() || (enforceableTypedModel = this.qvtmTypedModel2qvtiTypedModel.get(QVTcoreUtil.getTypedModel((Domain)domain))) == null || this.checkableAndEnforceableTypedModels.contains(enforceableTypedModel)) continue;
                enforceableTypedModel.setIsEnforced(true);
                if (this.checkableTypedModels.contains(enforceableTypedModel)) {
                    this.checkableAndEnforceableTypedModels.add(enforceableTypedModel);
                    this.checkableTypedModels.remove(enforceableTypedModel);
                    continue;
                }
                if (this.enforceableTypedModels.contains(enforceableTypedModel)) continue;
                this.enforceableTypedModels.add(enforceableTypedModel);
            }
        }
    }

    protected void gatherReservedPackageNames(@NonNull Set<@NonNull String> reservedNames, @NonNull Iterable<Package> asPackages) {
        for (Package asPackage : asPackages) {
            reservedNames.add((String)ClassUtil.nonNullState((Object)asPackage.getName()));
            this.gatherReservedClassNames(reservedNames, asPackage.getOwnedClasses());
            this.gatherReservedPackageNames(reservedNames, asPackage.getOwnedPackages());
        }
    }

    protected void gatherReservedClassNames(@NonNull Set<@NonNull String> reservedNames, @NonNull Iterable<Class> asClasses) {
        for (Class asClass : asClasses) {
            reservedNames.add((String)ClassUtil.nonNullState((Object)asClass.getName()));
        }
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull Operation getEqualsOperation() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
        assert (operation1 != null);
        OperationId oclAnyEqualsId = operation1.getOperationId();
        return this.environmentFactory.getIdResolver().getOperation(oclAnyEqualsId);
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull Operation getNotEqualsOperation() {
        StandardLibrary standardLibrary = this.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"<>");
        assert (operation1 != null);
        OperationId oclAnyEqualsId = operation1.getOperationId();
        return this.environmentFactory.getIdResolver().getOperation(oclAnyEqualsId);
    }

    public @Nullable ImperativeTypedModel getQVTiTypedModel(@Nullable TypedModel qvtmTypedModel) {
        if (qvtmTypedModel == null) {
            assert (this.qvtiMiddleTypedModel != null);
            return this.qvtiMiddleTypedModel;
        }
        return this.qvtmTypedModel2qvtiTypedModel.get(qvtmTypedModel);
    }

    public @NonNull Region2Depth getRegion2Depth() {
        return this.region2depth;
    }

    public @NonNull AbstractRegion2Mapping getRegion2Mapping(@NonNull Region region) {
        AbstractRegion2Mapping region2mapping = this.region2region2mapping.get(region);
        assert (region2mapping != null) : "No AbstractRegion2Mapping for " + region;
        return region2mapping;
    }

    public @NonNull Set<@NonNull String> getReservedNames() {
        Set<@NonNull String> reservedNames2 = this.reservedNames;
        if (reservedNames2 == null) {
            this.reservedNames = reservedNames2 = new HashSet<String>();
            Package standardLibraryPackage = this.getStandardLibrary().getPackage();
            this.gatherReservedPackageNames(reservedNames2, Collections.singletonList(standardLibraryPackage));
            reservedNames2.add((String)ClassUtil.nonNull((Object)this.qvtmTransformation.getName()));
            for (TypedModel typedModel : this.qvtmTransformation.getModelParameter()) {
                reservedNames2.add((String)ClassUtil.nonNullState((Object)typedModel.getName()));
                this.gatherReservedPackageNames(reservedNames2, (Iterable<Package>)typedModel.getUsedPackage());
            }
            for (Operation operation : this.qvtmTransformation.getOwnedOperations()) {
                reservedNames2.add((String)ClassUtil.nonNull((Object)operation.getName()));
            }
            for (Property property : this.qvtmTransformation.getOwnedProperties()) {
                reservedNames2.add((String)ClassUtil.nonNull((Object)property.getName()));
            }
        }
        return reservedNames2;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public @NonNull Transformation getTransformation() {
        return this.qvtiTransformation;
    }

    public @NonNull String reserveSymbolName(@NonNull SymbolNameBuilder symbolNameBuilder, @NonNull Object object) {
        return this.symbolNameReservation.reserveSymbolName(symbolNameBuilder, object);
    }

    public @Nullable Element visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public Element visitEdge(@NonNull Edge edge) {
        return this.visiting((Visitable)edge);
    }

    public Element visitEdgeConnection(@NonNull EdgeConnection edgeConnection) {
        return this.visiting((Visitable)edgeConnection);
    }

    public @Nullable Element visitLoadingRegion(@NonNull LoadingRegion loadingRegion) {
        AbstractRegion2Mapping region2mapping = this.getRegion2Mapping((Region)loadingRegion);
        Mapping mapping = region2mapping.getMapping();
        return mapping;
    }

    public @Nullable Element visitMappingRegion(@NonNull MappingRegion mappingRegion) {
        AbstractRegion2Mapping region2mapping = this.getRegion2Mapping((Region)mappingRegion);
        return region2mapping.getMapping();
    }

    public Element visitNavigableEdge(@NonNull NavigableEdge navigableEdge) {
        return this.visitEdge((Edge)navigableEdge);
    }

    public Element visitNode(@NonNull Node node) {
        return this.visiting((Visitable)node);
    }

    public Element visitNodeConnection(@NonNull NodeConnection nodeConnection) {
        return this.visiting((Visitable)nodeConnection);
    }

    public @Nullable Element visitOperationRegion(@NonNull OperationRegion operationRegion) {
        return this.visiting((Visitable)operationRegion);
    }

    public Element visitRegion(@NonNull Region region) {
        return this.visiting((Visitable)region);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Element visitScheduledRegion(@NonNull ScheduledRegion scheduledRegion) {
        ArrayList<@NonNull Object> callableRegions = new ArrayList<Object>();
        callableRegions.add(QVTscheduleUtil.getOwnedLoadingRegion((ScheduledRegion)scheduledRegion));
        for (MappingRegion region : QVTscheduleUtil.getMappingRegions((ScheduledRegion)scheduledRegion)) {
            callableRegions.add(region);
        }
        @NonNull List sortedRegions = QVTscheduleUtil.EarliestRegionComparator.sort(callableRegions);
        for (Region region : sortedRegions) {
            this.createRegion2Mapping(region);
        }
        for (Region region : sortedRegions) {
            AbstractRegion2Mapping region2Mapping = this.getRegion2Mapping(region);
            region2Mapping.synthesizeCallStatements();
        }
        return this.qvtiTransformation;
    }

    public Element visitVariableNode(@NonNull VariableNode variableNode) {
        return this.visitNode((Node)variableNode);
    }
}

