/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MergedPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.CompositePartition;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ConcurrentPartitionMerger
extends AbstractMerger {
    protected final @NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis;
    protected final @NonNull Iterable<@NonNull PartitionAnalysis> partitions;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull Concurrency> merge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull List<@NonNull Concurrency> partitionSchedule) {
        int i = 0;
        while (i < partitionSchedule.size()) {
            Concurrency oldConcurrency = partitionSchedule.get(i);
            if (oldConcurrency.size() > 1) {
                HashMap<@NonNull Region, @NonNull ArrayList<@NonNull PartitionAnalysis>> region2partitions = new HashMap<Region, ArrayList<PartitionAnalysis>>();
                for (PartitionAnalysis partitionAnalysis : oldConcurrency) {
                    Partition partition = partitionAnalysis.getPartition();
                    if (partition instanceof CyclicPartition) continue;
                    Region region = QVTscheduleUtil.getRegion((Partition)partition);
                    ArrayList<@NonNull PartitionAnalysis> partitions = (ArrayList<PartitionAnalysis>)region2partitions.get(region);
                    if (partitions == null) {
                        partitions = new ArrayList<PartitionAnalysis>();
                        region2partitions.put(region, partitions);
                    }
                    partitions.add(partitionAnalysis);
                }
                HashSet<PartitionAnalysis> concurrentPartitionAnalyses = null;
                for (Region region : region2partitions.keySet()) {
                    if (region instanceof CyclicMappingRegion) continue;
                    @NonNull List partitions = (List)region2partitions.get(region);
                    assert (partitions != null);
                    if (partitions.size() <= 1) continue;
                    ConcurrentPartitionMerger concurrentMerger = new ConcurrentPartitionMerger(partitionedTransformationAnalysis, partitions);
                    Map<@NonNull PartitionAnalysis, @Nullable PartitionAnalysis> old2new = concurrentMerger.merge();
                    if (old2new != null) {
                        if (concurrentPartitionAnalyses == null) {
                            concurrentPartitionAnalyses = new HashSet<PartitionAnalysis>();
                            Iterables.addAll(concurrentPartitionAnalyses, oldConcurrency.getPartitionAnalyses());
                        }
                        for (PartitionAnalysis oldPartition : old2new.keySet()) {
                            concurrentPartitionAnalyses.remove(oldPartition);
                            PartitionAnalysis newPartition = old2new.get(oldPartition);
                            assert (newPartition != null);
                            concurrentPartitionAnalyses.add(newPartition);
                        }
                    }
                    if (concurrentPartitionAnalyses == null) continue;
                    Concurrency concurrency = new Concurrency();
                    for (PartitionAnalysis partitionAnalysis : concurrentPartitionAnalyses) {
                        concurrency.add(partitionAnalysis);
                    }
                    partitionSchedule.set(i, concurrency);
                }
            }
            ++i;
        }
        return partitionSchedule;
    }

    protected ConcurrentPartitionMerger(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Iterable<@NonNull PartitionAnalysis> partitions) {
        this.partitionedTransformationAnalysis = partitionedTransformationAnalysis;
        this.partitions = partitions;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable Map<@NonNull PartitionAnalysis, @Nullable PartitionAnalysis> merge() {
        ScheduleManager scheduleManager = this.partitionedTransformationAnalysis.getScheduleManager();
        HashMap<@NonNull Integer, @NonNull HashSet<@NonNull BasicPartitionAnalysis>> hash2partitionAnalyses = new HashMap<Integer, HashSet<BasicPartitionAnalysis>>();
        HashMap<@NonNull BasicPartitionAnalysis, @NonNull Set<@NonNull CheckedCondition>> partion2checkedConditions = new HashMap<BasicPartitionAnalysis, Set<CheckedCondition>>();
        for (PartitionAnalysis partitionAnalysis : this.partitions) {
            BasicPartitionAnalysis basicPartitionAnalysis = (BasicPartitionAnalysis)partitionAnalysis;
            CheckedConditionAnalysis checkedConditionAnalysis = new CheckedConditionAnalysis(basicPartitionAnalysis, scheduleManager);
            Set<@NonNull CheckedCondition> checkedConditions = checkedConditionAnalysis.computeCheckedConditions();
            if (checkedConditions.size() <= 0) continue;
            int hash = checkedConditions.hashCode();
            partion2checkedConditions.put(basicPartitionAnalysis, checkedConditions);
            HashSet<@NonNull BasicPartitionAnalysis> hashPartitionAnalyses = (HashSet<BasicPartitionAnalysis>)hash2partitionAnalyses.get(hash);
            if (hashPartitionAnalyses == null) {
                hashPartitionAnalyses = new HashSet<BasicPartitionAnalysis>();
                hash2partitionAnalyses.put(hash, hashPartitionAnalyses);
            }
            hashPartitionAnalyses.add(basicPartitionAnalysis);
        }
        HashMap<@NonNull PartitionAnalysis, @Nullable PartitionAnalysis> old2new = new HashMap<PartitionAnalysis, PartitionAnalysis>();
        for (Set hashPartitionAnalyses : hash2partitionAnalyses.values()) {
            if (hashPartitionAnalyses.size() <= 1) continue;
            ArrayList<BasicPartitionAnalysis> merges = null;
            ArrayList<@NonNull E> residualHashPartitionAnalyses = new ArrayList(hashPartitionAnalyses);
            int i = 0;
            while (i < residualHashPartitionAnalyses.size()) {
                BasicPartitionAnalysis iPartitionAnalysis = (BasicPartitionAnalysis)residualHashPartitionAnalyses.get(i);
                BasicPartition iPartition = (BasicPartition)iPartitionAnalysis.getPartition();
                CompositePartition iContainer = iPartition.getOwningCompositePartition();
                List iPasses = iPartition.getPasses();
                @NonNull Set iCheckedConditions = (Set)partion2checkedConditions.get(iPartitionAnalysis);
                assert (iCheckedConditions != null);
                int j = residualHashPartitionAnalyses.size();
                while (--j > i) {
                    BasicPartitionAnalysis jPartitionAnalysis = (BasicPartitionAnalysis)residualHashPartitionAnalyses.get(j);
                    BasicPartition jPartition = (BasicPartition)jPartitionAnalysis.getPartition();
                    CompositePartition jContainer = jPartition.getOwningCompositePartition();
                    List jPasses = jPartition.getPasses();
                    if (iContainer != jContainer || !iPasses.equals(jPasses)) continue;
                    @NonNull Set jCheckedConditions = (Set)partion2checkedConditions.get(jPartitionAnalysis);
                    assert (jCheckedConditions != null);
                    if (!iCheckedConditions.equals(jCheckedConditions)) continue;
                    if (merges == null) {
                        merges = new ArrayList<BasicPartitionAnalysis>();
                        merges.add(iPartitionAnalysis);
                    }
                    merges.add(jPartitionAnalysis);
                    residualHashPartitionAnalyses.remove(j);
                }
                ++i;
            }
            if (merges == null) continue;
            System.out.println("Concurrent Merge " + merges);
            BasicPartition firstPartition = (BasicPartition)((BasicPartitionAnalysis)merges.get(0)).getPartition();
            CompositePartition owningCompositePartition = firstPartition.getOwningCompositePartition();
            assert (owningCompositePartition != null);
            AbstractCompositePartitionAnalysis compositePartitionAnalysis = (AbstractCompositePartitionAnalysis)this.partitionedTransformationAnalysis.getPartitionAnalysis((Partition)owningCompositePartition);
            List ownedMappingPartitions = owningCompositePartition.getOwnedMappingPartitions();
            MergedPartitionFactory mergedPartitionFactory = new MergedPartitionFactory(scheduleManager, QVTscheduleUtil.getRegion((Partition)firstPartition), (Iterable<BasicPartitionAnalysis>)merges);
            BasicPartitionAnalysis mergedPartitionAnalysis = mergedPartitionFactory.createPartitionAnalysis(this.partitionedTransformationAnalysis);
            BasicPartition mergedPartition = (BasicPartition)mergedPartitionAnalysis.getPartition();
            for (BasicPartitionAnalysis partitionAnalysis : merges) {
                old2new.put(partitionAnalysis, mergedPartitionAnalysis);
            }
            Iterator iterator = ((BasicPartition)((BasicPartitionAnalysis)merges.iterator().next()).getPartition()).getPasses().iterator();
            while (iterator.hasNext()) {
                int pass = (Integer)iterator.next();
                mergedPartition.addPass(pass);
            }
            scheduleManager.writeDebugGraphs((Graphable)mergedPartition, null);
            ownedMappingPartitions.add(mergedPartition);
            compositePartitionAnalysis.merge(old2new);
        }
        return old2new;
    }
}

