/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtimperative.tests;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiIncrementalExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.ModelNormalizer;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtimperative.tests.ManualRDBMSNormalizer;
import org.eclipse.qvtd.xtext.qvtimperative.tests.SimpleRDBMSNormalizer;
import org.eclipse.xtext.util.EmfFormatter;
import org.junit.Before;
import org.junit.Test;

public class QVTiInterpreterTests
extends LoadTestCase {
    public static void assertSameModel(Resource expectedResource, Resource actualResource) throws IOException, InterruptedException {
        String expected = EmfFormatter.listToStr((List)expectedResource.getContents());
        String actual = EmfFormatter.listToStr((List)actualResource.getContents());
        QVTiInterpreterTests.assertEquals((String)expected, (String)actual);
    }

    protected void assertLoadable(@NonNull URI asURI) throws Exception {
        this.assertLoadable(this.getTestProject(), asURI);
    }

    protected void assertLoadable(@NonNull TestProject testProject, @NonNull URI asURI) throws Exception {
        ProjectManager projectManager = this.getTestProjectManager();
        OCL ocl = OCL.newInstance((ProjectManager)projectManager);
        ResourceSet asResourceSet = ocl.getMetamodelManager().getASResourceSet();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLstdlib.install();
            ((OCLInternal)ocl).getMetamodelManager().getASmetamodel();
        }
        Resource resource = asResourceSet.getResource(asURI, true);
        assert (resource != null);
        EcoreUtil.resolveAll((Resource)resource);
        QVTiInterpreterTests.assertNoUnresolvedProxies((String)"Loading", (Resource)resource);
        QVTiInterpreterTests.assertNoResourceErrors((String)"Loading", (Resource)resource);
        ocl.dispose();
    }

    protected @NonNull OCLInternal createOCL() {
        return QVTimperative.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected @NonNull MyQVT createQVT() throws Exception {
        ProjectManager projectManager = this.getTestProjectManager();
        MyQVT myQVT = new MyQVT(new QVTiEnvironmentFactory(projectManager, null));
        return myQVT;
    }

    @Before
    public void setUp() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        XtextCompilerUtil.doQVTimperativeSetup();
        super.setUp();
    }

    @Test
    public void testQVTiInterpreter_Graph2GraphMinimal() throws Exception {
        URI txURI = this.getModelsURI("Graph2GraphMinimal/Graph2GraphMinimal.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        MyQvtiExecutor testEvaluator = myQVT.createEvaluator(txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("upperGraph", this.getModelsURI("Graph2GraphMinimal/SimpleGraph.xmi"));
        testEvaluator.createModel("middle", this.getTestURI("Graph2Graph.xmi"));
        testEvaluator.createModel("lowerGraph", this.getTestURI("Graph2GraphMinimal.xmi"));
        testEvaluator.loadReference("lowerGraph", this.getModelsURI("Graph2GraphMinimal/Graph2GraphMinimalValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.saveExecutionGraph(this.getTestURI("Graph2GraphMinimal_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Graph2GraphHierarchical() throws Exception {
        URI txURI = this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchical.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        MyQvtiExecutor testEvaluator = myQVT.createEvaluator(txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("upperGraph", this.getModelsURI("Graph2GraphMinimal/SimpleGraph.xmi"));
        testEvaluator.createModel("middle", this.getTestURI("Graph2Graph.xmi"));
        testEvaluator.createModel("lowerGraph", this.getTestURI("Graph2GraphHierarchical.xmi"));
        testEvaluator.loadReference("lowerGraph", this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchicalValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.saveExecutionGraph(this.getTestURI("Graph2GraphMinimal_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Graph2GraphHierarchicalLoad() throws Exception {
        URI asURI = this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchical.ref.qvtias");
        this.assertLoadable(asURI);
    }

    @Test
    public void testQVTiInterpreter_HSV2HSL() throws Exception {
        MyQVT myQVT = this.createQVT();
        URI txURI = this.getModelsURI("HSV2HSL/HSV2HSL.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQvtiExecutor testEvaluator = myQVT.createEvaluator(txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("hsv", this.getModelsURI("HSV2HSL/HSVNode.xmi"));
        testEvaluator.createModel("middle", this.getTestURI("HSL2HSLNode.xmi"));
        testEvaluator.createModel("hsl", this.getTestURI("HSLNode.xmi"));
        testEvaluator.loadReference("hsl", this.getModelsURI("HSV2HSL/HSLNodeValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.saveExecutionGraph(this.getTestURI("HSV2HSL_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Tree2TallTreeIncremental() throws Exception {
        URI txURI = this.getModelsURI("Tree2TallTree/Tree2TallTree.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        MyQvtiExecutor testEvaluator = myQVT.createEvaluator(txURI, QVTiIncrementalExecutor.Mode.INCREMENTAL);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("tree", this.getModelsURI("Tree2TallTree/samples/Tree.xmi"));
        testEvaluator.createModel("tree2talltree", this.getTestURI("Tree2TallTree.xmi"));
        testEvaluator.createModel("talltree", this.getTestURI("TallTree.xmi"));
        testEvaluator.loadReference("talltree", this.getModelsURI("Tree2TallTree/samples/TallTreeValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.writeExecutionGraphMLfile(this.getTestURI("Tree2TallTree-execution.graphml"));
        testEvaluator.saveExecutionGraph(this.getTestURI("Tree2TallTree_INCREMENTAL.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Tree2TallTreeLazy() throws Exception {
        URI txURI = this.getModelsURI("Tree2TallTree/Tree2TallTree.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        MyQvtiExecutor testEvaluator = myQVT.createEvaluator(txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("tree", this.getModelsURI("Tree2TallTree/samples/Tree.xmi"));
        testEvaluator.createModel("tree2talltree", this.getTestURI("Tree2TallTree.xmi"));
        testEvaluator.createModel("talltree", this.getTestURI("TallTree.xmi"));
        testEvaluator.loadReference("talltree", this.getModelsURI("Tree2TallTree/samples/TallTreeValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.saveExecutionGraph(this.getTestURI("Tree2TallTree_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ManualUML2RDBMS() throws Exception {
        URI txURI = this.getModelsURI("ManualUML2RDBMS/ManualUML2RDBMS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        TestUtil.doCompleteOCLSetup();
        URI oclURI = this.getResourceURI("org.eclipse.qvtd.pivot.qvtimperative/model/QVTimperative.ocl");
        CompleteOCLEObjectValidator completeOCLEObjectValidator2 = new CompleteOCLEObjectValidator((EPackage)ClassUtil.nonNullState((Object)QVTimperativePackage.eINSTANCE), oclURI, (EnvironmentFactory)myQVT.getEnvironmentFactory());
        MyQvtiExecutor testEvaluator = myQVT.createEvaluator(txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("uml", this.getModelsURI("ManualUML2RDBMS/ManualUMLPeople.xmi"));
        testEvaluator.createModel("middle", this.getTestURI("ManualUML2RDBMS.xmi"));
        testEvaluator.createModel("rdbms", this.getTestURI("ManualRDBMSPeople.xmi"));
        testEvaluator.loadReference("rdbms", this.getModelsURI("ManualUML2RDBMS/ManualRDBMSPeopleValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(ManualRDBMSNormalizer.INSTANCE);
        testEvaluator.saveExecutionGraph(this.getTestURI("ManualUML2RDBMS_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_SimpleUML2RDBMS() throws Exception {
        URI txURI = this.getModelsURI("SimpleUML2RDBMS/SimpleUML2RDBMS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        TestUtil.doCompleteOCLSetup();
        URI oclURI = this.getResourceURI("org.eclipse.qvtd.pivot.qvtimperative/model/QVTimperative.ocl");
        QVTiEnvironmentFactory environmentFactory = myQVT.getEnvironmentFactory();
        CompleteOCLEObjectValidator completeOCLEObjectValidator2 = new CompleteOCLEObjectValidator((EPackage)ClassUtil.nonNullState((Object)QVTimperativePackage.eINSTANCE), oclURI, (EnvironmentFactory)environmentFactory);
        MyQvtiExecutor testEvaluator = new MyQvtiExecutor(environmentFactory, txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("uml", this.getModelsURI("SimpleUML2RDBMS/SimpleUMLPeople.xmi"));
        testEvaluator.createModel("middle", this.getTestURI("SimpleUML2RDBMS.xmi"));
        testEvaluator.createModel("rdbms", this.getTestURI("SimpleRDBMSPeople.xmi"));
        testEvaluator.loadReference("rdbms", this.getModelsURI("SimpleUML2RDBMS/SimpleRDBMSPeopleValidate.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(SimpleRDBMSNormalizer.INSTANCE);
        testEvaluator.saveExecutionGraph(this.getTestURI("SimpleUML2RDBMS_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ClassesCS2AS_bug456900() throws Exception {
        URI txURI = this.getModelsURI("ClassesCS2AS/bug456900/ClassesCS2AS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        QVTiEnvironmentFactory environmentFactory = myQVT.getEnvironmentFactory();
        MyQvtiExecutor testEvaluator = new MyQvtiExecutor(environmentFactory, txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("leftCS", this.getModelsURI("ClassesCS2AS/bug456900/example_input.xmi"));
        testEvaluator.createModel("rightAS", this.getTestURI("example_output.xmi"));
        testEvaluator.loadReference("rightAS", this.getModelsURI("ClassesCS2AS/bug456900/example_output_ref.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.saveExecutionGraph(this.getTestURI("ClassesCS2AS_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ClassesCS2AS_bug457239() throws Exception {
        TestUtil.doCompleteOCLSetup();
        URI txURI = this.getModelsURI("ClassesCS2AS/bug457239/ClassesCS2AS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        MyQVT myQVT = this.createQVT();
        MyQvtiExecutor testEvaluator = new MyQvtiExecutor(myQVT.getEnvironmentFactory(), txURI, QVTiIncrementalExecutor.Mode.LAZY);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        testEvaluator.loadModel("leftCS", this.getModelsURI("ClassesCS2AS/bug457239/example_input.xmi"));
        testEvaluator.createModel("rightAS", this.getTestURI("example_output.xmi"));
        testEvaluator.loadReference("rightAS", this.getModelsURI("ClassesCS2AS/bug457239/example_output_ref.xmi"));
        testEvaluator.test();
        testEvaluator.saveModels(this.getTestURI("middle.xmi"));
        testEvaluator.checkModels(null);
        testEvaluator.saveExecutionGraph(this.getTestURI("ClassesCS2AS_LAZY.graphml"));
        testEvaluator.dispose();
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ClassesCS2AS_bug457239b() throws Exception {
        TestUtil.doCompleteOCLSetup();
        MyQVT myQVT = this.createQVT();
        URI txURI = this.getModelsURI("ClassesCS2AS/bug457239/ClassesCS2ASv2_AS.qvtias");
        this.assertLoadable((URI)ClassUtil.nonNullState((Object)txURI));
        QVTiEnvironmentFactory environmentFactory = myQVT.getEnvironmentFactory();
        QVTiIncrementalExecutor testExecutor = new QVTiIncrementalExecutor(environmentFactory, (ImperativeTransformation)ClassUtil.nonNullState((Object)QVTiInterpreterTests.loadTransformation((MetamodelManager)environmentFactory.getMetamodelManager(), txURI)), QVTiIncrementalExecutor.Mode.LAZY);
        URI csModelURI = this.getModelsURI("ClassesCS2AS/bug457239/example_input.xmi");
        URI asModelURI = this.getTestURI("example_output.xmi");
        URI refAsModelURI = this.getModelsURI("ClassesCS2AS/bug457239/exampleV2_output_ref.xmi");
        testExecutor.loadModel("leftCS", (URI)ClassUtil.nonNullState((Object)csModelURI));
        testExecutor.createModel("rightAS", (URI)ClassUtil.nonNullState((Object)asModelURI), null);
        testExecutor.execute();
        testExecutor.saveModels(DefaultCompilerOptions.defaultSavingOptions);
        testExecutor.dispose();
        ResourceSet rSet = environmentFactory.getResourceSet();
        QVTiInterpreterTests.assertSameModel(rSet.getResource(refAsModelURI, true), rSet.getResource(asModelURI, true));
        myQVT.dispose();
    }

    protected static Transformation loadTransformation(MetamodelManager metamodelManager, URI txURI) {
        Resource txResource = metamodelManager.getASResourceSet().getResource(txURI, true);
        ImperativeModel iModel = (ImperativeModel)txResource.getContents().get(0);
        for (Package p : iModel.getOwnedPackages()) {
            for (Class c : p.getOwnedClasses()) {
                if (!(c instanceof Transformation)) continue;
                return (Transformation)c;
            }
        }
        return null;
    }

    protected static class MyQVT
    extends QVTimperative {
        public MyQVT(@NonNull QVTiEnvironmentFactory environmentFactory) {
            super(environmentFactory);
        }

        public @NonNull MyQvtiExecutor createEvaluator(@NonNull URI txURI, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull QVTiIncrementalExecutor.Mode mode) throws IOException {
            return new MyQvtiExecutor(this.getEnvironmentFactory(), txURI, mode);
        }
    }

    private static class MyQvtiExecutor
    extends QVTiIncrementalExecutor {
        protected final @NonNull Map<ImperativeTypedModel, Resource> typedModelValidationResourceMap = new HashMap<ImperativeTypedModel, Resource>();

        public MyQvtiExecutor(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull QVTiIncrementalExecutor.Mode mode) throws IOException {
            super(environmentFactory, QVTimperativeUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)txURI, (boolean)environmentFactory.keepDebug()), mode);
        }

        public void checkModels(@Nullable ModelNormalizer modelNormalizer) throws IOException, InterruptedException {
            for (Map.Entry<ImperativeTypedModel, Resource> entry : this.typedModelValidationResourceMap.entrySet()) {
                ImperativeTypedModel typedModel = (ImperativeTypedModel)ClassUtil.nonNullState((Object)entry.getKey());
                Resource expectedModel = entry.getValue();
                assert (expectedModel != null);
                Resource actualModel = this.getModelsManager().getModel(typedModel);
                assert (actualModel != null);
                if (modelNormalizer != null) {
                    modelNormalizer.normalize(expectedModel);
                    modelNormalizer.normalize(actualModel);
                }
                QVTiInterpreterTests.assertSameModel(expectedModel, actualModel);
            }
        }

        public void loadReference(@NonNull String name, @NonNull URI modelURI) {
            ImperativeTypedModel typedModel = (ImperativeTypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
            if (typedModel == null) {
                throw new IllegalStateException("Unknown TypedModel '" + name + "'");
            }
            Resource resource = this.environmentFactory.getResourceSet().getResource(modelURI, true);
            this.typedModelValidationResourceMap.put(typedModel, resource);
        }

        public void saveExecutionGraph(@NonNull URI graphmlURI) throws Exception, IOException {
            URIConverter uriConverter = this.getEnvironmentFactory().getResourceSet().getURIConverter();
            GraphMLBuilder s = new GraphMLBuilder();
            OutputStream outputStream = uriConverter.createOutputStream(graphmlURI);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            ((Writer)writer).append(s.toString());
            ((Writer)writer).close();
        }

        public void test() throws Exception {
            boolean result = this.execute();
            QVTiInterpreterTests.assertTrue((String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " should not return null."), (boolean)result);
        }

        public void writeExecutionGraphMLfile(@NonNull URI graphmlURI) {
            URIConverter uriConverter = this.getEnvironmentFactory().getResourceSet().getURIConverter();
            try {
                OutputStream outputStream = uriConverter.createOutputStream(graphmlURI);
                GraphMLStringBuilder s = new GraphMLStringBuilder();
                this.createGraph((GraphStringBuilder)s);
                outputStream.write(s.toString().getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

