/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Group;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Split;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterUtil;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

abstract class AbstractGroup
implements Group {
    protected final @NonNull SplitterAnalysis splitter;
    protected final @NonNull String name;
    private final @NonNull Set<@NonNull Node> reachableNodes;
    private final @NonNull Map<@NonNull Edge, @NonNull List<@NonNull AbstractGroup>> edge2predecessors = new HashMap<Edge, List<AbstractGroup>>();
    private final @NonNull Map<@NonNull Edge, @NonNull AbstractGroup> edge2successor = new HashMap<Edge, AbstractGroup>();
    private final @NonNull Map<@NonNull AbstractGroup, @NonNull List<@NonNull Edge>> predecessor2edges = new HashMap<AbstractGroup, List<Edge>>();
    private final @NonNull LinkedHashMap<@NonNull AbstractGroup, @NonNull Edge> successorGroups = new LinkedHashMap();

    protected AbstractGroup(@NonNull SplitterAnalysis splitter, @NonNull List<@NonNull Node> headNodes) {
        this.splitter = splitter;
        this.name = SplitterUtil.computeMultiHeadNodeName(headNodes);
        this.reachableNodes = SplitterUtil.computeNavigableNodes(headNodes);
    }

    public void addPredecessor(@NonNull Edge edge, @NonNull List<@NonNull AbstractGroup> predecessorGroups) {
        List<@NonNull AbstractGroup> oldPredecessorGroups = this.edge2predecessors.put(edge, predecessorGroups);
        assert (oldPredecessorGroups == null);
        for (AbstractGroup predecessorGroup : predecessorGroups) {
            AbstractGroup oldSuccessorGroup = predecessorGroup.edge2successor.put(edge, this);
            assert (oldSuccessorGroup == null);
            List<@NonNull Edge> edges = this.predecessor2edges.get(predecessorGroup);
            if (edges == null) {
                edges = new ArrayList<Edge>();
                this.predecessor2edges.put(predecessorGroup, edges);
            }
            assert (!edges.contains(edge));
            edges.add(edge);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addSuccessor(@NonNull AbstractGroup successorGroup) {
        @NonNull ArrayList edges = successorGroup.predecessor2edges.get(this);
        assert (edges != null && !edges.isEmpty());
        if (edges.size() > 1) {
            edges = Lists.newArrayList(edges);
            Collections.sort(edges, NameUtil.NAMEABLE_COMPARATOR);
        }
        Edge edge = (Edge)edges.get(0);
        assert (!this.successorGroups.containsKey(successorGroup));
        this.successorGroups.put(successorGroup, edge);
    }

    public void buildSplit(@NonNull Split split, @Nullable SimpleGroup sourceSimpleGroup) {
        for (Map.Entry<AbstractGroup, Edge> entry : this.successorGroups.entrySet()) {
            entry.getKey().buildSplit(split, sourceSimpleGroup, entry.getValue());
        }
    }

    public abstract void computeMutualOrdering(@NonNull Iterable<@NonNull SimpleGroup> var1);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void computeNavigableGroupSchedule(@NonNull Iterable<@NonNull SimpleGroup> simpleGroups) {
        this.computeMutualOrdering(simpleGroups);
        @NonNull ArrayList nestedSimpleGroups = Lists.newArrayList(simpleGroups);
        for (SimpleGroup simpleGroup : this.getInternalSimpleGroups()) {
            nestedSimpleGroups.add(simpleGroup);
        }
        for (AbstractGroup successorGroup : this.successorGroups.keySet()) {
            successorGroup.computeNavigableGroupSchedule(nestedSimpleGroups);
        }
    }

    protected abstract void buildSplit(@NonNull Split var1, @Nullable SimpleGroup var2, @Nullable Edge var3);

    public abstract @NonNull Iterable<@NonNull SimpleGroup> getInternalSimpleGroups();

    public final @NonNull String getName() {
        return this.name;
    }

    public @NonNull Iterable<@NonNull AbstractGroup> getPredecessors() {
        return this.predecessor2edges.keySet();
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getReachableNodes() {
        return this.reachableNodes;
    }

    public @NonNull SplitterAnalysis getSplitter() {
        return this.splitter;
    }

    @Override
    public @NonNull String toString() {
        return this.name;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void toString(@NonNull StringBuilder s, int depth) {
        @NonNull ArrayList sortedGroups = Lists.newArrayList(this.successorGroups.keySet());
        Collections.sort(sortedGroups, NameUtil.NAMEABLE_COMPARATOR);
        for (Group group : sortedGroups) {
            Edge edge = this.successorGroups.get(group);
            assert (edge != null);
            s.append("\n");
            CompilerUtil.indent(s, depth + 1);
            s.append("successor:\n");
            CompilerUtil.indent(s, depth + 2);
            s.append("edge: ");
            s.append(edge.toString());
            s.append("\n");
            group.toString(s, depth + 2);
        }
    }
}

