/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ConnectivityChecker;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.LoadingRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.ConcurrentPartitionMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.SequentialPartitionMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;

public class QVTs2QVTs
extends QVTimperativeHelper {
    protected final @NonNull ScheduleManager directedScheduleManager;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull String rootName;
    private final @NonNull LoadingRegionAnalysis loadingRegionAnalysis;
    protected final @NonNull CompleteModel completeModel;
    private final @NonNull Map<@NonNull Region, @NonNull RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Model, DomainUsage> inputModels = new HashMap<Model, DomainUsage>();
    private final @NonNull StandardLibraryHelper standardLibraryHelper;

    public QVTs2QVTs(@NonNull ProblemHandler problemHandler, @NonNull ScheduleManager directedScheduleManager, @NonNull String rootName) {
        super(directedScheduleManager.getEnvironmentFactory());
        this.directedScheduleManager = directedScheduleManager;
        this.standardLibraryHelper = new StandardLibraryHelper(this.standardLibrary);
        this.problemHandler = problemHandler;
        this.rootName = rootName;
        this.loadingRegionAnalysis = new LoadingRegionAnalysis(directedScheduleManager, this.createLoadingRegion());
        this.completeModel = this.environmentFactory.getCompleteModel();
        directedScheduleManager.createConnectionManager(problemHandler, this.loadingRegionAnalysis);
    }

    private void computeInputModels() {
        for (ClassDatum classDatum : this.directedScheduleManager.getClassDatums()) {
            Model model;
            Class type;
            Package asPackage;
            DomainUsage domainUsage = this.directedScheduleManager.getDomainUsage((Element)classDatum);
            if (!this.directedScheduleManager.isInput(domainUsage) || this.directedScheduleManager.isOutput(domainUsage) || (asPackage = PivotUtil.getContainingPackage((EObject)(type = classDatum.getPrimaryClass()))) == null || "http://www.eclipse.org/ocl/2015/Orphanage".equals(asPackage.getURI()) || (model = PivotUtil.getContainingModel((EObject)type)) == null) continue;
            this.inputModels.put(model, domainUsage);
        }
        if (QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.isActive()) {
            QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.println(this.dumpInputModels().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t")));
        }
    }

    private @NonNull LoadingRegion createRootContainmentRegion(@NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        RootRegion rootRootRegion = rootPartitionAnalysis.getRootRegion();
        LoadingRegion loadingRegion = (LoadingRegion)this.loadingRegionAnalysis.getRegion();
        assert (rootRootRegion.getOwnedLoadingRegion() == loadingRegion);
        this.directedScheduleManager.writeDebugGraphs((Graphable)loadingRegion, null);
        return loadingRegion;
    }

    protected @NonNull LoadingRegion createLoadingRegion() {
        LoadingRegion loadingRegion = QVTscheduleFactory.eINSTANCE.createLoadingRegion();
        loadingRegion.setName(String.valueOf(this.rootName) + "\u00abload\u00bb");
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("__load__");
        loadingRegion.setSymbolName(this.directedScheduleManager.getScheduleModel().reserveSymbolName(s, (Object)loadingRegion));
        TypedModelsConfiguration typedModelsConfiguration = this.directedScheduleManager.getTypedModelsConfiguration();
        loadingRegion.setTargetName(typedModelsConfiguration.getTargetName());
        return loadingRegion;
    }

    private Stream<String> dumpInputModels() {
        Stream<String> entries = this.inputModels.keySet().stream().map(k -> String.valueOf(String.valueOf(k)) + " : " + String.valueOf(this.inputModels.get(k)));
        return entries.sorted();
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = this.directedScheduleManager.getRegionAnalysis(region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.directedScheduleManager;
    }

    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    protected @NonNull PartitionedTransformationAnalysis partition(ScheduleManager scheduleManager, @NonNull RootRegion rootRegion, @NonNull Iterable<? extends @NonNull Region> activeRegions) throws CompilerChainException {
        AbstractTransformationAnalysis transformationAnalysis = scheduleManager.getTransformationAnalysis(rootRegion);
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = transformationAnalysis.partition(this.problemHandler, activeRegions);
        RootPartitionAnalysis rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        rootPartitionAnalysis.setRootRegion(rootRegion);
        return partitionedTransformationAnalysis;
    }

    protected void pruneRedundantConnections(@NonNull ConnectionManager connectionManager, @NonNull RootRegion rootRegion) {
        ArrayList<@NonNull Connection> redundantConnections = null;
        for (Connection connection : QVTscheduleUtil.getOwnedConnections((RootRegion)rootRegion)) {
            if (connection.isPassed() || connection.isMandatory()) continue;
            boolean isRedundant = true;
            int lastPass = connection.getLastPass();
            for (Partition targetPartition : connection.getTargetPartitions()) {
                int firstPass = targetPartition.getFirstPass();
                if (firstPass > lastPass) continue;
                isRedundant = false;
                break;
            }
            if (!isRedundant) continue;
            if (redundantConnections == null) {
                redundantConnections = new ArrayList<Connection>();
            }
            redundantConnections.add(connection);
        }
        if (redundantConnections != null) {
            for (Connection redundantConnection : redundantConnections) {
                redundantConnection.destroy();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void schedule(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        List<Concurrency> partitionSchedule2;
        RootPartitionAnalysis rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        RootPartition rootPartition = (RootPartition)rootPartitionAnalysis.getPartition();
        RootRegion rootRegion = rootPartitionAnalysis.getRootRegion();
        ConnectionManager connectionManager = this.directedScheduleManager.getConnectionManager();
        @NonNull Iterable partitionSchedule = rootPartitionAnalysis.getPartitionSchedule();
        connectionManager.createConnections(rootRegion, partitionSchedule);
        ScheduleAnalysis scheduleAnalysis = new ScheduleAnalysis(partitionedTransformationAnalysis, connectionManager, rootPartitionAnalysis);
        scheduleAnalysis.schedule(rootPartition, (List<Concurrency>)partitionSchedule);
        List activeRegions = rootRegion.getActiveRegions();
        activeRegions.clear();
        List<@NonNull Concurrency> partitionSchedule1 = ConcurrentPartitionMerger.merge(partitionedTransformationAnalysis, (List<Concurrency>)rootPartitionAnalysis.getPartitionSchedule());
        List<@NonNull Concurrency> mergedPartitionSchedule = partitionSchedule2 = SequentialPartitionMerger.merge(partitionedTransformationAnalysis, partitionSchedule1);
        this.computeInputModels();
        this.createRootContainmentRegion(rootPartitionAnalysis);
        ArrayList<@NonNull RootPartition> allRootPartitions = new ArrayList<RootPartition>();
        allRootPartitions.add(rootPartition);
        this.pruneRedundantConnections(connectionManager, rootRegion);
        this.directedScheduleManager.writeDebugGraphs("8-pruned", rootRegion, true, true, false);
        ConnectivityChecker.CONNECTIVITY.isActive();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull RootRegion transform(@NonNull Iterable<@NonNull RuleRegion> activeRegions) throws CompilerChainException {
        RootRegion rootRegion = this.directedScheduleManager.getRootRegion();
        ConnectionManager connectionManager = this.directedScheduleManager.getConnectionManager();
        LoadingRegion loadingRegion = (LoadingRegion)this.loadingRegionAnalysis.getRegion();
        ArrayList<@NonNull PartitionedTransformationAnalysis> partitionedTransformationAnalyses = new ArrayList<PartitionedTransformationAnalysis>();
        assert (rootRegion.getActiveRegions().isEmpty());
        ArrayList<@NonNull LoadingRegion> activeRegions3 = new ArrayList<LoadingRegion>();
        activeRegions3.add(loadingRegion);
        Iterables.addAll(activeRegions3, activeRegions);
        Collections.sort(activeRegions3, NameUtil.NAMEABLE_COMPARATOR);
        rootRegion.getActiveRegions().addAll(activeRegions3);
        StringBuilder s = QVTscheduleConstants.CONNECTION_CREATION.isActive() ? new StringBuilder() : null;
        for (Region region : activeRegions3) {
            if (region instanceof LoadingRegion) continue;
            connectionManager.createIncomingConnections(s, rootRegion, region);
        }
        if (s != null) {
            QVTscheduleConstants.CONNECTION_CREATION.println(s.toString());
        }
        this.directedScheduleManager.writeDebugGraphs("4-pre-partition", rootRegion, true, true, false);
        this.directedScheduleManager.throwCompilerChainExceptionForErrors();
        @NonNull HashSet hashSet = Sets.newHashSet(connectionManager.analyzeStrictness());
        ArrayList<@NonNull Region> explicitlyUniqueRegions = new ArrayList<Region>();
        for (Region region : QVTscheduleUtil.getActiveRegions((RootRegion)rootRegion)) {
            boolean isImplicitStrict = true;
            for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)region)) {
                NodeConnection incomingConnection = headNode.getIncomingConnection();
                if (!hashSet.contains(incomingConnection)) continue;
                isImplicitStrict = false;
                break;
            }
            if (isImplicitStrict) continue;
            explicitlyUniqueRegions.add(region);
        }
        @NonNull Iterable activeRegions2 = QVTscheduleUtil.getActiveRegions((RootRegion)rootRegion);
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = this.partition(this.directedScheduleManager, rootRegion, activeRegions2);
        partitionedTransformationAnalyses.add(partitionedTransformationAnalysis);
        for (Region region : QVTscheduleUtil.getActiveRegions((RootRegion)rootRegion)) {
            connectionManager.createPartitionConnections(rootRegion, region);
        }
        this.directedScheduleManager.writeDebugGraphs("5-post-partition", rootRegion, true, true, false);
        this.directedScheduleManager.throwCompilerChainExceptionForErrors();
        for (PartitionedTransformationAnalysis partitionedTransformationAnalysis2 : partitionedTransformationAnalyses) {
            this.schedule(partitionedTransformationAnalysis2);
        }
        this.directedScheduleManager.writeDebugGraphs("9-final", rootRegion, true, true, false);
        return rootRegion;
    }
}

