/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.library.RegisteredContribution;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.xtext.qvtbase.tests.PivotTestCase;

public class XtextTestCase
extends PivotTestCase {
    public static TestCaseAppender testCaseAppender = new TestCaseAppender();
    public @Nullable TestFileSystem testFileSystem = null;
    public @Nullable TestProject testProject = null;
    public @Nullable ProjectManager testProjectManager = null;

    protected void assertPivotIsValid(URI pivotURI) {
        ResourceSetImpl reloadResourceSet = new ResourceSetImpl();
        reloadResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("pivot", new EcoreResourceFactoryImpl());
        Resource reloadedPivotResource = reloadResourceSet.getResource(pivotURI, true);
        XtextTestCase.assertNoValidationErrors("Pivot reload validation problems", reloadedPivotResource);
        XtextTestCase.unloadResourceSet((ResourceSet)reloadResourceSet);
    }

    public static void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
    }

    public static void configurePlatformResources() {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            File[] files;
            String urlString = System.getProperty("WORKSPACE_LOC");
            File workspaceLoc = urlString != null ? new File(urlString) : new File(System.getProperty("user.dir")).getParentFile();
            File[] fileArray = files = workspaceLoc.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    String name = file.getName();
                    EcorePlugin.getPlatformResourceMap().put(name, URI.createFileURI((String)(String.valueOf(file.toString()) + "/")));
                }
                ++n2;
            }
        }
    }

    public static String formatMessageDifferences(@NonNull Bag<@NonNull String> expectedMessages, @NonNull Bag<@NonNull String> actualMessages) {
        HashSet<@NonNull String> allMessages = new HashSet<String>((Collection<String>)expectedMessages);
        allMessages.addAll((Collection<String>)actualMessages);
        StringBuilder s = null;
        for (String message : allMessages) {
            int expectedCount;
            int actualCount = actualMessages.count((Object)message);
            if (actualCount == (expectedCount = expectedMessages.count((Object)message))) continue;
            if (s == null) {
                s = new StringBuilder();
            }
            s.append("\n  (" + expectedCount + "/" + actualCount + ") " + message);
        }
        return s != null ? s.toString() : null;
    }

    protected static boolean hasCorrespondingCS(@NonNull Element pivotElement) {
        if (!XtextTestCase.isValidPivot(pivotElement)) {
            return false;
        }
        if (pivotElement instanceof ExpressionInOCL) {
            return false;
        }
        if (pivotElement instanceof Variable && pivotElement.eContainer() instanceof ExpressionInOCL) {
            return false;
        }
        return !(pivotElement instanceof Variable) || !(pivotElement.eContainer() instanceof LoopExp) || !Character.isDigit(((Variable)pivotElement).getName().charAt(0));
    }

    protected static boolean hasCorrespondingPivot(@NonNull ModelElementCS csElement) {
        return org.eclipse.ocl.examples.xtext.tests.XtextTestCase.hasCorrespondingPivot((ModelElementCS)csElement);
    }

    protected static boolean hasUniqueMoniker(@NonNull ModelElementCS csElement) {
        return org.eclipse.ocl.examples.xtext.tests.XtextTestCase.hasUniqueMoniker((ModelElementCS)csElement);
    }

    protected static boolean isValidPivot(@NonNull Element pivotElement) {
        EObject eContainer;
        if (pivotElement instanceof Package && pivotElement.eContainer() == null && "$$".equals(((NamedElement)pivotElement).getName())) {
            return false;
        }
        if (pivotElement instanceof TemplateableElement && ((TemplateableElement)pivotElement).getOwnedBindings().size() > 0) {
            return false;
        }
        if (pivotElement instanceof LambdaType) {
            return false;
        }
        if (pivotElement instanceof TupleType) {
            return false;
        }
        if (pivotElement instanceof Type && (eContainer = pivotElement.eContainer()) instanceof Package && eContainer.eContainer() == null && "$$".equals(((NamedElement)pivotElement).getName()) && "$$".equals(((NamedElement)eContainer).getName())) {
            return false;
        }
        if (pivotElement instanceof Property && pivotElement.eContainer() instanceof TupleType) {
            return false;
        }
        return !(pivotElement instanceof VariableExp) || !(pivotElement.eContainer() instanceof OperationCallExp);
    }

    protected @NonNull URI getModelsURI(@NonNull String filePath) {
        return URI.createPlatformResourceURI((String)(String.valueOf(this.getTestBundleName()) + "/models/" + filePath), (boolean)true);
    }

    protected @NonNull String getProjectName() {
        return ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
    }

    protected @NonNull URI getResourceURI(@NonNull String filePath) {
        return URI.createPlatformResourceURI((String)filePath, (boolean)true);
    }

    protected @NonNull String getTestBundleName() {
        return (String)ClassUtil.nonNullState((Object)((Object)((Object)this)).getClass().getPackage().getName());
    }

    protected @NonNull URI getTestBundleURI() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return URI.createPlatformPluginURI((String)("/" + this.getTestBundleName()), (boolean)true);
        }
        return URI.createPlatformResourceURI((String)("/" + this.getTestBundleName()), (boolean)true);
    }

    protected final @NonNull TestFileSystem getTestFileSystem() {
        return this.getTestFileSystem("");
    }

    protected @NonNull TestFileSystem getTestFileSystem(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) {
        TestFileSystem testFileSystem2 = this.testFileSystem;
        if (testFileSystem2 == null) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                File testBundleFile = new File(".project");
                assert (!testBundleFile.exists()) : "Default working directory should be the workspace rather than a project: " + testBundleFile.getAbsolutePath();
            }
            this.testFileSystem = testFileSystem2 = TestFileSystem.create((TestFileSystemHelper)this.getTestFileSystemHelper(), (String)pathFromCurrentWorkingDirectoryToFileSystem);
        }
        return testFileSystem2;
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        return new TestFileSystemHelper();
    }

    protected @NonNull URI getTestFileURI(@NonNull String filePath) {
        TestProject testProject = this.getTestProject();
        TestFile outFile = testProject.getOutputFile(filePath);
        return URI.createFileURI((String)outFile.getFile().toString());
    }

    protected @NonNull URI getTestModelsFolderURI() {
        return this.getTestBundleURI().appendSegment("models");
    }

    protected @NonNull TestProject getTestProject() {
        return this.getTestProject("");
    }

    protected @NonNull TestProject getTestProject(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) {
        TestProject testProject2 = this.testProject;
        if (testProject2 == null) {
            String testProjectName = "_QVTd_" + ((Object)((Object)this)).getClass().getSimpleName() + "__" + this.getTestName();
            this.testProject = testProject2 = this.getTestFileSystem(pathFromCurrentWorkingDirectoryToFileSystem).getTestProject(testProjectName, true);
        }
        return testProject2;
    }

    protected @NonNull ProjectManager getTestProjectManager() {
        return this.getTestProjectManager("");
    }

    protected @NonNull ProjectManager getTestProjectManager(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) {
        ProjectManager testProjectManager2 = this.testProjectManager;
        if (testProjectManager2 == null) {
            this.testProjectManager = testProjectManager2 = this.getTestProject(pathFromCurrentWorkingDirectoryToFileSystem).createTestProjectManager();
        }
        return testProjectManager2;
    }

    protected @NonNull URI getTestURI(@NonNull String filePath) {
        TestProject testProject = this.getTestProject();
        TestFile outFile = testProject.getOutputFile(filePath);
        return outFile.getURI();
    }

    protected @NonNull URI getTestURIWithExtension(@NonNull URI inputURI, @Nullable String fileExtension) {
        URI fileStem = inputURI.trimFileExtension();
        if (fileExtension != null) {
            fileStem = fileStem.appendFileExtension(fileExtension);
        }
        String fileName = (String)ClassUtil.nonNullState((Object)fileStem.lastSegment());
        return this.getTestURI(fileName);
    }

    protected @NonNull URI getURIWithExtension(@NonNull URI inputURI, @NonNull String fileExtension) {
        return inputURI.trimFileExtension().appendFileExtension(fileExtension);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        testCaseAppender.install();
        PivotStandaloneSetup.doSetup();
        StandardLibraryContribution.REGISTRY.put("http://www.eclipse.org/ocl/2015/Library", (RegisteredContribution)new OCLstdlib.Loader());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static final class TestCaseAppender
    extends ConsoleAppender {
        private static Logger rootLogger = Logger.getRootLogger();
        private boolean installed = false;

        public TestCaseAppender() {
            super((Layout)new SimpleLayout(), "System.out");
            this.setName("TestHarness");
        }

        public void append(LoggingEvent event) {
            if (event.getLevel().isGreaterOrEqual((Priority)Level.INFO)) {
                String renderedMessage = event.getRenderedMessage();
                ThrowableInformation throwableInformation = event.getThrowableInformation();
                Throwable throwable = throwableInformation != null ? throwableInformation.getThrowable() : null;
                throw new Error(renderedMessage, throwable);
            }
        }

        public void install() {
            if (!this.installed) {
                rootLogger.addAppender((Appender)this);
                this.installed = true;
            }
        }

        public void uninstall() {
            rootLogger.removeAppender((Appender)this);
            this.installed = false;
        }
    }

    public static class TestProblemHandler
    implements ProblemHandler {
        public void addProblem(@NonNull CompilerProblem problem) {
            throw new IllegalStateException(problem.toString());
        }

        public void throwCompilerChainExceptionForErrors() throws CompilerChainException {
            throw new UnsupportedOperationException();
        }
    }
}

