/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.internal;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.BoxingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.FieldingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.ReferencesVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.codegen.utilities.CGModelResourceFactory;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAS2CGVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalysisVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiBoxingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiDependencyVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiFieldingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiReferencesVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCG2JavaPreVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCG2JavaVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.utilities.QVTiCGUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.cs2as.compiler.CS2ASJavaCompiler;
import org.eclipse.qvtd.cs2as.compiler.CS2ASJavaCompilerParameters;
import org.eclipse.qvtd.cs2as.compiler.cgmodel.CGLookupCallExp;
import org.eclipse.qvtd.cs2as.compiler.cgmodel.util.CS2ASCGModelVisitor;
import org.eclipse.qvtd.cs2as.compiler.internal.utilities.CS2ASCGModelResourceFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.internal.cs2as.AbstractCS2ASTransformer;
import org.eclipse.qvtd.runtime.internal.cs2as.CS2ASTransformer;

public class CS2ASJavaCompilerImpl
implements CS2ASJavaCompiler {
    private @Nullable Log log = null;

    protected Class<? extends CS2ASTransformer> compileTransformation(@NonNull File explicitClassPath, @NonNull QVTiCodeGenerator cg, @Nullable JavaClasspath classpath, @Nullable ClassLoader classLoader) throws Exception {
        String javaCodeSource;
        String qualifiedClassName = cg.getQualifiedName();
        List<@NonNull OCL2JavaFileObject> compilationUnits = Collections.singletonList(new OCL2JavaFileObject(qualifiedClassName, javaCodeSource = cg.generateClassFile()));
        String problem = JavaFileUtil.compileClasses(compilationUnits, (String)qualifiedClassName, (String)String.valueOf(explicitClassPath), (JavaClasspath)classpath);
        if (problem != null) {
            throw new CompilerChainException(problem, new Object[0]);
        }
        Class txClass = OCL2JavaFileObject.loadExplicitClass((File)explicitClassPath, (String)qualifiedClassName, (ClassLoader)classLoader);
        return txClass;
    }

    @Override
    public @NonNull Class<? extends CS2ASTransformer> compileTransformation(@NonNull QVTimperative qvt, @NonNull ImperativeTransformation iTransformation, final @NonNull CS2ASJavaCompilerParameters params) throws Exception {
        List problems;
        CS2ASJavaCodeGenerator cg = new CS2ASJavaCodeGenerator(qvt.getEnvironmentFactory(), iTransformation, params){

            protected @NonNull String createClassFileContent() {
                String classFileContent = super.createClassFileContent();
                for (Map.Entry<String, String> entry : params.getPackageRenames().entrySet()) {
                    String fromPackage = entry.getKey();
                    String toPackage = entry.getValue();
                    classFileContent = classFileContent.replace(fromPackage, toPackage);
                }
                return classFileContent;
            }
        };
        QVTiCodeGenOptions options = cg.getOptions();
        options.setUseNullAnnotations(true);
        options.setIsIncremental(params.isIncremental());
        options.setPackagePrefix(params.getPackagePrefix());
        try {
            cg.generateClassFile();
        }
        catch (Exception e) {
            CompilerUtil.throwExceptionWithProblems((CodeGenerator)cg, (Exception)e);
        }
        Log log2 = this.log;
        if (log2 != null && (problems = cg.getProblems()) != null) {
            for (Exception ex : problems) {
                log2.info((Object)("CG Problem " + ex.toString()));
            }
        }
        String savePath = params.getSavePath();
        cg.saveSourceFile(savePath);
        if (log2 != null) {
            log2.info((Object)("Saved " + savePath + cg.getQualifiedName()));
        }
        File explicitClassPath = new File(new File(savePath).getParentFile(), "test-bin");
        explicitClassPath.mkdir();
        return (Class)ClassUtil.nonNullState(this.compileTransformation(explicitClassPath, cg, params.getClasspath(), params.getClassLoader()));
    }

    public void setLog(@Nullable Log log) {
        this.log = log;
    }

    protected static class CS2ASAS2CGVisitor
    extends QVTiAS2CGVisitor {
        public CS2ASAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext) {
            super(analyzer, globalContext);
        }
    }

    protected static class CS2ASAnalysisVisitor
    extends QVTiAnalysisVisitor
    implements CS2ASCGModelVisitor<Object> {
        public CS2ASAnalysisVisitor(@NonNull QVTiAnalyzer analyzer) {
            super(analyzer);
        }

        @Override
        public @Nullable Object visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
            return this.visitCGOperationCallExp(object);
        }
    }

    protected static class CS2ASBoxingAnalyser
    extends QVTiBoxingAnalyzer
    implements CS2ASCGModelVisitor<Object> {
        public CS2ASBoxingAnalyser(@NonNull QVTiAnalyzer analyzer) {
            super(analyzer);
        }

        @Override
        public @Nullable Object visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
            super.visitCGOperationCallExp((CGOperationCallExp)object);
            CGValuedElement cgSource = object.getSource();
            this.rewriteAsGuarded(cgSource, this.isSafe((CGCallExp)object), "source for '" + object.getReferredOperation() + "'");
            this.rewriteAsUnboxed(cgSource);
            List cgArguments = object.getArguments();
            int iMax = cgArguments.size();
            int i = 0;
            while (i < iMax) {
                this.rewriteAsUnboxed((CGValuedElement)cgArguments.get(i));
                ++i;
            }
            return null;
        }
    }

    protected static class CS2ASCG2JavaPreVisitor
    extends QVTiCG2JavaPreVisitor
    implements CS2ASCGModelVisitor<Object> {
        public CS2ASCG2JavaPreVisitor(@NonNull QVTiGlobalContext globalContext) {
            super(globalContext);
        }

        @Override
        public @Nullable Object visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
            return this.visitCGOperationCallExp(object);
        }
    }

    protected static class CS2ASCG2JavaVisitor
    extends QVTiCG2JavaVisitor
    implements CS2ASCGModelVisitor<Boolean> {
        private static final String LOOKUP_SOLVER_FIELD_NAME = "lookupSolver";

        protected CS2ASCG2JavaVisitor(@NonNull QVTiCodeGenerator codeGenerator, @NonNull CGPackage cgPackage, @Nullable List<@NonNull CGValuedElement> sortedGlobals) {
            super(codeGenerator, cgPackage, sortedGlobals);
        }

        protected void appendGuardFailure(@NonNull CGGuardExp cgGuardExp) {
            List freeVariables;
            CGMapping cgMapping = QVTiCGUtil.basicGetContainingCGMapping((CGElement)cgGuardExp);
            if (cgMapping != null && (freeVariables = cgMapping.getOwnedGuardVariables()).size() > 0) {
                CGGuardVariable cgGuardVariable = (CGGuardVariable)freeVariables.get(0);
                this.js.append("throw throwNull(");
                this.js.appendValueName((CGValuedElement)cgGuardVariable);
                this.js.append(", ");
                this.js.appendString("Null " + cgGuardExp.getMessage());
                this.js.append(");\n");
                return;
            }
            super.appendGuardFailure(cgGuardExp);
        }

        protected @NonNull Class<? extends AbstractTransformer> getAbstractTransformationExecutorClass() {
            return AbstractCS2ASTransformer.class;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable Boolean visitCGLookupCallExp(@NonNull CGLookupCallExp cgCall) {
            CS2ASJavaCompilerParameters params = ((CS2ASJavaCodeGenerator)this.getCodeGenerator()).getCGParameters();
            CGValuedElement cgSource = (CGValuedElement)ClassUtil.nonNullState((Object)cgCall.getSource());
            TypeDescriptor typeDescriptor = ((QVTiCodeGenerator)this.context).getTypeDescriptor((CGValuedElement)cgCall);
            if (!this.js.appendLocalStatements(cgSource)) {
                return false;
            }
            @NonNull List cgArguments = ClassUtil.nullFree((List)cgCall.getArguments());
            for (CGValuedElement cgArgument : cgArguments) {
                CGValuedElement argument = this.getExpression(cgArgument);
                if (this.js.appendLocalStatements(argument)) continue;
                return false;
            }
            String resultClassName = params.getLookupResultClassName();
            String resultSymbol = this.getSymbolName(String.valueOf(resultClassName) + cgCall.hashCode(), new String[]{"_lookupResult"});
            this.js.appendClassReference(null, resultClassName);
            this.js.append("<");
            this.js.appendClassReference(null, (TypeDescriptor)((QVTiCodeGenerator)this.context).getUnboxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgCall.getTypeId().getElementId())));
            this.js.append(">");
            this.js.append(" ");
            this.js.append(resultSymbol);
            this.js.append(" = ");
            this.js.append(LOOKUP_SOLVER_FIELD_NAME);
            this.js.append(".");
            this.js.append(cgCall.getName());
            this.js.append("(");
            this.js.appendReferenceTo(cgSource);
            List pParameters = cgCall.getReferredOperation().getOwnedParameters();
            int iMax = Math.min(pParameters.size(), cgArguments.size());
            int i = 0;
            while (i < iMax) {
                this.js.append(", ");
                CGValuedElement cgArgument = (CGValuedElement)cgArguments.get(i);
                Parameter pParameter = (Parameter)pParameters.get(i);
                CGTypeId cgTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
                UnboxedDescriptor parameterTypeDescriptor = ((QVTiCodeGenerator)this.context).getUnboxedDescriptor((ElementId)ClassUtil.nonNullState((Object)cgTypeId.getElementId()));
                CGValuedElement argument = this.getExpression(cgArgument);
                this.js.appendReferenceTo((TypeDescriptor)parameterTypeDescriptor, argument);
                ++i;
            }
            this.js.append(");\n");
            this.js.appendClassReference(null, typeDescriptor);
            this.js.append(" ");
            this.js.appendReferenceTo((CGValuedElement)cgCall);
            this.js.append(" = null;\n");
            this.js.append("if (" + resultSymbol + ".size() == 1) {\n");
            this.js.pushIndentation(null);
            this.js.appendReferenceTo((CGValuedElement)cgCall);
            this.js.append(" = ");
            this.js.append(String.valueOf(resultSymbol) + ".getSingleResult();\n");
            this.js.popIndentation();
            this.js.append("} else {\n");
            this.js.pushIndentation(null);
            CGValuedElement lookupArg = (CGValuedElement)cgArguments.get(0);
            CGValuedElement initialSource = this.initialSourceCG(lookupArg);
            if (this.shouldHandleError(initialSource)) {
                this.js.append("handleLookupError(");
                this.js.appendReferenceTo(initialSource);
                this.js.append(",");
                this.js.appendReferenceTo(lookupArg);
                this.js.append(");\n");
            }
            this.js.popIndentation();
            this.js.append("};\n");
            return true;
        }

        protected void doMappingConstructorConstants(List<@NonNull CGMapping> cgMappings) {
            super.doMappingConstructorConstants(cgMappings);
            CS2ASJavaCompilerParameters params = ((CS2ASJavaCodeGenerator)this.getCodeGenerator()).getCGParameters();
            String lookupSolver = params.getLookupSolverClassName();
            if (!"".equals(lookupSolver)) {
                this.js.append("private final ");
                this.js.appendClassReference(null, lookupSolver);
                this.js.append(" ");
                this.js.append(LOOKUP_SOLVER_FIELD_NAME);
                this.js.append(" = new ");
                this.js.appendClassReference(null, lookupSolver);
                this.js.append("(");
                this.js.append("executor");
                this.js.append(");\n");
            }
        }

        private CGValuedElement initialSourceCG(CGValuedElement cgValue) {
            if (cgValue instanceof CGVariableExp) {
                return cgValue;
            }
            if (cgValue instanceof CGCallExp) {
                CGValuedElement cgSource = ((CGCallExp)cgValue).getSource();
                return this.initialSourceCG(cgSource);
            }
            return cgValue;
        }

        private boolean shouldHandleError(CGValuedElement cgValue) {
            ElementId valueTypeId;
            TypeId stringTypeId = ((QVTiCodeGenerator)this.context).getEnvironmentFactory().getStandardLibrary().getStringType().getTypeId();
            return !stringTypeId.equals(valueTypeId = cgValue.getTypeId().getElementId());
        }
    }

    protected static class CS2ASDependencyVisitor
    extends QVTiDependencyVisitor
    implements CS2ASCGModelVisitor<Object> {
        public CS2ASDependencyVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext, @NonNull GlobalPlace globalPlace) {
            super(analyzer, globalContext, globalPlace);
        }

        @Override
        public @Nullable Object visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
            return this.visitCGOperationCallExp(object);
        }
    }

    protected static class CS2ASFieldingAnalyser
    extends QVTiFieldingAnalyzer {
        public CS2ASFieldingAnalyser(@NonNull QVTiAnalyzer analyzer) {
            super(analyzer);
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull FieldingAnalyzer.AnalysisVisitor createAnalysisVisitor() {
            return new CS2ASAnalysisVisitor(this);
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull FieldingAnalyzer.RewriteVisitor createRewriteVisitor(@NonNull Set<@NonNull CGVariable> caughtVariables) {
            return new CS2ASRewriteVisitor((QVTiAnalyzer)this.analyzer, caughtVariables);
        }

        protected static class CS2ASAnalysisVisitor
        extends QVTiFieldingAnalyzer.QVTiAnalysisVisitor
        implements CS2ASCGModelVisitor<Set<CGVariable>> {
            public CS2ASAnalysisVisitor(@NonNull QVTiFieldingAnalyzer context) {
                super(context);
            }

            @Override
            public @Nullable Set<CGVariable> visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
                return this.visitCGOperationCallExp(object);
            }
        }

        protected static class CS2ASRewriteVisitor
        extends QVTiFieldingAnalyzer.QVTiRewriteVisitor
        implements CS2ASCGModelVisitor<Boolean> {
            public CS2ASRewriteVisitor(@NonNull QVTiAnalyzer context, @NonNull Set<@NonNull CGVariable> caughtVariable) {
                super(context, caughtVariable);
            }

            @Override
            public @Nullable Boolean visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
                return this.visitCGOperationCallExp(object);
            }
        }
    }

    protected static class CS2ASJavaCodeGenerator
    extends QVTiCodeGenerator {
        private @NonNull CS2ASJavaCompilerParameters params;

        protected CS2ASJavaCodeGenerator(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull ImperativeTransformation iTransformation, @NonNull CS2ASJavaCompilerParameters params) {
            super((QVTbaseEnvironmentFactory)environmentFactory, iTransformation);
            this.params = params;
        }

        protected @NonNull QVTiCG2JavaVisitor createCG2JavaVisitor(@NonNull CGPackage cgPackage, @Nullable List<@NonNull CGValuedElement> sortedGlobals) {
            return new CS2ASCG2JavaVisitor(this, cgPackage, sortedGlobals);
        }

        protected @NonNull QVTiAS2CGVisitor createAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext gContext) {
            return new CS2ASAS2CGVisitor(analyzer, gContext);
        }

        public @NonNull AnalysisVisitor createAnalysisVisitor() {
            return new CS2ASAnalysisVisitor(this.cgAnalyzer);
        }

        public @NonNull BoxingAnalyzer createBoxingAnalyzer() {
            return new CS2ASBoxingAnalyser(this.cgAnalyzer);
        }

        public @NonNull FieldingAnalyzer createFieldingAnalyzer() {
            return new CS2ASFieldingAnalyser(this.cgAnalyzer);
        }

        public @NonNull CG2JavaPreVisitor createCG2JavaPreVisitor() {
            return new CS2ASCG2JavaPreVisitor(this.getGlobalContext());
        }

        public @NonNull ReferencesVisitor createReferencesVisitor() {
            return CS2ASReferencesVisitor.INSTANCE;
        }

        public @NonNull DependencyVisitor createDependencyVisitor() {
            return new CS2ASDependencyVisitor(this.cgAnalyzer, this.getGlobalContext(), this.getGlobalPlace());
        }

        public @NonNull CGModelResourceFactory getCGResourceFactory() {
            return CS2ASCGModelResourceFactory.INSTANCE;
        }

        public @NonNull CS2ASJavaCompilerParameters getCGParameters() {
            return this.params;
        }
    }

    protected static class CS2ASReferencesVisitor
    extends QVTiReferencesVisitor
    implements CS2ASCGModelVisitor<List<Object>> {
        protected static final @NonNull CS2ASReferencesVisitor INSTANCE = new CS2ASReferencesVisitor(new Object());

        public CS2ASReferencesVisitor(@Nullable Object context) {
            super(context);
        }

        @Override
        public @NonNull List<@Nullable Object> visitCGLookupCallExp(@NonNull CGLookupCallExp object) {
            return this.visitCGOperationCallExp(object);
        }
    }
}

