/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.ModelTypeMetamodelsAdapter;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtPrimitiveType;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.EMFType;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationProperty;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QvtModule {
    private QvtCompilerOptions myQvtCompilerOptions;

    protected QvtModule() {
    }

    public abstract CompiledModule getModule() throws MdaException;

    public abstract QvtCompiler getCompiler() throws MdaException;

    public String getModuleName() throws MdaException {
        return this.getModule().getModule().getName();
    }

    public EClass getIn() throws MdaException {
        EClass inCls = QvtModule.getInType(this.getModule());
        if (inCls != null) {
            return inCls;
        }
        for (ModelParameter modelParam : this.getModule().getModule().getModelParameter()) {
            if (modelParam.getKind() != DirectionKind.IN && modelParam.getKind() != DirectionKind.INOUT) continue;
            List metamodels = ModelTypeMetamodelsAdapter.getMetamodels((EObject)modelParam.getEType());
            if (!metamodels.isEmpty()) {
                return ((EPackage)metamodels.get(0)).eClass();
            }
            return null;
        }
        return null;
    }

    public EClass getOut() throws MdaException {
        EClass outCls = QvtModule.getReturnType(this.getModule());
        if (outCls != null) {
            return outCls;
        }
        for (ModelParameter modelParam : this.getModule().getModule().getModelParameter()) {
            if (modelParam.getKind() != DirectionKind.OUT) continue;
            List metamodels = ModelTypeMetamodelsAdapter.getMetamodels((EObject)modelParam.getEType());
            if (!metamodels.isEmpty()) {
                return ((EPackage)metamodels.get(0)).eClass();
            }
            return null;
        }
        return null;
    }

    public List<QvtTransformation.TransformationParameter> getParameters() throws MdaException {
        Module module = this.getModule().getModule();
        ImperativeOperation mainMethod = (ImperativeOperation)module.getEntry();
        ArrayList<QvtTransformation.TransformationParameter> transfParams = new ArrayList<QvtTransformation.TransformationParameter>(module.getModelParameter().size());
        for (ModelParameter modelParam : module.getModelParameter()) {
            MappingParameter refinedParam = this.findMainParameter(mainMethod, modelParam);
            transfParams.add(this.createTransfParam(modelParam, refinedParam));
        }
        if (transfParams.isEmpty() && mainMethod != null) {
            for (EParameter mainParam : mainMethod.getEParameters()) {
                transfParams.add(this.createTransfParam((MappingParameter)mainParam));
            }
            for (EParameter mainParam : mainMethod.getResult()) {
                if (mainParam.getEType() instanceof VoidType) continue;
                transfParams.add(this.createTransfParam((MappingParameter)mainParam));
            }
        }
        return transfParams;
    }

    public QvtCompilerOptions getQvtCompilerOptions() {
        return this.myQvtCompilerOptions;
    }

    public void setQvtCompilerOptions(QvtCompilerOptions options) {
        this.myQvtCompilerOptions = options;
    }

    private QvtTransformation.TransformationParameter createTransfParam(final MappingParameter mainParam) {
        return new QvtTransformation.TransformationParameter(){

            @Override
            public QvtTransformation.TransformationParameter.DirectionKind getDirectionKind() {
                if (mainParam.getKind() == DirectionKind.IN) {
                    return QvtTransformation.TransformationParameter.DirectionKind.IN;
                }
                if (mainParam.getKind() == DirectionKind.OUT) {
                    return QvtTransformation.TransformationParameter.DirectionKind.OUT;
                }
                return QvtTransformation.TransformationParameter.DirectionKind.INOUT;
            }

            @Override
            public String getEntryName() {
                return mainParam.getName() != null ? mainParam.getName() : "";
            }

            @Override
            public EClassifier getEntryType() {
                return mainParam.getEType();
            }

            @Override
            public List<EPackage> getMetamodels() {
                EObject rootContainer = EcoreUtil.getRootContainer((EObject)mainParam.getEType());
                if (rootContainer instanceof EPackage) {
                    return Collections.singletonList((EPackage)rootContainer);
                }
                return Collections.emptyList();
            }

            @Override
            public String getModelTypeName() {
                if (this.getMetamodels().isEmpty()) {
                    return "";
                }
                return this.getMetamodels().get(0).getName();
            }

            @Override
            public String getName() {
                return this.getEntryName();
            }
        };
    }

    private QvtTransformation.TransformationParameter createTransfParam(final ModelParameter modelParam, final MappingParameter refinedParam) {
        return new QvtTransformation.TransformationParameter(){

            @Override
            public QvtTransformation.TransformationParameter.DirectionKind getDirectionKind() {
                if (modelParam.getKind() == DirectionKind.IN) {
                    return QvtTransformation.TransformationParameter.DirectionKind.IN;
                }
                if (modelParam.getKind() == DirectionKind.OUT) {
                    return QvtTransformation.TransformationParameter.DirectionKind.OUT;
                }
                return QvtTransformation.TransformationParameter.DirectionKind.INOUT;
            }

            @Override
            public String getEntryName() {
                return refinedParam != null ? refinedParam.getName() : "";
            }

            @Override
            public EClassifier getEntryType() {
                return refinedParam != null ? refinedParam.getEType() : null;
            }

            @Override
            public List<EPackage> getMetamodels() {
                return ModelTypeMetamodelsAdapter.getMetamodels((EObject)modelParam.getEType());
            }

            @Override
            public String getModelTypeName() {
                if (modelParam.getEType() instanceof ModelType) {
                    return ((ModelType)modelParam.getEType()).getName();
                }
                return "";
            }

            @Override
            public String getName() {
                return modelParam.getName();
            }
        };
    }

    private MappingParameter findMainParameter(ImperativeOperation mainMethod, ModelParameter modelParam) {
        if (mainMethod != null) {
            for (EParameter mainParam : mainMethod.getEParameters()) {
                if (((MappingParameter)mainParam).getExtent() != modelParam) continue;
                return (MappingParameter)mainParam;
            }
            for (EParameter mainParam : mainMethod.getResult()) {
                if (((MappingParameter)mainParam).getExtent() != modelParam) continue;
                return (MappingParameter)mainParam;
            }
        }
        return null;
    }

    public Set<QvtConfigurationProperty> getConfigurationProperties() throws MdaException {
        CompiledModule module = this.getModule();
        if (module == null) {
            return Collections.emptySet();
        }
        HashSet<Module> moduleSet = new HashSet<Module>();
        this.collectImports(module, moduleSet);
        LinkedHashSet<QvtConfigurationProperty> propSet = new LinkedHashSet<QvtConfigurationProperty>();
        for (Module m : moduleSet) {
            this.collectProperties(m, propSet);
        }
        return propSet;
    }

    public static EClass getReturnType(CompiledModule module) {
        ImperativeOperation mainMethod = (ImperativeOperation)module.getModule().getEntry();
        if (mainMethod == null) {
            return null;
        }
        if (mainMethod.getResult().isEmpty()) {
            return null;
        }
        EClassifier type = ((VarParameter)mainMethod.getResult().get(0)).getEType();
        if (!(type instanceof EClass)) {
            return null;
        }
        return (EClass)type;
    }

    public static EClass getInType(CompiledModule module) {
        ImperativeOperation mainMethod = (ImperativeOperation)module.getModule().getEntry();
        if (mainMethod == null) {
            return null;
        }
        EList params = mainMethod.getEParameters();
        if (params.isEmpty()) {
            return null;
        }
        EClassifier type = ((EParameter)params.get(0)).getEType();
        if (!(type instanceof EClass)) {
            return null;
        }
        return (EClass)type;
    }

    public abstract String toString();

    protected void checkModuleErrors(CompiledModule mappingModule) throws MdaException {
        ArrayList<QvtMessage> errors = new ArrayList<QvtMessage>();
        TransformationUtil.getErrors(mappingModule, errors);
        if (!errors.isEmpty()) {
            throw new MdaException(NLS.bind((String)Messages.TransformationUtil_ParseTransformationError, (Object)this.toString(), (Object)errors.size()));
        }
    }

    private void collectImports(CompiledModule module, Set<Module> moduleSet) {
        LinkedList<Module> queue = new LinkedList<Module>();
        queue.offer(module.getModule());
        while (!queue.isEmpty()) {
            Module m = (Module)queue.poll();
            moduleSet.add(m);
            for (ModuleImport imp : m.getModuleImport()) {
                Module element = imp.getImportedModule();
                if (moduleSet.contains(element)) continue;
                moduleSet.add(element);
                queue.offer(element);
            }
        }
    }

    private void collectProperties(Module module, Set<QvtConfigurationProperty> propSet) {
        for (EStructuralFeature property : module.getConfigProperty()) {
            EClassifier type = property.getEType();
            if (type instanceof EDataType) {
                propSet.add(new QvtConfigurationProperty(property.getName(), new EMFType((EDataType)type)));
                continue;
            }
            if (!QvtOperationalUtil.isPrimitiveType((Object)type)) continue;
            propSet.add(new QvtConfigurationProperty(property.getName(), new QvtPrimitiveType(type)));
        }
    }
}

