/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.IOException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.BundleModuleRegistry;

public abstract class AbstractBundleResource
implements CResource {
    protected final IPath resourcePath;
    protected final BundleModuleRegistry resourceRegistry;

    protected AbstractBundleResource(IPath path, BundleModuleRegistry bundleRegistry) {
        if (path == null || path.isEmpty() || !path.isValidPath(path.toString())) {
            throw new IllegalArgumentException("Invalid bundle resource path: " + path);
        }
        this.resourcePath = path;
        this.resourceRegistry = bundleRegistry;
    }

    protected IPath getPath() {
        return this.resourcePath;
    }

    public String getExtension() {
        return this.resourcePath.getFileExtension();
    }

    public IFileStore getFileStore() throws IOException {
        throw new UnsupportedOperationException("IFileStore for bundle-file is not supported");
    }

    public String getFullPath() {
        return this.resourcePath.toOSString();
    }

    public String getName() {
        String name = this.resourcePath.lastSegment();
        return name != null ? name : "";
    }

    public void refresh() throws IOException {
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException("Deleting bundle-resource is not supported");
    }

    public void create() throws IOException {
        throw new UnsupportedOperationException("Creating bundle-resource is not supported");
    }

    public String toString() {
        return "platform:/plugin/" + this.resourceRegistry.getBundleSymbolicName() + "/" + this.resourcePath.toString();
    }
}

