/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.resourcesetprovider;

import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.resourcesetprovider.IResourceSetProvider;
import org.eclipse.m2m.internal.qvt.oml.common.resourcesetprovider.IUriMapResourceSetPair;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSetProviderRegistry {
    public static final String EXT_POINT_ID = "resourceSetProviders";
    public static final String ELEMENT_PROVIDER = "provider";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    private static TreeMap<Integer, IResourceSetProvider> ourProviders;
    private static IRegistryChangeListener ourRegistryChangeListener;
    private static IActivityManagerListener ourActivityChangeListener;

    static {
        ourRegistryChangeListener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] extensionDeltas = event.getExtensionDeltas("org.eclipse.m2m.qvt.oml.common", ResourceSetProviderRegistry.EXT_POINT_ID);
                if (extensionDeltas.length != 0) {
                    ResourceSetProviderRegistry.refresh();
                }
            }
        };
        ourActivityChangeListener = new IActivityManagerListener(){

            public void activityManagerChanged(ActivityManagerEvent event) {
                if (event.haveEnabledActivityIdsChanged()) {
                    ResourceSetProviderRegistry.refresh();
                }
            }
        };
        ResourceSetProviderRegistry.refresh();
        Platform.getExtensionRegistry().addRegistryChangeListener(ourRegistryChangeListener, "org.eclipse.m2m.qvt.oml.common");
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(ourActivityChangeListener);
    }

    public static final ResourceSetResourceSetProviderPair getResourceSetResourceSetProviderPair(CFile script) {
        for (IResourceSetProvider provider : ourProviders.values()) {
            IUriMapResourceSetPair uriMapResourceSetPair = provider.getUriMapResourceSetPair(script);
            if (uriMapResourceSetPair == null) continue;
            return new ResourceSetResourceSetProviderPair(uriMapResourceSetPair, provider);
        }
        return null;
    }

    private static TreeMap<Integer, IResourceSetProvider> initProviders() {
        IConfigurationElement[] configurationElements;
        TreeMap<Integer, IResourceSetProvider> result = new TreeMap<Integer, IResourceSetProvider>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml.common", EXT_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (!ResourceSetProviderRegistry.isFiltered(configurationElement) && ELEMENT_PROVIDER.equals(configurationElement.getName())) {
                try {
                    IResourceSetProvider provider = (IResourceSetProvider)configurationElement.createExecutableExtension(ATTRIBUTE_CLASS);
                    Integer priority = new Integer(configurationElement.getAttribute(ATTRIBUTE_PRIORITY));
                    result.put(priority, provider);
                }
                catch (CoreException ex) {
                    CommonPlugin.log(ex);
                }
            }
            ++n2;
        }
        return result;
    }

    public static final void refresh() {
        ourProviders = ResourceSetProviderRegistry.initProviders();
    }

    private static boolean isFiltered(IConfigurationElement configurationElement) {
        final IExtension extension = configurationElement.getDeclaringExtension();
        IPluginContribution contribution = new IPluginContribution(){

            public String getLocalId() {
                return extension.getSimpleIdentifier();
            }

            public String getPluginId() {
                return extension.getContributor().getName();
            }
        };
        return WorkbenchActivityHelper.filterItem((Object)contribution);
    }

    public static class ResourceSetResourceSetProviderPair {
        private IUriMapResourceSetPair myUriMapResourceSetPair;
        private IResourceSetProvider myResourceSetProvider;

        public ResourceSetResourceSetProviderPair(IUriMapResourceSetPair uriMapResourceSetPair, IResourceSetProvider resourceSetProvider) {
            this.myUriMapResourceSetPair = uriMapResourceSetPair;
            this.myResourceSetProvider = resourceSetProvider;
        }

        public IUriMapResourceSetPair getUriMapResourceSetPair() {
            return this.myUriMapResourceSetPair;
        }

        public IResourceSetProvider getResourceSetProvider() {
            return this.myResourceSetProvider;
        }
    }
}

