/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class StringOperations
extends AbstractContextualOperations {
    static CallHandler STRING_CONCAT = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            return ((String)source).concat(String.valueOf(args[0]));
        }
    };
    static final String LENGTH_NAME = "length";
    static final CallHandler LENGTH = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            return ((String)source).length();
        }
    };
    static final String SUBSTRING_BEFORE_NAME = "substringBefore";
    static final CallHandler SUBSTRING_BEFORE = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return evalEnv.getInvalid();
            }
            String self = (String)source;
            String arg = (String)leftVal;
            int pos = self.indexOf(arg);
            if (pos < 0) {
                return null;
            }
            return self.substring(0, pos);
        }
    };
    static final String SUBSTRING_AFTER_NAME = "substringAfter";
    static final CallHandler SUBSTRING_AFTER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return evalEnv.getInvalid();
            }
            String self = (String)source;
            String arg = (String)leftVal;
            int pos = self.indexOf(arg);
            if (pos < 0) {
                return null;
            }
            return self.substring(pos + arg.length());
        }
    };
    static final String FIRST_TO_UPPER_NAME = "firstToUpper";
    static final CallHandler FIRST_TO_UPPER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            if (self.length() == 0) {
                return self;
            }
            StringBuilder buf = new StringBuilder(self);
            buf.setCharAt(0, Character.toUpperCase(self.charAt(0)));
            return buf.toString();
        }
    };
    static final String LAST_TO_UPPER_NAME = "lastToUpper";
    static final CallHandler LAST_TO_UPPER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            if (self.length() == 0) {
                return self;
            }
            StringBuilder buf = new StringBuilder(self);
            int lastPos = self.length() - 1;
            buf.setCharAt(lastPos, Character.toUpperCase(self.charAt(lastPos)));
            return buf.toString();
        }
    };
    static final String INDEX_OF_NAME = "indexOf";
    static final CallHandler INDEX_OF = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return -1;
            }
            int result = self.indexOf((String)leftVal);
            return result >= 0 ? result + 1 : -1;
        }
    };
    static final String ENDS_WITH_NAME = "endsWith";
    static final CallHandler ENDS_WITH = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            return self.endsWith((String)leftVal);
        }
    };
    static final String STARTS_WITH_NAME = "startsWith";
    static final CallHandler STARTS_WITH = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            return self.startsWith((String)leftVal);
        }
    };
    static final String TRIME_NAME = "trim";
    static final CallHandler TRIM = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            return self.trim();
        }
    };
    static final String NORMALIZE_SPACE_NAME = "normalizeSpace";
    static final CallHandler NORMALIZE = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            self = self.trim();
            StringBuilder buf = new StringBuilder(self.length());
            boolean isWhiteArea = false;
            int i = 0;
            while (i < self.length()) {
                char c = self.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!isWhiteArea) {
                        isWhiteArea = true;
                        buf.append(c);
                    }
                } else {
                    isWhiteArea = false;
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
    };
    static final String REPLACE_NAME = "replace";
    static final CallHandler REPLACE = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object arg0 = args[0];
            if (arg0 == null && arg0 == evalEnv.getInvalid()) {
                return self;
            }
            Object arg1 = args[1];
            if (arg1 == null && arg1 == evalEnv.getInvalid()) {
                return evalEnv.getInvalid();
            }
            return self.replace((String)arg0, (String)arg1);
        }
    };
    static final String MATCH_NAME = "match";
    static final CallHandler MATCH = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            return Pattern.matches((String)leftVal, self);
        }
    };
    static final String EQUALS_IGNORE_CASE_NAME = "equalsIgnoreCase";
    static final CallHandler EQUALS_IGNORE_CASE = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            return self.equalsIgnoreCase((String)leftVal);
        }
    };
    static final String FIND_NAME = "find";
    static final CallHandler FIND = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return -1;
            }
            return self.indexOf((String)leftVal) + 1;
        }
    };
    static final String RFIND_NAME = "rfind";
    static final CallHandler RFIND = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return -1;
            }
            return self.lastIndexOf((String)leftVal) + 1;
        }
    };
    static final String IS_QUOTED_NAME = "isQuoted";
    static final CallHandler IS_QUOTED = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            String quoteStr = (String)leftVal;
            String self = (String)source;
            return self.length() >= quoteStr.length() * 2 && self.startsWith(quoteStr) && self.endsWith(quoteStr);
        }
    };
    static final String QUOTIFY_NAME = "quotify";
    static final CallHandler QUOTIFY = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return source;
            }
            String quoteStr = (String)leftVal;
            String self = (String)source;
            return String.valueOf(quoteStr) + self + quoteStr;
        }
    };
    static final String UNQUOTIFY_NAME = "unquotify";
    static final CallHandler UNQUOTIFY = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            if (!Boolean.TRUE.equals(IS_QUOTED.invoke(source, args, evalEnv, context))) {
                return source;
            }
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            String quoteStr = (String)leftVal;
            String self = (String)source;
            return self.substring(quoteStr.length(), self.length() - quoteStr.length());
        }
    };
    static final String MATCH_BOOLEAN_NAME = "matchBoolean";
    static final CallHandler MATCH_BOOLEAN = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            Boolean arg = (Boolean)leftVal;
            Object self = AS_BOOLEAN.invoke(source, args, evalEnv, context);
            return arg.equals(self);
        }
    };
    static final String MATCH_INTEGER_NAME = "matchInteger";
    static final CallHandler MATCH_INTEGER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            Integer arg = (Integer)leftVal;
            Object self = AS_INTEGER.invoke(source, args, evalEnv, context);
            return arg.equals(self);
        }
    };
    static final String MATCH_FLOAT_NAME = "matchFloat";
    static final CallHandler MATCH_FLOAT = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            Number arg = (Number)leftVal;
            Object self = AS_FLOAT.invoke(source, args, evalEnv, context);
            if (self != null) {
                if (arg.doubleValue() == ((Number)self).doubleValue()) {
                    return true;
                }
                return false;
            }
            return false;
        }
    };
    static final String MATCH_IDENTIFIER_NAME = "matchIdentifier";
    static final CallHandler MATCH_IDENTIFIER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            String self = (String)source;
            int i = 0;
            while (i < self.length()) {
                char c = self.charAt(i);
                if (i == 0 && !Character.isLetter(c) || !Character.isLetterOrDigit(c)) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }
    };
    static final String AS_BOOLEAN_NAME = "asBoolean";
    static final CallHandler AS_BOOLEAN = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            if (self.equals("1") || self.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (self.equals("0") || self.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            return null;
        }
    };
    static final String AS_INTEGER_NAME = "asInteger";
    static final CallHandler AS_INTEGER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Integer result = null;
            try {
                result = Integer.valueOf(self);
            }
            catch (NumberFormatException numberFormatException) {}
            return result;
        }
    };
    static final String AS_FLOAT_NAME = "asFloat";
    static final CallHandler AS_FLOAT = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            Double result = null;
            try {
                result = Double.valueOf(self);
            }
            catch (NumberFormatException numberFormatException) {}
            return result;
        }
    };
    static final String START_STR_COUNTER_NAME = "startStrCounter";
    static final CallHandler START_STR_COUNTER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            String counterName = (String)leftVal;
            StringCounter.getInstance(evalEnv).start(counterName);
            return null;
        }
    };
    static final String GET_STR_COUNTER_NAME = "getStrCounter";
    static final CallHandler GET_STR_COUNTER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            String counterName = (String)leftVal;
            return StringCounter.getInstance(evalEnv).value(counterName);
        }
    };
    static final String INCR_STR_COUNTER_NAME = "incrStrCounter";
    static final CallHandler INCR_STR_COUNTER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            Object leftVal = args[0];
            if (leftVal == null && leftVal == evalEnv.getInvalid()) {
                return false;
            }
            String counterName = (String)leftVal;
            return StringCounter.getInstance(evalEnv).increment(counterName);
        }
    };
    static final String RESTART_ALL_STR_COUNTER_NAME = "restartAllStrCounter";
    static final CallHandler RESTART_ALL_STR_COUNTER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            StringCounter.getInstance(evalEnv).restartAll();
            return null;
        }
    };
    static final String ADD_SUFFIX_NUMBER_NAME = "addSuffixNumber";
    static final CallHandler ADD_SUFFIX_NUMBER = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            String self = (String)source;
            StringCounter counters = StringCounter.getInstance(evalEnv);
            Integer currentValue = counters.value(self);
            if (currentValue == null) {
                counters.start(self);
                return self;
            }
            counters.increment(self);
            return String.valueOf(self) + currentValue.toString();
        }
    };

    public StringOperations(AbstractQVTStdlib library) {
        super(library, (EClassifier)library.getEnvironment().getOCLStandardLibrary().getString());
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary oclStdLib = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        return new AbstractContextualOperations.OperationProvider[]{new AbstractContextualOperations.OperationProvider(STRING_CONCAT, "+", (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(LENGTH, LENGTH_NAME, (EClassifier)oclStdLib.getInteger(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(SUBSTRING_BEFORE, SUBSTRING_BEFORE_NAME, (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(SUBSTRING_AFTER, SUBSTRING_AFTER_NAME, (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(FIRST_TO_UPPER, FIRST_TO_UPPER_NAME, (EClassifier)oclStdLib.getString(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(LAST_TO_UPPER, LAST_TO_UPPER_NAME, (EClassifier)oclStdLib.getString(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(INDEX_OF, INDEX_OF_NAME, (EClassifier)oclStdLib.getInteger(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(STARTS_WITH, STARTS_WITH_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(ENDS_WITH, ENDS_WITH_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(TRIM, TRIME_NAME, (EClassifier)oclStdLib.getString(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(NORMALIZE, NORMALIZE_SPACE_NAME, (EClassifier)oclStdLib.getString(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(REPLACE, REPLACE_NAME, (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(MATCH, MATCH_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(EQUALS_IGNORE_CASE, EQUALS_IGNORE_CASE_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(FIND, FIND_NAME, (EClassifier)oclStdLib.getInteger(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(RFIND, RFIND_NAME, (EClassifier)oclStdLib.getInteger(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(IS_QUOTED, IS_QUOTED_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(QUOTIFY, QUOTIFY_NAME, (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(UNQUOTIFY, UNQUOTIFY_NAME, (EClassifier)oclStdLib.getString(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(MATCH_BOOLEAN, MATCH_BOOLEAN_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getBoolean()), new AbstractContextualOperations.OperationProvider(MATCH_INTEGER, MATCH_INTEGER_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getInteger()), new AbstractContextualOperations.OperationProvider(MATCH_FLOAT, MATCH_FLOAT_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getReal()), new AbstractContextualOperations.OperationProvider(MATCH_IDENTIFIER, MATCH_IDENTIFIER_NAME, (EClassifier)oclStdLib.getBoolean(), (EClassifier)oclStdLib.getString()), new AbstractContextualOperations.OperationProvider(AS_BOOLEAN, AS_BOOLEAN_NAME, (EClassifier)oclStdLib.getBoolean(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(AS_INTEGER, AS_INTEGER_NAME, (EClassifier)oclStdLib.getInteger(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(AS_FLOAT, AS_FLOAT_NAME, (EClassifier)oclStdLib.getReal(), new EClassifier[0]), this.createStaticOperationProvider(START_STR_COUNTER, START_STR_COUNTER_NAME, (EClassifier)oclStdLib.getOclVoid(), (EClassifier)oclStdLib.getString()), this.createStaticOperationProvider(GET_STR_COUNTER, GET_STR_COUNTER_NAME, (EClassifier)oclStdLib.getInteger(), (EClassifier)oclStdLib.getString()), this.createStaticOperationProvider(INCR_STR_COUNTER, INCR_STR_COUNTER_NAME, (EClassifier)oclStdLib.getInteger(), (EClassifier)oclStdLib.getString()), this.createStaticOperationProvider(RESTART_ALL_STR_COUNTER, RESTART_ALL_STR_COUNTER_NAME, (EClassifier)oclStdLib.getOclVoid(), new EClassifier[0]), new AbstractContextualOperations.OperationProvider(ADD_SUFFIX_NUMBER, ADD_SUFFIX_NUMBER_NAME, (EClassifier)oclStdLib.getString(), new EClassifier[0])};
    }

    private static class CounterValue {
        int value;
        Integer cachedIntObj;

        CounterValue() {
            this.reset();
        }

        int increment() {
            return ++this.value;
        }

        void reset() {
            this.value = 0;
        }
    }

    private static class StringCounter {
        static final String DATA_KEY = StringCounter.class.getName();
        HashMap<String, CounterValue> counters = new HashMap();

        private StringCounter() {
        }

        static StringCounter getInstance(QvtOperationalEvaluationEnv env) {
            StringCounter counters = (StringCounter)env.getContext().get(DATA_KEY);
            if (counters == null) {
                counters = new StringCounter();
                env.getContext().put(DATA_KEY, counters);
            }
            return counters;
        }

        void restartAll() {
            for (CounterValue nextCounter : this.counters.values()) {
                nextCounter.reset();
            }
        }

        CounterValue get(String key, boolean onDemandCreate) {
            CounterValue value = this.counters.get(key);
            if (value == null && onDemandCreate) {
                value = new CounterValue();
                this.counters.put(key, value);
            }
            return value;
        }

        void start(String key) {
            this.get(key, true).reset();
        }

        int increment(String key) {
            return this.get(key, true).increment();
        }

        Integer value(String key) {
            CounterValue counterValue = this.get(key, false);
            if (counterValue != null) {
                return counterValue.value;
            }
            return null;
        }
    }
}

