/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.Transformation;
import org.eclipse.m2m.internal.qvt.oml.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.runtime.QvtRuntimePlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtLaunchUtil {
    private QvtLaunchUtil() {
    }

    public static ILaunchConfigurationType getInMemoryLaunchConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.m2m.qvt.oml.InMemoryQvtTransformation");
        if (type == null) {
            throw new RuntimeException("No launch configuration for id org.eclipse.m2m.qvt.oml.InMemoryQvtTransformation");
        }
        return type;
    }

    public static List<TargetUriData> getTargetUris(ILaunchConfiguration configuration) throws CoreException {
        int elemCount = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", 0);
        ArrayList<TargetUriData> targetUris = new ArrayList<TargetUriData>(elemCount);
        int i = 0;
        while (i < elemCount) {
            TargetUriData targetData = QvtLaunchUtil.getTargetUriData(configuration, i + 1);
            targetUris.add(targetData);
            ++i;
        }
        return targetUris;
    }

    public static String getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", null);
    }

    public static String getTraceFileURI(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", null);
    }

    public static boolean shouldGenerateTraceFile(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false);
    }

    public static boolean isIncrementalUpdate(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", false);
    }

    public static TargetUriData getTargetUriData(ILaunchConfiguration configuration, int index) throws CoreException {
        TargetUriData.TargetType targetType = TargetUriData.TargetType.NEW_MODEL;
        try {
            targetType = TargetUriData.TargetType.valueOf((String)configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetType", index), "NEW_MODEL"));
        }
        catch (Exception e) {
            targetType = TargetUriData.TargetType.NEW_MODEL;
        }
        String uri = configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetModel", index), "");
        String feature = configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.featureName", index), "");
        boolean clearContents = configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.clearContents", index), true);
        TargetUriData.ContentProvider contentProvider = null;
        if (configuration.getAttributes() != null) {
            contentProvider = (TargetUriData.ContentProvider)configuration.getAttributes().get(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.contentProvider", index));
        }
        return new TargetUriData(targetType, uri, feature, clearContents, contentProvider);
    }

    public static void saveTargetUriData(ILaunchConfigurationWorkingCopy configuration, List<TargetUriData> targetData) {
        int index = 1;
        for (TargetUriData targetUri : targetData) {
            QvtLaunchUtil.saveTargetUriData(configuration, targetUri, index);
            ++index;
        }
    }

    public static void saveTargetUriData(ILaunchConfigurationWorkingCopy configuration, TargetUriData targetData, int index) {
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetType", index), targetData.getTargetType().toString());
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetModel", index), targetData.getUriString());
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.featureName", index), targetData.getFeature());
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.clearContents", index), targetData.isClearContents());
        if (targetData.getContentProvider() != null) {
            try {
                LinkedHashMap<String, TargetUriData.ContentProvider> attributes = new LinkedHashMap<String, TargetUriData.ContentProvider>(configuration.getAttributes());
                attributes.put(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.contentProvider", index), targetData.getContentProvider());
                configuration.setAttributes(attributes);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static Map<String, Object> getConfigurationProperty(ILaunchConfiguration configuration) {
        return QvtLaunchUtil.loadConfigurationProperties(configuration);
    }

    public static ExecutionContext createContext(ILaunchConfiguration configuration) {
        return QvtLaunchUtil.createContext(configuration, Log.NULL_LOG, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ExecutionContext createContext(ILaunchConfiguration configuration, Log log, IProgressMonitor monitor) {
        return QvtLaunchUtil.createContext(QvtLaunchUtil.getConfigurationProperty(configuration), log, monitor);
    }

    public static ExecutionContext createContext(Map<String, Object> configProps) {
        return QvtLaunchUtil.createContext(configProps, Log.NULL_LOG);
    }

    public static ExecutionContext createContext(Map<String, Object> configProps, Log log) {
        return QvtLaunchUtil.createContext(configProps, log, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ExecutionContext createContext(Map<String, Object> configProps, Log log, IProgressMonitor monitor) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        if (configProps != null) {
            for (String name : configProps.keySet()) {
                context.setConfigProperty(name, configProps.get(name));
            }
        }
        context.setLog(log);
        context.setProgressMonitor(monitor);
        return context;
    }

    public static Map<String, Object> loadConfigurationProperties(ILaunchConfiguration configuration) {
        Map<String, Object> map;
        try {
            Map configProps = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", Collections.emptyMap());
            map = new LinkedHashMap(configProps);
        }
        catch (CoreException e) {
            map = Collections.emptyMap();
            QvtRuntimePlugin.getDefault().getLog().log(MiscUtil.makeErrorStatus((Exception)((Object)e)));
        }
        return map;
    }

    public static Map<String, Object> getConfigProperties(ExecutionContext context) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String name : context.getConfigPropertyNames()) {
            props.put(name, context.getConfigProperty(name));
        }
        return props;
    }

    private static String getIndexedName(String name, int index) {
        if (index == 0) {
            return name;
        }
        return String.valueOf(name) + index;
    }

    public static void doLaunch(QvtTransformation transformation, ILaunchConfiguration configuration, ExecutionContext context) throws CoreException {
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        ArrayList<URI> paramUris = new ArrayList<URI>(targetUris.size());
        for (TargetUriData data : targetUris) {
            paramUris.add(data.getUri());
        }
        String traceFile = QvtLaunchUtil.getTraceFileURI(configuration);
        QvtLaunchUtil.doLaunch(transformation, paramUris, QvtLaunchUtil.toUri(traceFile), context, QvtLaunchUtil.shouldGenerateTraceFile(configuration), QvtLaunchUtil.isIncrementalUpdate(configuration));
    }

    @Deprecated
    public static void doLaunch(QvtTransformation transformation, List<ModelContent> inObjs, Map<String, Object> configProps, List<ModelExtentContents> outExtents, List<EObject> outMainParams, List<Trace> outTraces, List<String> outConsole) throws MdaException {
        IStatus status = QvtValidator.validateTransformation(transformation, inObjs, null);
        if (status.getSeverity() > 2) {
            throw new MdaException(status);
        }
        StringWriter consoleLogger = new StringWriter();
        ExecutionContext context = QvtLaunchUtil.createContext(configProps, (Log)new WriterLog((Writer)consoleLogger));
        TransformationRunner.In in = new TransformationRunner.In(inObjs.toArray(new ModelContent[inObjs.size()]), context);
        TransformationRunner.Out out = transformation.run(in);
        outExtents.addAll(out.getExtents());
        for (Object outValue : out.getOutParamValues()) {
            if (outValue instanceof EObject) {
                outMainParams.add((EObject)outValue);
                continue;
            }
            outMainParams.add(null);
        }
        if (out.getTrace() != null) {
            outTraces.add(out.getTrace());
        }
        outConsole.add(consoleLogger.getBuffer().toString());
    }

    public static void doLaunch(QvtTransformation transf, List<URI> paramUris, URI traceUri, ExecutionContext context, boolean isSaveTrace, boolean isIncrementalUpdate) throws CoreException {
        QvtTransformationRunner runner = new QvtTransformationRunner(transf, paramUris);
        runner.setTraceFile(traceUri);
        runner.setSaveTrace(isSaveTrace && traceUri != null);
        runner.setIncrementalUpdate(isIncrementalUpdate && traceUri != null);
        Diagnostic diag = runner.execute(context);
        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)diag);
        if (!status.isOK()) {
            Throwable e = diag.getException();
            if (e instanceof QvtRuntimeException) {
                throw (QvtRuntimeException)e;
            }
            throw new CoreException(status);
        }
    }

    private static URI toUri(String uriString) throws CoreException {
        if (uriString == null || uriString.length() == 0) {
            return null;
        }
        URI uri = EmfUtil.makeUri((String)uriString);
        if (uri == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", NLS.bind((String)Messages.QvtValidator_InvalidUri, (Object)uriString)));
        }
        return uri;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QvtTransformationRunner
    extends TransformationRunner {
        public QvtTransformationRunner(QvtTransformation transf, List<URI> paramUris) {
            super((Transformation)transf, paramUris);
        }
    }
}

