/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorskpaceMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;
import org.eclipse.osgi.util.NLS;

public class WorkspaceMetamodelRegistryProvider
implements IMetamodelRegistryProvider {
    private ResourceSet resolutionRSet;
    private Map<String, MetamodelRegistry> perProjectRegs;

    public WorkspaceMetamodelRegistryProvider() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public WorkspaceMetamodelRegistryProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException();
        }
        this.resolutionRSet = resourceSet;
    }

    public ResourceSet getResolutionResourceSet() {
        return this.resolutionRSet;
    }

    public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
        IProject project;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        URI uri = context.getURI();
        if (!uri.isPlatformResource()) {
            return MetamodelRegistry.getInstance();
        }
        Path wsLocation = new Path(uri.toPlatformString(true));
        IResource wsResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)wsLocation);
        if (wsResource == null) {
            wsResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)wsLocation);
        }
        if (wsResource != null && MetamodelURIMappingHelper.hasMappingResource((IProject)(project = wsResource.getProject()))) {
            String projectKey;
            MetamodelRegistry reg;
            if (this.perProjectRegs == null) {
                this.perProjectRegs = new HashMap<String, MetamodelRegistry>();
            }
            if ((reg = this.perProjectRegs.get(projectKey = project.getFullPath().toString())) == null) {
                try {
                    reg = this.createRegistry(MetamodelURIMappingHelper.loadMappings((IProject)project));
                    this.perProjectRegs.put(projectKey, reg);
                    return reg;
                }
                catch (IOException e) {
                    CommonPlugin.log(e);
                }
            } else {
                return reg;
            }
        }
        return MetamodelRegistry.getInstance();
    }

    private MetamodelRegistry createRegistry(MappingContainer mappings) {
        WorskpaceMetamodelProvider metamodelProvider = new WorskpaceMetamodelProvider(this.resolutionRSet);
        for (URIMapping nextMapping : mappings.getMapping()) {
            URI uri = null;
            IllegalArgumentException error = null;
            try {
                uri = URI.createURI((String)nextMapping.getTargetURI());
            }
            catch (IllegalArgumentException e) {
                error = e;
            }
            if (uri != null && nextMapping.getSourceURI() != null) {
                metamodelProvider.addMetamodel(nextMapping.getSourceURI(), uri);
                continue;
            }
            String message = NLS.bind((String)"Invalid metamodel uri mapping. nsUri:''{0}'' modelUri:''{1}''", (Object)nextMapping.getSourceURI(), (Object)nextMapping.getTargetURI());
            CommonPlugin.log((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.common", message, (Throwable)error));
        }
        return new MetamodelRegistry((IMetamodelProvider)metamodelProvider);
    }
}

