/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;

public class WorkspaceMetamodelProvider
implements IMetamodelProvider {
    private ResourceSet resSet;
    private IWorkspace workspace;

    public WorkspaceMetamodelProvider() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public WorkspaceMetamodelProvider(ResourceSet resolutionRSet) {
        this(ResourcesPlugin.getWorkspace(), resolutionRSet);
    }

    private WorkspaceMetamodelProvider(IWorkspace workspace, ResourceSet resolutionRSet) {
        this.workspace = workspace;
        this.resSet = resolutionRSet;
    }

    private IMetamodelDesc createMetamodelDesc(String metamodelID, URI metamodelResourceURI) {
        if (metamodelID == null) {
            throw new IllegalArgumentException("Null metamodel ID");
        }
        if (metamodelResourceURI == null) {
            throw new IllegalArgumentException("Null metamodel resource URI");
        }
        IMetamodelProvider.DescImpl ePackageDesc = new IMetamodelProvider.DescImpl(metamodelResourceURI, this.resSet);
        EmfMetamodelDesc desc = new EmfMetamodelDesc(ePackageDesc, metamodelID);
        return desc;
    }

    public IMetamodelDesc getMetamodel(String id) {
        IPath path = Path.fromPortableString((String)id);
        IResource resource = this.workspace.getRoot().findMember(path);
        if (resource != null) {
            URI resourceUri = URIUtils.getResourceURI(resource);
            return this.createMetamodelDesc(path.makeRelative().toPortableString(), resourceUri);
        }
        return null;
    }

    public EPackage.Registry getPackageRegistry() {
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        IMetamodelDesc[] iMetamodelDescArray = this.getMetamodels();
        int n = iMetamodelDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetamodelDesc desc = iMetamodelDescArray[n2];
            EPackage ePackage = desc.getModel();
            registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
            ++n2;
        }
        return registry;
    }

    public IMetamodelDesc[] getMetamodels() {
        final ArrayList metamodels = new ArrayList();
        try {
            this.workspace.getRoot().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && MetamodelRegistry.isMetamodelFileName(proxy.getName())) {
                        URI resourceUri = URIUtils.getResourceURI(proxy.requestResource());
                        IMetamodelDesc desc = WorkspaceMetamodelProvider.this.createMetamodelDesc(proxy.requestFullPath().makeRelative().toPortableString(), resourceUri);
                        metamodels.add(desc);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            EmfUtilPlugin.log(e);
        }
        return metamodels.toArray(new IMetamodelDesc[0]);
    }

    public static EPackage loadResourceMetamodel(String uriStr) {
        return WorkspaceMetamodelProvider.loadResourceMetamodel(uriStr, (ResourceSet)new ResourceSetImpl());
    }

    public static EPackage loadResourceMetamodel(String uriStr, ResourceSet rs) {
        IMetamodelDesc desc = new WorkspaceMetamodelProvider(rs).getMetamodel(URI.createURI((String)uriStr).toPlatformString(true));
        return desc.getModel();
    }
}

