/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class PluginImages {
    private final URL myBaseUrl;
    private final ImageRegistry myImageRegistry;
    private final HashMap<String, ImageDescriptor> myImageDescriptors;
    private final ImageDescriptor myMissingImageDescriptor;
    private Image myMissingImage;

    protected PluginImages(URL baseUrl) {
        this.myBaseUrl = baseUrl;
        this.myImageRegistry = new ImageRegistry(PluginImages.getStandardDisplay());
        this.myImageDescriptors = new HashMap();
        this.myMissingImageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        this.myMissingImage = null;
        this.declareImages();
    }

    protected abstract void declareImages();

    public Image getImage(String key) {
        Image image = this.myImageRegistry.get(key);
        if (image == null) {
            image = this.getMissingImage();
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor desc = this.myImageDescriptors.get(key);
        if (desc == null) {
            desc = this.myMissingImageDescriptor;
        }
        return desc;
    }

    private Image getMissingImage() {
        if (this.myMissingImage == null) {
            this.myMissingImage = this.myMissingImageDescriptor.createImage();
        }
        return this.myMissingImage;
    }

    protected void declareRegistryImage(String key, String path) {
        ImageDescriptor desc;
        try {
            desc = ImageDescriptor.createFromURL((URL)this.makeURL(path));
        }
        catch (MalformedURLException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to load " + path, e);
            desc = this.myMissingImageDescriptor;
        }
        this.declareImage(key, desc);
    }

    public void declareImage(String key, ImageDescriptor desc) {
        this.myImageRegistry.put(key, desc);
        this.myImageDescriptors.put(key, desc);
    }

    private URL makeURL(String path) throws MalformedURLException {
        URL url = new URL(this.myBaseUrl, path);
        return url;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

