/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;

public class ImportHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        URI sourceFileURI = ImportHyperlinkDetector.findDefinition(syntaxElement);
        if (sourceFileURI != null) {
            PathNameCS linkNodeCS;
            Region destRegion = new Region(0, 0);
            ImportCS importCS = ImportHyperlinkDetector.getImport(syntaxElement);
            PathNameCS pathNameCS = linkNodeCS = importCS != null ? importCS.getPathNameCS() : null;
            if (linkNodeCS == null) {
                linkNodeCS = syntaxElement;
            }
            IRegion hlinkReg = HyperlinkUtil.createRegion((CSTNode)linkNodeCS);
            return new QvtFileHyperlink(hlinkReg, sourceFileURI, (IRegion)destRegion, (IRegion)destRegion);
        }
        return null;
    }

    public static URI findDefinition(CSTNode syntaxElement) {
        ImportCS importCS = ImportHyperlinkDetector.getImport(syntaxElement);
        if (importCS != null && importCS.getAst() instanceof URI) {
            return (URI)importCS.getAst();
        }
        return null;
    }

    private static ImportCS getImport(CSTNode syntaxElement) {
        ImportCS importCS = null;
        if (syntaxElement instanceof ImportCS) {
            importCS = (ImportCS)syntaxElement;
        } else if (syntaxElement instanceof PathNameCS && syntaxElement.eContainer() instanceof ImportCS) {
            importCS = (ImportCS)syntaxElement.eContainer();
        }
        return importCS;
    }
}

