/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOStandardLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtTypeResolverImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.VirtualTableAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QvtEnvironmentBase
extends EcoreEnvironment
implements QVTOEnvironment {
    public static final String GENERATED_NAME_SPECIAL_PREFIX = "$";
    private static final String TEMPORARY_NAME_GENERATOR_UNIQUE_PREFIX = "$temp_";
    private int myTemporaryNameGeneratorInt = 0;
    private List<Variable> myImplicitVars = new LinkedList<Variable>();
    private QVTUMLReflection fQVUMLReflection;
    private List<QvtEnvironmentBase> fByAccess;
    private List<QvtEnvironmentBase> fByExtension;
    private List<QvtEnvironmentBase> fAllExtendedModuleEnvs;
    private Map<URI, Set<String>> fImportedNativeLibs;

    protected QvtEnvironmentBase(QvtEnvironmentBase parent) {
        super((Environment)parent);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, true);
    }

    protected QvtEnvironmentBase(EPackage.Registry reg, Resource resource) {
        super(reg, resource);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, true);
    }

    protected QvtEnvironmentBase(EPackage.Registry reg) {
        super(reg);
        this.setOption(ParsingOptions.USE_BACKSLASH_ESCAPE_PROCESSING, true);
    }

    @Override
    public abstract Module getModuleContextType();

    public void addImplicitVariableForProperties(String name, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> elem) {
        this.getUMLReflection().setName(elem, name);
        this.addedVariable(name, elem, false);
    }

    protected void addedVariable(String name, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> elem, boolean isExplicit) {
        Variable elemVar = (Variable)elem;
        if (!isExplicit) {
            this.myImplicitVars.add(elemVar);
        }
        if (!(elemVar instanceof VarParameter) && elemVar.eContainer() == null) {
            if (this.getContextOperation() instanceof ImperativeOperation) {
                ImperativeOperation imperativeOperation = (ImperativeOperation)this.getContextOperation();
                if (imperativeOperation.getBody() != null) {
                    imperativeOperation.getBody().getVariable().add((Object)elemVar);
                } else {
                    super.addedVariable(name, (org.eclipse.ocl.expressions.Variable)elemVar, isExplicit);
                }
            } else {
                super.addedVariable(name, (org.eclipse.ocl.expressions.Variable)elemVar, isExplicit);
            }
        }
    }

    protected void removedVariable(String name, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable, boolean isExplicit) {
        if (!isExplicit) {
            this.myImplicitVars.remove(variable);
        }
        super.removedVariable(name, variable, isExplicit);
    }

    public Collection<Variable> getImplicitVariables() {
        return Collections.unmodifiableCollection(this.myImplicitVars);
    }

    protected org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> localLookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
        return super.lookupImplicitSourceForOperation(name, args);
    }

    public org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
        try {
            return this.tryLookupImplicitSourceForOperation(name, args);
        }
        catch (LookupException e) {
            List ambiguousMatches = e.getAmbiguousMatches();
            org.eclipse.ocl.expressions.Variable result = ambiguousMatches.isEmpty() ? null : (org.eclipse.ocl.expressions.Variable)ambiguousMatches.get(0);
            return result;
        }
    }

    public org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> tryLookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> result = super.lookupImplicitSourceForOperation(name, args);
        if (result == null) {
            QvtEnvironmentBase rootEnv = this.getRootEnv();
            if (rootEnv != this) {
                return this.getInternalParent().lookupImplicitSourceForOperation(name, args);
            }
            for (QvtEnvironmentBase nextExtendedEnv : rootEnv.getAllExtendedModules()) {
                result = nextExtendedEnv.localLookupImplicitSourceForOperation(name, args);
                if (result == null) continue;
                return result;
            }
            for (QvtEnvironmentBase nextAccessedEnv : rootEnv.getImportsByAccess()) {
                Module importedModule = nextAccessedEnv.getModuleContextType();
                if (importedModule instanceof Library && (result = nextAccessedEnv.localLookupImplicitSourceForOperation(name, args)) != null) break;
            }
        }
        return result;
    }

    private org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> lookupImplicitSourceForPropertyInternal(String name) {
        EStructuralFeature property;
        EClassifier owner;
        org.eclipse.ocl.expressions.Variable vdcl;
        int i = this.myImplicitVars.size() - 1;
        while (i >= 0) {
            EClassifier actualPropertyOwner;
            EStructuralFeature property2;
            vdcl = (org.eclipse.ocl.expressions.Variable)this.myImplicitVars.get(i);
            EClassifier owner2 = (EClassifier)vdcl.getType();
            if (owner2 != null && (property2 = this.safeTryLookupPropertyInternal(owner2, name)) != null && TypeUtil.compatibleTypeMatch((Environment)this, (Object)owner2, (Object)(actualPropertyOwner = (EClassifier)this.getUMLReflection().getOwningClassifier((Object)property2)))) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = (EClassifier)vdcl.getType()) != null && (property = this.safeTryLookupPropertyInternal(owner, name)) != null) {
            return vdcl;
        }
        return null;
    }

    private EStructuralFeature safeTryLookupPropertyInternal(EClassifier owner, String name) {
        EStructuralFeature result;
        block2: {
            result = null;
            try {
                result = this.tryLookupProperty(owner, name);
            }
            catch (LookupException e) {
                if (e.getAmbiguousMatches().isEmpty()) break block2;
                result = (EStructuralFeature)e.getAmbiguousMatches().get(0);
            }
        }
        return result;
    }

    public org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> lookupImplicitSourceForProperty(String name) {
        org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> result = this.lookupImplicitSourceForPropertyInternal(name);
        if (result == null) {
            QvtEnvironmentBase rootEnv = this.getRootEnv();
            if (rootEnv != this) {
                return this.getInternalParent().lookupImplicitSourceForProperty(name);
            }
            for (QvtEnvironmentBase nextSiblingEnv : rootEnv.getImportsByExtends()) {
                result = nextSiblingEnv.lookupImplicitSourceForProperty(name);
                if (result == null) continue;
                return result;
            }
            for (QvtEnvironmentBase nextSiblingEnv : rootEnv.getImportsByAccess()) {
                Module importedModule = nextSiblingEnv.getModuleContextType();
                if (importedModule instanceof Library && (result = nextSiblingEnv.lookupImplicitSourceForProperty(name)) != null) break;
            }
        }
        return result;
    }

    final QvtTypeResolverImpl getQVTTypeResolver() {
        return (QvtTypeResolverImpl)this.getTypeResolver();
    }

    @Override
    public QVTOTypeResolver getTypeResolver() {
        return (QVTOTypeResolver)super.getTypeResolver();
    }

    @Override
    public QVTOStandardLibrary getQVTStandardLibrary() {
        return QvtOperationalStdLibrary.INSTANCE;
    }

    public List<EOperation> getAdditionalOperations(EClassifier classifier) {
        if (classifier instanceof VoidType) {
            ArrayList<EOperation> result = new ArrayList<EOperation>();
            this.getAllContextualOperations(result, this);
            for (QvtEnvironmentBase nextImportedEnv : this.getImportsByExtends()) {
                this.getAllContextualOperations(result, nextImportedEnv);
            }
            return result;
        }
        if (classifier instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)classifier;
            ArrayList<EOperation> result = new ArrayList<EOperation>();
            this.getLocalAdditionalCollectionOperations(collectionType, result);
            for (QvtEnvironmentBase nextImportedEnv : this.getImportsByExtends()) {
                nextImportedEnv.getLocalAdditionalCollectionOperations(collectionType, result);
            }
            for (QvtEnvironmentBase nextImportedEnv : this.getImportsByAccess()) {
                nextImportedEnv.getLocalAdditionalCollectionOperations(collectionType, result);
            }
            return result;
        }
        return super.getAdditionalOperations((Object)classifier);
    }

    private void getAllContextualOperations(List<EOperation> result, QvtEnvironmentBase env) {
        if (env.getModuleContextType() == null) {
            return;
        }
        for (EOperation operation : env.getModuleContextType().getEOperations()) {
            ImperativeOperation imperative;
            if (!(operation instanceof ImperativeOperation) || !QvtOperationalParserUtil.isContextual(imperative = (ImperativeOperation)operation)) continue;
            result.add(imperative);
        }
    }

    private void getLocalAdditionalCollectionOperations(CollectionType collectionType, List<EOperation> result) {
        OCLStandardLibrary oclstdlib = this.getOCLStandardLibrary();
        EcorePackage typePackage = EcorePackage.eINSTANCE;
        EClass metaType = collectionType.eClass();
        EClassifier genericBaseType = null;
        if (metaType == typePackage.getCollectionType() && collectionType != oclstdlib.getCollection()) {
            genericBaseType = (EClassifier)oclstdlib.getCollection();
        } else if (metaType == typePackage.getBagType() && collectionType != oclstdlib.getBag()) {
            genericBaseType = (EClassifier)oclstdlib.getBag();
        } else if (metaType == typePackage.getSequenceType() && collectionType != oclstdlib.getSequence()) {
            genericBaseType = (EClassifier)oclstdlib.getSequence();
        } else if (metaType == typePackage.getSetType() && collectionType != oclstdlib.getSet()) {
            genericBaseType = (EClassifier)oclstdlib.getSet();
        } else if (metaType == typePackage.getOrderedSetType() && collectionType != oclstdlib.getOrderedSet()) {
            genericBaseType = (EClassifier)oclstdlib.getOrderedSet();
        } else if (metaType == ImperativeOCLPackage.eINSTANCE.getListType() && collectionType != this.getQVTStandardLibrary().getList()) {
            genericBaseType = this.getQVTStandardLibrary().getList();
        } else if (metaType == ImperativeOCLPackage.eINSTANCE.getDictionaryType() && collectionType != this.getQVTStandardLibrary().getDictionary()) {
            genericBaseType = this.getQVTStandardLibrary().getDictionary();
        }
        QvtTypeResolverImpl thisResolver = this.getQVTTypeResolver();
        if (genericBaseType != null) {
            thisResolver.getLocalCollectionAdditionalOperations((CollectionType)genericBaseType, result, false);
        }
        thisResolver.getLocalCollectionAdditionalOperations(collectionType, result, true);
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        Environment.Internal parent = this.getInternalParent();
        if (parent != null) {
            return parent.getUMLReflection();
        }
        if (this.fQVUMLReflection == null) {
            this.fQVUMLReflection = new QVTUMLReflection((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection());
        }
        return this.fQVUMLReflection;
    }

    @Override
    public void close() {
        if (this.getInternalParent() == null) {
            if (this.fQVUMLReflection != null) {
                this.fQVUMLReflection.close();
            }
            if (this != QvtOperationalStdLibrary.INSTANCE.getEnvironment()) {
                QvtOperationalStdLibrary.INSTANCE.getEnvironment().close();
            }
        }
    }

    public final void addImport(ImportKind kind, QvtEnvironmentBase importedEnv) {
        List<QvtEnvironmentBase> container;
        QvtEnvironmentBase rootEnv = this.getRootEnv();
        if (rootEnv != this) {
            rootEnv.addImport(kind, importedEnv);
            return;
        }
        if (importedEnv == null || importedEnv == this || this.isOneOfParents(importedEnv)) {
            throw new IllegalArgumentException("Illegal import environment: " + String.valueOf(importedEnv));
        }
        if (kind == ImportKind.ACCESS) {
            if (this.fByAccess == null) {
                this.fByAccess = new UniqueEList();
            }
            container = this.fByAccess;
        } else {
            if (this.fByExtension == null) {
                this.fByExtension = new UniqueEList();
            }
            container = this.fByExtension;
            this.fAllExtendedModuleEnvs = null;
        }
        this.fImportedNativeLibs = null;
        assert (container != null);
        container.add(importedEnv);
    }

    public final List<QvtEnvironmentBase> getImportsByAccess() {
        QvtEnvironmentBase rootEnv = this.getRootEnv();
        if (rootEnv != this) {
            return rootEnv.getImportsByAccess();
        }
        return this.fByAccess != null ? this.fByAccess : Collections.emptyList();
    }

    public List<QvtEnvironmentBase> getAllExtendedModules() {
        QvtEnvironmentBase rootEnv = this.getRootEnv();
        if (rootEnv != this) {
            return rootEnv.getAllExtendedModules();
        }
        if (this.fAllExtendedModuleEnvs == null) {
            LinkedHashSet<QvtEnvironmentBase> result = new LinkedHashSet<QvtEnvironmentBase>();
            List<QvtEnvironmentBase> importsByExtends = this.getImportsByExtends();
            for (QvtEnvironmentBase nextImportedEnv : importsByExtends) {
                result.add(nextImportedEnv);
                result.addAll(nextImportedEnv.getAllExtendedModules());
            }
            result.remove(this);
            this.fAllExtendedModuleEnvs = Collections.unmodifiableList(new ArrayList(result));
        }
        return this.fAllExtendedModuleEnvs;
    }

    public final List<QvtEnvironmentBase> getImportsByExtends() {
        QvtEnvironmentBase rootEnv = this.getRootEnv();
        if (rootEnv != this) {
            return rootEnv.getImportsByExtends();
        }
        return this.fByExtension != null ? this.fByExtension : Collections.emptyList();
    }

    public Map<URI, Set<String>> getImportedNativeLibs() {
        QvtEnvironmentBase rootEnv = this.getRootEnv();
        if (rootEnv != this) {
            return rootEnv.getImportedNativeLibs();
        }
        if (this.fImportedNativeLibs == null) {
            LinkedHashSet<QvtEnvironmentBase> imports = new LinkedHashSet<QvtEnvironmentBase>();
            imports.addAll(this.getImportsByExtends());
            imports.addAll(this.getImportsByAccess());
            LinkedHashMap<URI, LinkedHashSet<String>> result = new LinkedHashMap<URI, LinkedHashSet<String>>(imports.size());
            for (QvtEnvironmentBase sibling : imports) {
                URI uri;
                Module module = sibling.getModuleContextType();
                if (module == null || module.eResource() == null || !BlackboxUnitResolver.isBlackboxUnitURI(uri = module.eResource().getURI())) continue;
                LinkedHashSet<String> names = (LinkedHashSet<String>)result.get(uri);
                if (names == null) {
                    names = new LinkedHashSet<String>();
                    result.put(uri, names);
                }
                names.add(module.getName());
            }
            this.fImportedNativeLibs = Collections.unmodifiableMap(result);
        }
        return this.fImportedNativeLibs;
    }

    protected final CollisionStatus findCollidingOperation(EClassifier ownerType, ImperativeOperation operation) {
        return this.doFindCollidingOperation(ownerType, operation);
    }

    private EOperation findMatchingFromExtended(Module extending, EOperation operation) {
        Library stdLibModule = this.getQVTStandardLibrary().getStdLibModule();
        EOperation result = null;
        for (ModuleImport nextImport : extending.getModuleImport()) {
            Module nextImportedModule = nextImport.getImportedModule();
            if (nextImportedModule == stdLibModule) continue;
            EList importedOpers = nextImportedModule.getEOperations();
            String name = operation.getName();
            if (name != null) {
                for (EOperation nextImportedOper : importedOpers) {
                    if (!name.equals(nextImportedOper.getName()) || !this.matchParameters(nextImportedOper, operation) || nextImportedOper instanceof ImperativeOperation && operation instanceof ImperativeOperation && !this.matchContext((ImperativeOperation)nextImportedOper, (ImperativeOperation)operation)) continue;
                    return nextImportedOper;
                }
            }
            if ((result = this.findMatchingFromExtended(nextImportedModule, operation)) == null) continue;
            return result;
        }
        return null;
    }

    private CollisionStatus doFindCollidingOperation(EClassifier ownerType, ImperativeOperation operation) {
        boolean isContextual;
        CollisionStatus result = null;
        Module definingModule = this.getModuleContextType();
        String operationName = this.getUMLReflection().getName((Object)operation);
        LinkedHashSet<EOperation> operations = new LinkedHashSet<EOperation>(TypeUtil.getOperations((Environment)this, (Object)ownerType));
        boolean bl = isContextual = ownerType != definingModule;
        if (!isContextual) {
            EOperation overridden = this.findMatchingFromExtended(this.getModuleContextType(), operation);
            if (overridden != null) {
                operations.add(overridden);
            }
        } else {
            this.getQVTTypeResolver().collectAdditionalOperationsInTypeHierarchy(ownerType, true, operations);
        }
        for (EOperation next : operations) {
            int rel;
            EClassifier nextOwner;
            if (next == operation || !this.getUMLReflection().getName((Object)next).equals(operationName) || !this.matchParameters(next, operation) || (nextOwner = (EClassifier)this.getUMLReflection().getOwningClassifier((Object)next)) == null) continue;
            if (isContextual && (rel = TypeUtil.getRelationship((Environment)this, (Object)ownerType, (Object)nextOwner)) != 1 && (7 & rel) != 0) {
                EClassifier ret1 = next.getEType();
                EClassifier ret2 = operation.getEType();
                if (ret1 != null && ret2 != null && TypeUtil.getRelationship((Environment)this, (Object)ret1, (Object)ret2) != 1) {
                    if ("main".equals(operationName)) {
                        return null;
                    }
                    return new CollisionStatus(next, 2);
                }
                if (QvtOperationalUtil.isImperativeOperation(operation) && QvtOperationalUtil.isImperativeOperation(next)) {
                    VirtualTable sourceOperVtable = this.getVirtualTable(operation);
                    sourceOperVtable.addOperation(next);
                    if (!this.isImportedByAccess(next)) {
                        VirtualTable targetOperVtable = this.getVirtualTable(next);
                        targetOperVtable.addOperation(operation);
                    }
                }
            }
            if (ownerType != nextOwner && isContextual) continue;
            if (definingModule != next.getEContainingClass()) {
                if (!this.isImportedByExtends(next)) continue;
                result = new CollisionStatus(next, 3);
                continue;
            }
            return new CollisionStatus(next, 1);
        }
        return result;
    }

    private boolean isImportedByAccess(EOperation operation) {
        Module definingModule = QvtOperationalParserUtil.getOwningModule(operation);
        for (QvtEnvironmentBase nextImport : this.getImportsByAccess()) {
            if (definingModule != nextImport.getModuleContextType()) continue;
            return true;
        }
        return false;
    }

    private boolean isImportedByExtends(EOperation operation) {
        Module definingModule = QvtOperationalParserUtil.getOwningModule(operation);
        if (definingModule == null) {
            return false;
        }
        for (QvtEnvironmentBase nextImport : this.getAllExtendedModules()) {
            if (definingModule != nextImport.getModuleContextType()) continue;
            return true;
        }
        return false;
    }

    private VirtualTable getVirtualTable(EOperation operation) {
        return VirtualTableAdapter.getAdapter(operation, true).getVirtualTable();
    }

    private boolean matchParameters(EOperation a, EOperation b) {
        List aparms = this.getUMLReflection().getParameters((Object)a);
        List bparms = this.getUMLReflection().getParameters((Object)b);
        if (aparms.size() == bparms.size()) {
            int count = aparms.size();
            int i = 0;
            while (i < count) {
                EParameter aparm = (EParameter)aparms.get(i);
                EParameter bparm = (EParameter)bparms.get(i);
                if (!TypeUtil.exactTypeMatch((Environment)this, (Object)((EClassifier)this.getUMLReflection().getOCLType((Object)aparm)), (Object)((EClassifier)this.getUMLReflection().getOCLType((Object)bparm)))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean matchContext(ImperativeOperation a, ImperativeOperation b) {
        return this.getTypeChecker().exactTypeMatch((Object)((EClassifier)this.getUMLReflection().getOCLType((Object)a.getContext())), (Object)((EClassifier)this.getUMLReflection().getOCLType((Object)b.getContext())));
    }

    private boolean isOneOfParents(EcoreEnvironment env) {
        EcoreEnvironment parent = (EcoreEnvironment)env.getInternalParent();
        while (parent != null) {
            if (parent == env) {
                return true;
            }
            parent = (EcoreEnvironment)parent.getInternalParent();
        }
        return false;
    }

    protected QvtEnvironmentBase getRootEnv() {
        QvtEnvironmentBase root = this;
        while (root.getInternalParent() instanceof QvtEnvironmentBase) {
            root = (QvtEnvironmentBase)root.getInternalParent();
        }
        return root;
    }

    public String generateTemporaryName() {
        String name;
        QvtEnvironmentBase rootEnv = this.getRootEnv();
        while (this.lookup(name = rootEnv.generateTemporaryNameInternal()) != null) {
        }
        return name;
    }

    public boolean isTemporaryElement(String name) {
        return name != null && name.startsWith(TEMPORARY_NAME_GENERATOR_UNIQUE_PREFIX);
    }

    private String generateTemporaryNameInternal() {
        ++this.myTemporaryNameGeneratorInt;
        return TEMPORARY_NAME_GENERATOR_UNIQUE_PREFIX + this.myTemporaryNameGeneratorInt;
    }

    public void parserError(int errorCode, int leftToken, int rightToken, String tokenText) {
        String message;
        int line;
        ProblemHandler problemHandler = this.getProblemHandler();
        if (problemHandler == null) {
            return;
        }
        int leftTokenLoc = leftToken > rightToken ? rightToken : leftToken;
        int rightTokenLoc = rightToken;
        int startOffset = this.getParser().getIPrsStream().getStartOffset(leftTokenLoc);
        int endOffset = this.getParser().getIPrsStream().getEndOffset(rightTokenLoc);
        int n = line = leftTokenLoc >= 0 ? this.getParser().getIPrsStream().getLine(leftTokenLoc) : -1;
        if (line <= 0) {
            message = OCLMessages.InvalidOCL_ERROR_;
        } else {
            String locInfo = "";
            String messageTemplate = ProblemHandler.ERROR_MESSAGES[errorCode].substring(4);
            String inputText = String.valueOf('\"') + this.getParser().computeInputString(startOffset, endOffset) + '\"';
            switch (errorCode) {
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    message = OCLMessages.bind((String)messageTemplate, (Object)locInfo, (Object)inputText);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    message = OCLMessages.bind((String)messageTemplate, (Object[])new Object[]{locInfo, tokenText, inputText});
                    break;
                }
                case 9: {
                    if (leftToken != rightToken) {
                        message = OCLMessages.bind((String)messageTemplate, (Object)locInfo, (Object)tokenText);
                        problemHandler.parserProblem(ProblemHandler.Severity.ERROR, message, null, startOffset, this.getParser().getIPrsStream().getEndOffset(leftTokenLoc));
                    }
                    startOffset = this.getParser().getIPrsStream().getStartOffset(rightTokenLoc);
                }
                default: {
                    message = OCLMessages.bind((String)messageTemplate, (Object)locInfo, (Object)tokenText);
                }
            }
        }
        problemHandler.parserProblem(ProblemHandler.Severity.ERROR, message, null, startOffset, endOffset);
    }

    public static class CollisionStatus {
        public static final int ALREADY_DEFINED = 1;
        public static final int VIRTUAL_METHOD_RETURNTYPE = 2;
        public static final int OVERRIDES = 3;
        private int fKind;
        private EOperation fOperation;

        CollisionStatus(EOperation operation, int kind) {
            if (kind != 1 && kind != 2 && kind != 3) {
                throw new IllegalArgumentException("illegal collision kind");
            }
            this.fKind = kind;
            this.fOperation = operation;
        }

        public int getCollisionKind() {
            return this.fKind;
        }

        public EOperation getOperation() {
            return this.fOperation;
        }
    }
}

