/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.part;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.usecase.expressions.UMLOCLFactory;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public class UMLVisualIDRegistry {
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public String getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public String getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(String visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(String visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static String getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UseCase".equals(view.getType())) {
                return "Package_UseCaseDiagram";
            }
            return "";
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static String getVisualID(String type) {
        return type;
    }

    public static String getType(String visualID) {
        return visualID;
    }

    public static String getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        return "Package_UseCaseDiagram";
    }

    public static String getNodeVisualID(View containerView, EObject domainElement) {
        block69: {
            String containerVisualID;
            if (domainElement == null) {
                return "";
            }
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"UseCase".equals(containerModelID)) {
                return "";
            }
            if ("UseCase".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_UseCaseDiagram";
            } else {
                return "";
            }
            if (containerVisualID == null) break block69;
            switch (containerVisualID) {
                case "Package_UseCaseDiagram": {
                    if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                        return "Actor_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                        return "Actor_ClassifierShape";
                    }
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_ClassifierShape";
                    }
                    if (UMLPackage.eINSTANCE.getClassifier().isSuperTypeOf(domainElement.eClass())) {
                        return "Classifier_SubjectShape";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getNamedElement().isSuperTypeOf(domainElement.eClass())) {
                        return "NamedElement_DefaultShape";
                    }
                    if (!NotationPackage.eINSTANCE.getDiagram().isSuperTypeOf(domainElement.eClass())) break;
                    return "Diagram_ShortcutShape";
                }
                case "UseCase_ExtensionPointCompartment": {
                    if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                    return "ExtensionPoint_ExtensionPointLabel";
                }
                case "UseCase_ClassifierExtensionPointCompartment": {
                    if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                    return "ExtensionPoint_ClassifierExtensionPointLabel";
                }
                case "Classifier_UseCaseCompartment": {
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_Shape_CCN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                    return "Constraint_Shape_CCN";
                }
                case "UseCase_ExtensionPointCompartment_CCN": {
                    if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                    return "ExtensionPoint_ExtensionPointLabel";
                }
                case "Component_PackagedElementCompartment_CCN": {
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_Shape_CCN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_Shape_CCN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CCN";
                    }
                    if (!UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                    return "Actor_Shape_CCN";
                }
                case "UseCase_ExtensionPointCompartment_CN": {
                    if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                    return "ExtensionPoint_ExtensionPointLabel";
                }
                case "Component_PackagedElementCompartment_CN": {
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_Shape_CCN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_Shape_CCN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CCN";
                    }
                    if (!UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                    return "Actor_Shape_CCN";
                }
                case "Package_PackagedElementCompartment_CN": {
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                        return "Actor_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                    return "Comment_Shape_CN";
                }
                case "Package_PackagedElementCompartment": {
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                        return "Actor_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                        return "UseCase_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                    return "Comment_Shape_CN";
                }
            }
        }
        return "";
    }

    public static boolean canCreateNode(View containerView, String nodeVisualID) {
        block191: {
            String containerVisualID;
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"UseCase".equals(containerModelID)) {
                return false;
            }
            if ("UseCase".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_UseCaseDiagram";
            } else {
                return false;
            }
            if (containerVisualID == null) break block191;
            switch (containerVisualID) {
                case "Package_UseCaseDiagram": {
                    if ("Actor_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_ClassifierShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_ClassifierShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Classifier_SubjectShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("NamedElement_DefaultShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Diagram_ShortcutShape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Actor_Shape": {
                    if ("Actor_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_StereotypeLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_QualifiedNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Actor_FloatingNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Actor_ClassifierShape": {
                    if (!"Actor_ClassifierNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_Shape": {
                    if ("UseCase_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_FloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"UseCase_ExtensionPointCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_ClassifierShape": {
                    if ("UseCase_ClassifierNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"UseCase_ClassifierExtensionPointCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Classifier_SubjectShape": {
                    if ("Classifier_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Classifier_FloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Classifier_UseCaseCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_Shape": {
                    if ("Package_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Package_PackagedElementCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape": {
                    if ("Constraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape": {
                    if (!"Comment_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "NamedElement_DefaultShape": {
                    if (!"NamedElement_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Diagram_ShortcutShape": {
                    if (!"Diagram_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_Shape_CCN": {
                    if ("UseCase_NameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_FloatingNameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"UseCase_ExtensionPointCompartment_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_Shape_CCN": {
                    if ("Component_NameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Component_PackagedElementCompartment_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape_CN": {
                    if (!"Comment_BodyLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape_CCN": {
                    if ("Constraint_NameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Actor_Shape_CCN": {
                    if ("Actor_NameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_StereotypeLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_QualifiedNameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Actor_FloatingNameLabel_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape_CN": {
                    if ("Constraint_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Actor_Shape_CN": {
                    if ("Actor_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_StereotypeLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_QualifiedNameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Actor_FloatingNameLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_Shape_CN": {
                    if ("UseCase_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_FloatingNameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"UseCase_ExtensionPointCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_Shape_CN": {
                    if ("Component_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_FloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Component_PackagedElementCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_Shape_CN": {
                    if ("Package_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Package_PackagedElementCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_ExtensionPointCompartment": {
                    if (!"ExtensionPoint_ExtensionPointLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_ClassifierExtensionPointCompartment": {
                    if (!"ExtensionPoint_ClassifierExtensionPointLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Classifier_UseCaseCompartment": {
                    if ("UseCase_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_Shape_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_ExtensionPointCompartment_CCN": {
                    if (!"ExtensionPoint_ExtensionPointLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_PackagedElementCompartment_CCN": {
                    if ("UseCase_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Actor_Shape_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "UseCase_ExtensionPointCompartment_CN": {
                    if (!"ExtensionPoint_ExtensionPointLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_PackagedElementCompartment_CN": {
                    if ("UseCase_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Actor_Shape_CCN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_PackagedElementCompartment_CN": {
                    if ("Constraint_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Comment_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_PackagedElementCompartment": {
                    if ("Constraint_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Actor_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("UseCase_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Comment_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Include_Edge": {
                    if ("Include_KeywordLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Include_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Extend_Edge": {
                    if ("Extend_KeywordLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Extend_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Generalization_Edge": {
                    if (!"Generalization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Association_Edge": {
                    if ("Association_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Association_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Dependency_Edge": {
                    if ("Dependency_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Dependency_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Abstraction_Edge": {
                    if ("Abstraction_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Abstraction_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Usage_Edge": {
                    if ("Usage_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Usage_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Realization_Edge": {
                    if ("Realization_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Realization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "PackageMerge_Edge": {
                    if (!"PackageMerge_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "PackageImport_Edge": {
                    if (!"PackageImport_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        if (UMLPackage.eINSTANCE.getInclude().isSuperTypeOf(domainElement.eClass())) {
            return "Include_Edge";
        }
        if (UMLPackage.eINSTANCE.getExtend().isSuperTypeOf(domainElement.eClass())) {
            return "Extend_Edge";
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return "Generalization_Edge";
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isAssociation_Edge((Association)domainElement)) {
            return "Association_Edge";
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_Edge((Dependency)domainElement)) {
            return "Dependency_Edge";
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isAbstraction_Edge((Abstraction)domainElement)) {
            return "Abstraction_Edge";
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isUsage_Edge((Usage)domainElement)) {
            return "Usage_Edge";
        }
        if (UMLPackage.eINSTANCE.getRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isRealization_Edge((Realization)domainElement)) {
            return "Realization_Edge";
        }
        if (UMLPackage.eINSTANCE.getPackageMerge().isSuperTypeOf(domainElement.eClass())) {
            return "PackageMerge_Edge";
        }
        if (UMLPackage.eINSTANCE.getPackageImport().isSuperTypeOf(domainElement.eClass())) {
            return "PackageImport_Edge";
        }
        return "";
    }

    private static boolean isAssociation_Edge(Association domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getAssociation(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_Edge(Dependency domainElement) {
        Object result = UMLOCLFactory.getExpression(6, (EClassifier)UMLPackage.eINSTANCE.getDependency(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isAbstraction_Edge(Abstraction domainElement) {
        Object result = UMLOCLFactory.getExpression(8, (EClassifier)UMLPackage.eINSTANCE.getAbstraction(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isUsage_Edge(Usage domainElement) {
        Object result = UMLOCLFactory.getExpression(9, (EClassifier)UMLPackage.eINSTANCE.getUsage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isRealization_Edge(Realization domainElement) {
        Object result = UMLOCLFactory.getExpression(10, (EClassifier)UMLPackage.eINSTANCE.getRealization(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
        if (candidate == null) {
            return false;
        }
        String basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return candidate.equals(basic);
    }

    public static boolean isCompartmentVisualID(String visualID) {
        block23: {
            if (visualID == null) break block23;
            switch (visualID) {
                case "Package_PackagedElementCompartment": 
                case "UseCase_ClassifierExtensionPointCompartment": 
                case "Classifier_UseCaseCompartment": 
                case "UseCase_ExtensionPointCompartment_CN": 
                case "UseCase_ExtensionPointCompartment": 
                case "Component_PackagedElementCompartment_CCN": 
                case "Package_PackagedElementCompartment_CN": 
                case "UseCase_ExtensionPointCompartment_CCN": 
                case "Component_PackagedElementCompartment_CN": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(String visualID) {
        block34: {
            if (visualID == null) break block34;
            switch (visualID) {
                case "Package_UseCaseDiagram": {
                    return false;
                }
                case "Constraint_Shape": 
                case "Actor_Shape_CCN": 
                case "Constraint_Shape_CCN": 
                case "Actor_Shape": 
                case "NamedElement_DefaultShape": 
                case "Actor_ClassifierShape": 
                case "Comment_Shape": 
                case "Diagram_ShortcutShape": 
                case "ExtensionPoint_ClassifierExtensionPointLabel": 
                case "ExtensionPoint_ExtensionPointLabel": 
                case "Actor_Shape_CN": 
                case "Comment_Shape_CN": 
                case "Constraint_Shape_CN": {
                    return true;
                }
            }
        }
        return false;
    }
}

