/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.registries;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IAdviceBindingDescriptor;
import org.eclipse.papyrus.infra.types.AdviceConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.IConfiguredEditHelperAdviceDescriptor;
import org.eclipse.papyrus.infra.types.core.factories.IEditHelperAdviceFactory;
import org.eclipse.papyrus.infra.types.core.factories.impl.DefaultAdviceBindingFactory;
import org.eclipse.papyrus.infra.types.core.factories.impl.DefaultEditHelperAdviceFactory;

public class AdviceConfigurationTypeRegistry {
    private static volatile AdviceConfigurationTypeRegistry registry;
    protected Map<String, IEditHelperAdviceFactory<? extends AdviceConfiguration>> adviceConfigurationTypeToFactory = null;

    private AdviceConfigurationTypeRegistry() {
    }

    public static synchronized AdviceConfigurationTypeRegistry getInstance() {
        if (registry == null) {
            registry = new AdviceConfigurationTypeRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.adviceConfigurationTypeToFactory = new HashMap<String, IEditHelperAdviceFactory<? extends AdviceConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.adviceConfigurationKind");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationClass = configurationElement.getAttribute("configurationClass");
            try {
                Object factoryClass = configurationElement.createExecutableExtension("factoryClass");
                if (factoryClass instanceof IEditHelperAdviceFactory) {
                    this.adviceConfigurationTypeToFactory.put(configurationClass, (IEditHelperAdviceFactory)factoryClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
        this.adviceConfigurationTypeToFactory.put(ElementTypesConfigurationsPackage.eINSTANCE.getEditHelperAdviceConfiguration().getInstanceTypeName(), new DefaultEditHelperAdviceFactory());
        this.adviceConfigurationTypeToFactory.put(ElementTypesConfigurationsPackage.eINSTANCE.getAdviceBindingConfiguration().getInstanceTypeName(), new DefaultAdviceBindingFactory());
        this.adviceConfigurationTypeToFactory.put(ElementTypesConfigurationsPackage.eINSTANCE.getExternallyRegisteredAdvice().getInstanceTypeName(), new DefaultAdviceBindingFactory());
    }

    public <T extends AdviceConfiguration> IEditHelperAdviceFactory<T> getFactory(AdviceConfiguration adviceConfiguration) {
        String adviceConfigurationType = adviceConfiguration.eClass().getInstanceTypeName();
        IEditHelperAdviceFactory<? extends AdviceConfiguration> factory = this.adviceConfigurationTypeToFactory.get(adviceConfigurationType);
        return factory;
    }

    public <T extends AdviceConfiguration> IAdviceBindingDescriptor getEditHelperAdviceDecriptor(T adviceConfiguration) {
        IAdviceBindingDescriptor result = null;
        if (adviceConfiguration != null) {
            IEditHelperAdviceFactory<T> factory;
            AdviceDescriptorAdapter adapter = AdviceDescriptorAdapter.get(adviceConfiguration);
            if (adapter == null && (factory = this.getFactory(adviceConfiguration)) != null) {
                IConfiguredEditHelperAdviceDescriptor<T> editHelperAdvice = factory.createEditHelperAdviceDescriptor(adviceConfiguration);
                editHelperAdvice.init(adviceConfiguration);
                adapter = new AdviceDescriptorAdapter(editHelperAdvice);
                adviceConfiguration.eAdapters().add((Object)adapter);
            }
            if (adapter != null) {
                result = adapter.getAdviceDescriptor();
            }
        }
        return result;
    }

    private static class AdviceDescriptorAdapter
    extends AdapterImpl {
        private final IAdviceBindingDescriptor adviceDescriptor;

        AdviceDescriptorAdapter(IAdviceBindingDescriptor adviceDescriptor) {
            this.adviceDescriptor = adviceDescriptor;
        }

        public boolean isAdapterForType(Object type) {
            return type == IAdviceBindingDescriptor.class;
        }

        public IAdviceBindingDescriptor getAdviceDescriptor() {
            return this.adviceDescriptor;
        }

        static AdviceDescriptorAdapter get(AdviceConfiguration configuration) {
            return (AdviceDescriptorAdapter)EcoreUtil.getExistingAdapter((Notifier)configuration, IAdviceBindingDescriptor.class);
        }
    }
}

