/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.ui.internal.preferences.YesNo;

public class EditorPreferences {
    public static final String PREF_CONVERT_SHARED_LAYOUT = "convertSharedLayout";
    private static final String PREF_DIRTY_POLICY = "dirtyPolicy";
    private static final EditorPreferences INSTANCE = new EditorPreferences();
    private final IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    private EditorPreferences() {
    }

    public static EditorPreferences getInstance() {
        return INSTANCE;
    }

    public YesNo getConvertSharedPageLayoutToPrivate() {
        return YesNo.valueOf(this.store.getString(PREF_CONVERT_SHARED_LAYOUT));
    }

    public void setConvertSharedPageLayoutToPrivate(YesNo convert) {
        if (convert == null) {
            convert = YesNo.PROMPT;
        }
        this.store.setValue(PREF_CONVERT_SHARED_LAYOUT, convert.name());
    }

    public IReloadableEditor.DirtyPolicy getDirtyPolicy() {
        IReloadableEditor.DirtyPolicy result = IReloadableEditor.DirtyPolicy.valueOf(this.store.getString(PREF_DIRTY_POLICY));
        if (result == null) {
            result = IReloadableEditor.DirtyPolicy.PROMPT_TO_SAVE;
        }
        return result;
    }

    public void setDirtyPolicy(IReloadableEditor.DirtyPolicy dirtyPolicy) {
        this.store.setValue(PREF_DIRTY_POLICY, dirtyPolicy.toString());
    }

    public static class Initializer
    extends AbstractPreferenceInitializer {
        public void initializeDefaultPreferences() {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.setDefault(EditorPreferences.PREF_CONVERT_SHARED_LAYOUT, YesNo.PROMPT.name());
            store.setDefault(EditorPreferences.PREF_DIRTY_POLICY, IReloadableEditor.DirtyPolicy.PROMPT_TO_SAVE.toString());
        }
    }
}

