/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.util.List;
import java.util.Map;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

public class AspectCreationEntry
extends CombinedTemplateCreationEntry
implements Cloneable {
    protected CombinedTemplateCreationEntry entry;
    protected Tool tool;
    protected Map<?, ?> properties;
    private String iconPath;
    private ImageDescriptor descriptor;
    private static final String URL_IMAGE_DESCRIPTOR_BEGIN = "URLImageDescriptor(";

    public AspectCreationEntry(String name, String desc, String id, ImageDescriptor descriptor, CombinedTemplateCreationEntry entry, Map<?, ?> properties) {
        super(name, desc, null, descriptor, descriptor);
        this.setId(id);
        this.computeIconPathFromImageDescriptor(descriptor);
        this.entry = entry;
        this.properties = properties;
        this.descriptor = descriptor;
    }

    protected void computeIconPathFromImageDescriptor(ImageDescriptor desc) {
        String value = desc.toString();
        if (value.startsWith(URL_IMAGE_DESCRIPTOR_BEGIN)) {
            String url = value.substring(URL_IMAGE_DESCRIPTOR_BEGIN.length(), value.length() - 1);
            this.setIconPath(url);
        }
    }

    public AspectCreationEntry(String name, String desc, String id, String iconPath, CombinedTemplateCreationEntry entry, Map<?, ?> properties) {
        super(name, desc, null, Activator.getImageDescriptor(iconPath), Activator.getImageDescriptor(iconPath));
        this.setId(id);
        this.setIconPath(iconPath);
        this.entry = entry;
        this.properties = properties;
    }

    public Tool createTool() {
        if (this.tool == null) {
            if (this.entry instanceof AspectCreationEntry) {
                AspectCreationEntry clonedEntry = ((AspectCreationEntry)this.entry).clone();
                this.tool = clonedEntry.createTool();
            } else {
                this.tool = this.entry.createTool();
            }
            this.tool.setProperties(this.properties);
        }
        return this.tool;
    }

    public Object getAspectProperties(String key) {
        return this.properties.get(key);
    }

    public CombinedTemplateCreationEntry getReferencedEntry() {
        return this.entry;
    }

    public List<String> getStereotypeList() {
        return (List)this.properties.get("StereotypesToApply");
    }

    public void setIconPath(String path) {
        this.iconPath = path;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public AspectCreationEntry clone() {
        if (this.getIconPath() != null) {
            return new AspectCreationEntry(this.getLabel(), this.getDescription(), this.entry.getId() + "_" + System.currentTimeMillis(), this.getIconPath(), this.entry, this.properties);
        }
        return new AspectCreationEntry(this.getLabel(), this.getDescription(), this.entry.getId() + "_" + System.currentTimeMillis(), this.descriptor, this.entry, this.properties);
    }
}

