/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.matchers.stereotype.operations;

import java.util.Collection;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.types.constraints.AdviceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceConfiguration;
import org.eclipse.papyrus.infra.emf.types.constraints.operations.AdviceConstraintOperations;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.RequiredStereotypeConstraintConfiguration;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.papyrus.uml.types.core.requests.UnapplyStereotypeRequest;
import org.eclipse.uml2.uml.Stereotype;

public class RequiredStereotypeConstraintConfigurationOperations
extends AdviceConstraintOperations {
    protected RequiredStereotypeConstraintConfigurationOperations() {
    }

    public static boolean approveRequest(RequiredStereotypeConstraintConfiguration requiredStereotypeConstraintConfiguration, IEditCommandRequest request) {
        Stereotype stereotype;
        Stereotype stereotype2 = stereotype = request instanceof UnapplyStereotypeRequest ? ((UnapplyStereotypeRequest)request).getStereotype() : null;
        if (stereotype == null) {
            return true;
        }
        Collection<String> requiredStereotypes = RequiredStereotypeConstraintConfigurationOperations.getRequiredStereotypes(requiredStereotypeConstraintConfiguration);
        return !requiredStereotypes.contains(stereotype.getQualifiedName());
    }

    private static Collection<String> getRequiredStereotypes(RequiredStereotypeConstraintConfiguration requiredStereotypeConstraintConfiguration) {
        List<String> result = List.of();
        SpecializationTypeConfiguration typeConfig = RequiredStereotypeConstraintConfigurationOperations.getTypeConfiguration(requiredStereotypeConstraintConfiguration);
        if (typeConfig != null && typeConfig.getMatcherConfiguration() instanceof StereotypeApplicationMatcherConfiguration) {
            StereotypeApplicationMatcherConfiguration matcher = (StereotypeApplicationMatcherConfiguration)typeConfig.getMatcherConfiguration();
            result = matcher.getStereotypesQualifiedNames();
        }
        return result;
    }

    private static SpecializationTypeConfiguration getTypeConfiguration(AdviceConstraint constraint) {
        ConstraintAdviceConfiguration advice = constraint.getAdvice();
        return advice.getTarget() instanceof SpecializationTypeConfiguration ? (SpecializationTypeConfiguration)advice.getTarget() : null;
    }
}

