/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Nicolas FAUVERGUE (ALL4TEC) nicolas.fauvergue@all4tec.net - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.uml.nattable.stereotype.display.utils;

/**
 * The constants uses for the stereotype display tree table.
 */
public class StereotypeDisplayTreeTableConstants {

	public static final String NAME_DEPTH = "nameDepth"; //$NON-NLS-1$
	public static final String IS_DISPLAYED = "isDisplayed"; //$NON-NLS-1$
	public static final String IN_COMMENT = "isDisplayedInComment"; //$NON-NLS-1$
	public static final String IN_COMPARTMENT = "isDisplayedInCompartment"; //$NON-NLS-1$
	public static final String IN_BRACE = "isDisplayedInBraces"; //$NON-NLS-1$
	public static final String SELECTION = "selection"; //$NON-NLS-1$

	public static final String PREFIX = "stereotype_display_properties:/"; //$NON-NLS-1$
	public static final String GMF_CUSTOM_PREFIX = "gmf_custom:/"; //$NON-NLS-1$
	
	public static final String NAME_DEPTH_LABEL = "Name Depth"; //$NON-NLS-1$
	public static final String IS_DISPLAYED_LABEL = "Visible"; //$NON-NLS-1$
	public static final String IN_COMMENT_LABEL = "In Comment"; //$NON-NLS-1$
	public static final String IN_COMPARTMENT_LABEL = "In Compartment"; //$NON-NLS-1$
	public static final String IN_BRACE_LABEL = "in Brace"; //$NON-NLS-1$

}
