/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.checker.SemanticAndGraphicalCreationChecker;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.GraphicalOwnerUtils;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.uml2.uml.Package;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractCreateNodeTests
extends AbstractSiriusDiagramTests {
    protected Package root;
    protected List<?> previousChildren;

    @Before
    public void setUp() {
        this.root = this.fixture.getModel();
    }

    protected EObject getSemanticOwner() {
        return null;
    }

    protected EObject getTopGraphicalContainer() {
        return null;
    }

    protected EObject getSubNodeOfGraphicalContainer(String mappingID) {
        EObject container = this.getTopGraphicalContainer();
        if (container instanceof DMappingBased && ((DMappingBased)container).getMapping().getName().equals(mappingID)) {
            return container;
        }
        if (container instanceof DNodeContainer) {
            for (DDiagramElement diagramElement : ((DNodeContainer)container).getOwnedDiagramElements()) {
                if (!mappingID.equals(diagramElement.getMapping().getName())) continue;
                return diagramElement;
            }
        }
        if (container instanceof DNode) {
            for (DDiagramElement diagramElement : ((DNode)container).getOwnedBorderedNodes()) {
                if (!mappingID.equals(diagramElement.getMapping().getName())) continue;
                return diagramElement;
            }
        }
        return null;
    }

    protected DRepresentationElement createNode(String creationToolId, SemanticAndGraphicalCreationChecker checker, EObject graphicalContainer) {
        this.checkSiriusDiagramSynchronization(this.isSynchronization());
        this.beforeCreation(graphicalContainer);
        boolean result = this.applyCreationTool(creationToolId, (DDiagram)this.getDDiagram(), graphicalContainer);
        Assert.assertTrue((String)"The creation of element failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        DRepresentationElement createdView = this.retrieveCreatedView(graphicalContainer);
        checker.validateRepresentationElement(createdView);
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        checker.validateAfterUndo();
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        checker.validateAfterRedo();
        return createdView;
    }

    protected void beforeCreation(EObject viewContainer) {
        this.previousChildren = List.copyOf(GraphicalOwnerUtils.getChildren(viewContainer));
    }

    protected DRepresentationElement retrieveCreatedView(EObject viewContainer) {
        ArrayList<DDiagramElement> children = new ArrayList<DDiagramElement>(GraphicalOwnerUtils.getChildren(viewContainer));
        children.removeAll(this.previousChildren);
        return this.retrieveFromViews(children);
    }

    protected DRepresentationElement retrieveFromViews(List<DDiagramElement> children) {
        Assert.assertEquals((long)1L, (long)children.size());
        return (DRepresentationElement)children.get(0);
    }

    protected boolean applyCreationTool(String creationToolId, DDiagram diagram, EObject graphicalContainer) {
        return this.fixture.applyContainerCreationTool(creationToolId, diagram, graphicalContainer);
    }

    @After
    public void tearDown() {
        this.root = null;
    }
}

