/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractMultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.IMultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractMultiReference<T extends AbstractMultipleValueEditor<? extends ReferenceSelector>>
extends AbstractPropertyEditor {
    protected T editor;
    protected ReferenceValueFactory factory;

    public AbstractMultiReference(Composite parent, int style) {
        this.editor = this.createMultipleReferenceEditor(parent, style);
        super.setEditor((AbstractListEditor)this.editor);
    }

    protected abstract T createMultipleReferenceEditor(Composite var1, int var2);

    @Override
    protected void doBinding() {
        IStaticContentProvider contentProvider = this.input.getContentProvider(this.propertyPath);
        ILabelProvider labelProvider = this.input.getLabelProvider(this.propertyPath);
        if (this.getInputObservableList() instanceof ICommitListener) {
            this.editor.addCommitListener((ICommitListener)this.getInputObservableList());
        }
        ((IMultipleReferenceEditor)this.editor).setProviders(contentProvider, labelProvider);
        this.editor.setOrdered(this.input.isOrdered(this.propertyPath));
        this.editor.setUnique(this.input.isUnique(this.propertyPath));
        if (this.factory == null) {
            this.editor.setFactory(this.input.getValueFactory(this.propertyPath));
        } else {
            this.editor.setFactory(this.factory);
        }
        this.editor.setDirectCreation(this.input.getDirectCreation(this.propertyPath));
        super.doBinding();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.factory = factory;
        this.editor.setFactory(factory);
    }

    public ReferenceValueFactory getFactory() {
        return this.factory;
    }
}

