/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor.perspectiveconfiguration;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.editor.perspectiveconfiguration.Activator;
import org.eclipse.papyrus.editor.perspectiveconfiguration.Configuration;

public class ConfigurationService {
    public static String PERSPECTIVE_CONFIGURATION_EXTENSION_POINT_ID = "org.eclipse.papyrus.editor.perspectiveconfiguration";
    public static String PERPSECTIVE_ID = "perspectiveID";
    public static String ACTION_SET = "actionSet";
    public static String ACTION_SET_ID = "actionSetID";
    public static String MENU = "menu";
    public static String MENU_ID = "menuID";
    public static String TOOLBAR = "toolbar";
    public static String TOOLBAR_ID = "toolbarID";
    public static String PREFERENCEPAGE = "preferencePage";
    public static String PREFERENCEPAGEID = "preferencepageID";
    public static String CATEGORY = "category";
    public static String CATEGORYID = "categoryID";
    public static String COMMAND = "command";
    public static String COMMANDID = "commandID";
    protected HashMap<String, Configuration> configurationMap = new HashMap();

    public ConfigurationService() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PERSPECTIVE_CONFIGURATION_EXTENSION_POINT_ID);
        int i = 0;
        while (i < configElements.length) {
            this.constructAConfiguation(configElements[i]);
            ++i;
        }
    }

    protected void constructAConfiguation(IConfigurationElement iConfigurationElement) {
        try {
            String configName = iConfigurationElement.getAttribute(PERPSECTIVE_ID);
            if (!this.configurationMap.containsKey(configName) || this.configurationMap.get(configName) == null) {
                this.configurationMap.put(configName, new Configuration(configName));
            }
            Configuration configuration = this.configurationMap.get(configName);
            IConfigurationElement[] element = iConfigurationElement.getChildren(ACTION_SET);
            int i = 0;
            while (i < element.length) {
                configuration.addActionSet(element[i].getAttribute(ACTION_SET_ID));
                ++i;
            }
            element = iConfigurationElement.getChildren(MENU);
            i = 0;
            while (i < element.length) {
                configuration.addMenu(element[i].getAttribute(MENU_ID));
                ++i;
            }
            element = iConfigurationElement.getChildren(TOOLBAR);
            i = 0;
            while (i < element.length) {
                configuration.addtoolBar(element[i].getAttribute(TOOLBAR_ID));
                ++i;
            }
            element = iConfigurationElement.getChildren(PREFERENCEPAGE);
            i = 0;
            while (i < element.length) {
                configuration.addPreference(element[i].getAttribute(PREFERENCEPAGEID));
                ++i;
            }
            element = iConfigurationElement.getChildren(CATEGORY);
            i = 0;
            while (i < element.length) {
                configuration.addCategory(element[i].getAttribute(CATEGORYID));
                ++i;
            }
            element = iConfigurationElement.getChildren(COMMAND);
            i = 0;
            while (i < element.length) {
                configuration.addCommandID(element[i].getAttribute(COMMANDID));
                ++i;
            }
        }
        catch (Exception e) {
            Activator.log.error("- " + String.valueOf(iConfigurationElement) + " can not be loaded ", (Throwable)e);
        }
    }

    protected Set<String> getPerspectiveList() {
        return this.configurationMap.keySet();
    }

    protected Configuration getConfiguration(String perspectiveID) {
        return this.configurationMap.get(perspectiveID);
    }
}

