/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorServices
extends AbstractDiagramServices {
    public boolean displayConnector(Connector connector, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DSemanticDecorator ancestorContainer;
        ConnectorEnd taregtEnd;
        Property partWithPortTarget;
        boolean shouldDiplayConnector = true;
        ConnectorEnd sourceEnd = (ConnectorEnd)connector.getEnds().get(0);
        Property partWithPortSource = sourceEnd.getPartWithPort();
        if (partWithPortSource != null) {
            EObject target = sourceView.getTarget();
            if (target instanceof Port) {
                EObject parentGraphicalSourceProperty = ((DSemanticDecorator)sourceView.eContainer()).getTarget();
                shouldDiplayConnector = shouldDiplayConnector && parentGraphicalSourceProperty.equals(partWithPortSource);
            } else {
                shouldDiplayConnector = false;
            }
        }
        if ((partWithPortTarget = (taregtEnd = (ConnectorEnd)connector.getEnds().get(1)).getPartWithPort()) != null) {
            EObject target = targetView.getTarget();
            if (target instanceof Port) {
                EObject parentGraphicalTargetProperty = ((DSemanticDecorator)targetView.eContainer()).getTarget();
                shouldDiplayConnector = shouldDiplayConnector && parentGraphicalTargetProperty.equals(partWithPortTarget);
            } else {
                shouldDiplayConnector = false;
            }
        }
        if ((ancestorContainer = this.getConnectorAncestorContainer(sourceView, targetView)) == null || ancestorContainer.getTarget() != connector.eContainer()) {
            shouldDiplayConnector = false;
        }
        return shouldDiplayConnector;
    }

    private DSemanticDecorator getConnectorAncestorContainer(DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        List<DSemanticDecorator> sourceStructureClassifiers = this.getStructuredClassifiersAncestors(sourceView);
        List<DSemanticDecorator> targetStructureClassifiers = this.getStructuredClassifiersAncestors(targetView);
        for (DSemanticDecorator dsemanticDecorator : targetStructureClassifiers) {
            if (!sourceStructureClassifiers.contains(dsemanticDecorator)) continue;
            return dsemanticDecorator;
        }
        return null;
    }

    private List<DSemanticDecorator> getStructuredClassifiersAncestors(DSemanticDecorator object) {
        DSemanticDecorator current = object;
        ArrayList<DSemanticDecorator> results = new ArrayList<DSemanticDecorator>();
        while (current != null) {
            EObject target;
            if (current instanceof DSemanticDecorator && (target = current.getTarget()) instanceof StructuredClassifier) {
                results.add(current);
            }
            current = current.eContainer();
        }
        return results;
    }
}

