/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.core.sashwindows.simpleeditor.editors;

import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.SimpleSashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.multipage.editor.MultiPageEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;

public class SimpleTextMultiPageEditor
extends MultiPageEditor
implements IResourceChangeListener {
    private TextEditor editor;
    private Font font;
    private StyledText text;

    public SimpleTextMultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected ISashWindowsContentProvider createPageProvider() {
        SimpleSashWindowsContentProvider pageProvider = new SimpleSashWindowsContentProvider();
        pageProvider.addPage((IPageModel)new Page0());
        pageProvider.addPage((IPageModel)new Page1());
        pageProvider.addPage((IPageModel)new Page2());
        pageProvider.addPage((IPageModel)new Page0());
        return pageProvider;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 2) {
            this.sortWords();
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = SimpleTextMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)SimpleTextMultiPageEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(SimpleTextMultiPageEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.getSite().getShell());
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    void sortWords() {
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        StringTokenizer tokenizer = new StringTokenizer(editorText, " \t\n\r\f!@#$%^&*()-_=+`~[]{};:'\",.<>/?|\\");
        ArrayList<String> editorWords = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            editorWords.add(tokenizer.nextToken());
        }
        Collections.sort(editorWords, Collator.getInstance());
        StringWriter displayText = new StringWriter();
        int i = 0;
        while (i < editorWords.size()) {
            displayText.write((String)editorWords.get(i));
            displayText.write(System.getProperty("line.separator"));
            ++i;
        }
        this.text.setText(displayText.toString());
    }

    public class Page0
    implements IEditorModel {
        public IEditorPart createIEditorPart() throws PartInitException {
            SimpleTextMultiPageEditor.this.editor = new TextEditor();
            return SimpleTextMultiPageEditor.this.editor;
        }

        public Image getTabIcon() {
            return null;
        }

        public String getTabTitle() {
            return SimpleTextMultiPageEditor.this.editor.getTitle();
        }

        public Object getRawModel() {
            return this;
        }

        public EditorActionBarContributor getActionBarContributor() {
            return null;
        }

        public void dispose() {
        }
    }

    public class Page1
    implements IComponentModel {
        public Composite createPartControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            layout.numColumns = 2;
            Button fontButton = new Button(composite, 0);
            GridData gd = new GridData(1);
            gd.horizontalSpan = 2;
            fontButton.setLayoutData((Object)gd);
            fontButton.setText("Change Font...");
            fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SimpleTextMultiPageEditor.this.setFont();
                }
            });
            return composite;
        }

        public Image getTabIcon() {
            return null;
        }

        public String getTabTitle() {
            return "Properties";
        }

        public Object getRawModel() {
            return this;
        }

        public void dispose() {
        }
    }

    public class Page2
    implements IComponentModel {
        public Composite createPartControl(Composite parent) {
            Composite composite = new Composite(SimpleTextMultiPageEditor.this.getContainer(), 0);
            FillLayout layout = new FillLayout();
            composite.setLayout((Layout)layout);
            SimpleTextMultiPageEditor.this.text = new StyledText(composite, 768);
            SimpleTextMultiPageEditor.this.text.setEditable(false);
            return composite;
        }

        public Image getTabIcon() {
            return null;
        }

        public String getTabTitle() {
            return "Preview";
        }

        public Object getRawModel() {
            return this;
        }

        public void dispose() {
        }
    }
}

