/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.codegen;

import org.eclipse.xtend2.lib.StringConcatenation;

public class TextMerger {
    private final String lineDelimiter;

    public TextMerger(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String mergeJava(String oldText, String newText) {
        return this.toLocalLineSeparator(newText);
    }

    protected final String toLocalLineSeparator(String newText) {
        StringConcatenation lineConcatener = new StringConcatenation(this.lineDelimiter);
        lineConcatener.append(newText);
        return lineConcatener.toString();
    }

    public String mergeProperties(String oldText, String newText) {
        return this.toLocalLineSeparator(newText);
    }

    public String mergeXML(String oldText, String newText) {
        return this.toLocalLineSeparator(newText);
    }

    public String mergePluginXML(String oldText, String newText) {
        return this.toLocalLineSeparator(newText);
    }

    public String mergeManifestMF(String oldText, String newText) {
        return this.toLocalLineSeparator(newText);
    }

    public String process(String fileName, String oldText, String newText) {
        if (fileName == null) {
            return this.toLocalLineSeparator(newText);
        }
        if (fileName.endsWith(".java")) {
            return this.mergeJava(oldText, newText);
        }
        if (fileName.endsWith(".xml")) {
            if (fileName.equals("plugin.xml")) {
                return this.mergePluginXML(oldText, newText);
            }
            return this.mergeXML(oldText, newText);
        }
        if (fileName.endsWith(".properties")) {
            return this.mergeProperties(oldText, newText);
        }
        if (fileName.equals("MANIFEST.MF")) {
            return this.mergeManifestMF(oldText, newText);
        }
        return this.toLocalLineSeparator(newText);
    }
}

