/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusWorkbenchMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.MissingDependenciesMarkerResolutionGenerator;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.BundleVersionHelper;

public class MissingDependenciesMarkerResolution
extends AbstractPapyrusWorkbenchMarkerResolution {
    public MissingDependenciesMarkerResolution() {
        super(0xFF1001);
    }

    public String getLabel() {
        return Messages.MissingDependenciesMarkerResolution_label;
    }

    public void run(IMarker marker) {
        String dependencies = null;
        try {
            dependencies = (String)marker.getAttribute("Missing Dependencies");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (dependencies != null && !dependencies.isEmpty()) {
            String[] result = dependencies.split(",");
            IResource res = marker.getResource();
            IProject project = res.getProject();
            try {
                ManifestEditor editor = new ManifestEditor(project);
                editor.init();
                String[] stringArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    String current = stringArray[n2];
                    BundleVersionHelper versionHelper = new BundleVersionHelper(current);
                    String newVersion = versionHelper.getVersionRangeForManifest();
                    editor.addDependency(current, newVersion);
                    ++n2;
                }
                editor.save();
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public String getDescription() {
        return Messages.MissingDependenciesMarkerResolution_description;
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Stream.of(markers).filter(MissingDependenciesMarkerResolutionGenerator::isMissingDependencyProblem).toArray(IMarker[]::new);
    }
}

