/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.utils;

import java.io.File;
import java.util.StringTokenizer;

public class PathHelper {
    public static final String URL_IDENTIFY_PREFIX = "file:";
    public static final String BACKWARD_SLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String RELATIVE_PATH_SIG = "../";
    public static final String WHITE_SPACE_ASCII = "%20";

    public static String getRelativePath(String source, String target) {
        if (source == null || target == null) {
            return target;
        }
        File sourceFile = new File(source);
        if (!sourceFile.exists()) {
            return target;
        }
        File targetFile = new File((String)target);
        if (!targetFile.exists()) {
            return target;
        }
        source = PathHelper.switchToForwardSlashes(source);
        target = PathHelper.switchToForwardSlashes((String)target);
        int index = ((String)target).indexOf(FORWARD_SLASH);
        String container = null;
        while (index != -1) {
            container = ((String)target).substring(0, index);
            if (!source.startsWith(container + FORWARD_SLASH)) break;
            source = source.substring(index + 1);
            target = ((String)target).substring(index + 1);
            index = ((String)target).indexOf(FORWARD_SLASH);
        }
        index = source.indexOf(FORWARD_SLASH);
        while (index != -1) {
            target = RELATIVE_PATH_SIG + (String)target;
            source = source.substring(index + 1);
            index = source.indexOf(FORWARD_SLASH);
        }
        return target;
    }

    public static String switchToForwardSlashes(String path) {
        path = path.replace(File.separatorChar, FORWARD_SLASH.charAt(0));
        path = path.replace(BACKWARD_SLASH.charAt(0), FORWARD_SLASH.charAt(0));
        return path;
    }

    public static String getAbsolutePath(String source, String relative) {
        int index;
        File file;
        if (((String)source).indexOf(WHITE_SPACE_ASCII) != -1) {
            source = ((String)source).replace(WHITE_SPACE_ASCII, " ");
        }
        if (relative.indexOf(WHITE_SPACE_ASCII) != -1) {
            relative = relative.replace(WHITE_SPACE_ASCII, " ");
        }
        if (((String)source).startsWith(FORWARD_SLASH)) {
            source = ((String)source).substring(1);
        }
        String prefix = null;
        if (((String)source).startsWith(URL_IDENTIFY_PREFIX)) {
            prefix = URL_IDENTIFY_PREFIX;
            source = ((String)source).substring(URL_IDENTIFY_PREFIX.length());
            if (System.getProperty("os.arch").startsWith("Win")) {
                source = ((String)source).substring(1);
            }
        }
        if (!(file = new File((String)source)).exists()) {
            return relative;
        }
        if (file.isFile()) {
            source = file.getParent();
        }
        source = PathHelper.switchToForwardSlashes((String)source);
        if ((relative = PathHelper.switchToForwardSlashes(relative)).startsWith(FORWARD_SLASH)) {
            relative = relative.substring(1);
        }
        if ((index = relative.lastIndexOf(FORWARD_SLASH)) != -1) {
            String container = relative.substring(0, index);
            int i = ((String)source).indexOf(container);
            if (i != -1) {
                source = ((String)source).substring(0, i);
            } else {
                int j = relative.indexOf(RELATIVE_PATH_SIG);
                while (j != -1) {
                    relative = relative.substring(j + RELATIVE_PATH_SIG.length());
                    source = ((String)source).substring(0, ((String)source).lastIndexOf(FORWARD_SLASH));
                    j = relative.indexOf(RELATIVE_PATH_SIG);
                }
            }
        }
        if (System.getProperty("os.arch").startsWith("Win")) {
            source = FORWARD_SLASH + (String)source;
        }
        return (prefix != null ? prefix : "") + (String)source + FORWARD_SLASH + relative;
    }

    public static String convertToRelative(String input, String base) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, FORWARD_SLASH);
        StringTokenizer baseTokenizer = new StringTokenizer(base, FORWARD_SLASH);
        String token1 = "";
        String token2 = "";
        while (inputTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens() && (token1 = baseTokenizer.nextToken()).equals(token2 = inputTokenizer.nextToken())) {
        }
        StringBuilder builder = new StringBuilder();
        while (baseTokenizer.hasMoreTokens()) {
            baseTokenizer.nextToken();
            builder.append(RELATIVE_PATH_SIG);
        }
        builder.append(token2);
        while (inputTokenizer.hasMoreTokens()) {
            builder.append(FORWARD_SLASH + inputTokenizer.nextToken());
        }
        return builder.toString();
    }
}

