/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.papyrus.infra.sync.SyncObject;

public abstract class SyncItem<M, T>
extends SyncObject {
    private final Reference<T> backend;

    public SyncItem(T backend) {
        if (backend == null) {
            throw new NullPointerException("The backend element must not be null");
        }
        this.backend = new WeakReference<T>(backend);
    }

    public final T getBackend() {
        return this.backend.get();
    }

    public abstract M getModel();

    @Override
    public boolean isActive() {
        return this.backend.get() != null;
    }
}

