/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.mouse.action.CellActionMouseEventMatcher;
import org.eclipse.papyrus.infra.nattable.painter.ActionImagePainter;
import org.eclipse.papyrus.infra.nattable.utils.ActionUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractSingleClickActionCellEditorConfiguration
implements ICellAxisConfiguration {
    private final String actionName;
    private final Image image;

    public AbstractSingleClickActionCellEditorConfiguration(String actionName, Image image) {
        this.actionName = actionName;
        this.image = image;
    }

    public String getActionName() {
        return this.actionName;
    }

    @Override
    public boolean handles(Table table, Object axisElement) {
        if (ActionUtils.isAction(axisElement)) {
            return ActionUtils.getActionId((IAxis)axisElement).endsWith(this.actionName);
        }
        return false;
    }

    protected MouseEventMatcher getMouseEventMatcher() {
        return new CellActionMouseEventMatcher(0, "BODY".toString(), 1, this.actionName);
    }

    protected abstract IMouseAction getIMouseAction();

    @Override
    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ActionImagePainter(this.image, this.actionName), DisplayMode.NORMAL, configLabel);
        INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        NatTable natTable = (NatTable)manager.getAdapter(NatTable.class);
        UiBindingRegistry uiBindingRegistry = natTable.getUiBindingRegistry();
        uiBindingRegistry.registerSingleClickBinding((IMouseEventMatcher)this.getMouseEventMatcher(), this.getIMouseAction());
    }
}

