/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotAst;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class DotLabelProvider
extends DefaultEObjectLabelProvider {
    private static final String IMAGE_ATTRIBUTE = "attribute.png";
    private static final String IMAGE_ATTRIBUTES = "attributes.png";
    private static final String IMAGE_EDGE = "edge.png";
    private static final String IMAGE_FILE = "file.png";
    private static final String IMAGE_GRAPH = "graph.png";
    private static final String IMAGE_HTML_TAG = "html_tag.png";
    private static final String IMAGE_HTML_TEXT = "html_text.png";
    private static final String IMAGE_ID = "id.png";
    private static final String IMAGE_NODE = "node.png";
    private static final String IMAGE_RHS = "rhs.png";
    private static final String IMAGE_SUBGRAPH = "subgraph.png";
    @Inject
    private DotGrammarAccess grammarAccess;

    @Inject
    public DotLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String image(DotAst ast) {
        return IMAGE_FILE;
    }

    String image(DotGraph graph) {
        return IMAGE_GRAPH;
    }

    String image(Subgraph graph) {
        return IMAGE_SUBGRAPH;
    }

    String image(NodeStmt node) {
        return IMAGE_NODE;
    }

    String image(EdgeStmtNode edge) {
        return IMAGE_EDGE;
    }

    String image(AttrStmt attr) {
        return IMAGE_ATTRIBUTES;
    }

    String image(Attribute attr) {
        return IMAGE_ATTRIBUTE;
    }

    String image(AttrList attrs) {
        return IMAGE_ATTRIBUTES;
    }

    String image(NodeId attrs) {
        return IMAGE_ID;
    }

    String image(EdgeRhs rhs) {
        return IMAGE_RHS;
    }

    String image(HtmlTag htmlTag) {
        return IMAGE_HTML_TAG;
    }

    String image(HtmlAttr htmlAttr) {
        return IMAGE_ATTRIBUTE;
    }

    String image(HtmlContent htmlContent) {
        return IMAGE_HTML_TEXT;
    }

    Object image(Keyword keyword) {
        DotGrammarAccess.GraphTypeElements graphTypeElements = this.grammarAccess.getGraphTypeAccess();
        DotGrammarAccess.AttributeTypeElements attributeTypeElements = this.grammarAccess.getAttributeTypeAccess();
        DotGrammarAccess.SubgraphElements subgraphElements = this.grammarAccess.getSubgraphAccess();
        DotGrammarAccess.EdgeOpElements edgeOpElements = this.grammarAccess.getEdgeOpAccess();
        if (keyword == graphTypeElements.getGraphGraphKeyword_0_0() || keyword == graphTypeElements.getDigraphDigraphKeyword_1_0()) {
            return IMAGE_GRAPH;
        }
        if (keyword == attributeTypeElements.getGraphGraphKeyword_0_0() || keyword == attributeTypeElements.getNodeNodeKeyword_1_0() || keyword == attributeTypeElements.getEdgeEdgeKeyword_2_0()) {
            return IMAGE_ATTRIBUTES;
        }
        if (keyword == subgraphElements.getSubgraphKeyword_1_0()) {
            return IMAGE_SUBGRAPH;
        }
        if (keyword == edgeOpElements.getDirectedHyphenMinusGreaterThanSignKeyword_0_0() || keyword == edgeOpElements.getUndirectedHyphenMinusHyphenMinusKeyword_1_0()) {
            return IMAGE_EDGE;
        }
        return super.image((Object)keyword);
    }

    Object text(DotAst model) {
        String format = "%s: File";
        return DotEditorUtils.style(format, model.eResource().getURI().lastSegment());
    }

    Object text(DotGraph graph) {
        String format = "%s: Graph";
        ID name = graph.getName();
        return DotEditorUtils.style(format, name != null ? name.toValue() : "<?>");
    }

    Object text(Subgraph graph) {
        String format = "%s: Subgraph";
        ID name = graph.getName();
        return DotEditorUtils.style(format, name != null ? name.toValue() : "<?>");
    }

    Object text(NodeStmt node) {
        return this.text(node.getNode());
    }

    Object text(EdgeStmtNode edge) {
        EList edgeRHS = edge.getEdgeRHS();
        if (edgeRHS != null && edgeRHS.size() > 0) {
            String format = "%s %s [%s %s]: Edges";
            String sourceNode = edge.getNode().getName().toValue();
            String opLiteral = ((EdgeRhs)edge.getEdgeRHS().get(0)).getOp().getLiteral();
            int targetNodeCount = edge.getEdgeRHS().size();
            return DotEditorUtils.style(format, sourceNode, opLiteral, targetNodeCount, targetNodeCount > 1 ? "Nodes" : "Node");
        }
        return DotEditorUtils.style("<?>: Edges", new Object[0]);
    }

    Object text(AttrStmt attr) {
        String format = "%s: Attributes";
        String attrLiteral = attr.getType().getLiteral();
        return DotEditorUtils.style(format, attrLiteral);
    }

    Object text(Attribute attr) {
        String format = "%s = %s: Attribute";
        ID attributeValue = attr.getValue();
        String displayValue = attributeValue.getType() == ID.Type.HTML_STRING ? "<HTML-Label>" : attributeValue.toString();
        return DotEditorUtils.style(format, attr.getName(), displayValue);
    }

    Object text(AttrList attrs) {
        String format = "%s %s: Attributes";
        int attrCount = attrs.getAttributes().size();
        return DotEditorUtils.style(format, attrCount, attrCount > 1 ? "Attributes" : "Attribute");
    }

    Object text(NodeId id) {
        String format = "%s: Node";
        return DotEditorUtils.style(format, id.getName());
    }

    Object text(EdgeRhs rhs) {
        if (rhs instanceof EdgeRhsNode) {
            String format = "%s %s %s";
            String name = rhs.getOp().getName();
            String literal = rhs.getOp().getLiteral();
            Object targetNodeText = this.text(((EdgeRhsNode)rhs).getNode());
            return DotEditorUtils.style(format, name, literal, targetNodeText);
        }
        return super.text((Object)rhs);
    }

    Object text(HtmlTag htmlTag) {
        String format = htmlTag.isSelfClosing() ? "<%s/>: Tag" : "<%s>: Tag";
        return DotEditorUtils.style(format, htmlTag.getName());
    }

    Object text(HtmlAttr htmlAttr) {
        String format = "%s = %s: Attribute";
        return DotEditorUtils.style(format, htmlAttr.getName(), htmlAttr.getValue());
    }

    Object text(HtmlContent htmlContent) {
        String format = "%s: Text";
        String text = htmlContent.getText() == null ? "" : htmlContent.getText().trim();
        return DotEditorUtils.style(format, text);
    }
}

