/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore.importer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ModelImporterApplication;
import org.eclipse.xsd.ecore.importer.XSDImporter;

public class XSDImporterApplication
extends ModelImporterApplication {
    protected Map<String, String> nsURIToPackageName;
    protected Set<String> packages;

    protected ModelImporter createModelImporter() {
        return new XSDImporter();
    }

    protected StringBuffer getUsage() {
        StringBuffer result = new StringBuffer();
        this.appendLine(result, "Usage: { <model.xsd> | <model.wsdl> }+ [ <model.genmodel> [ -reload ] ] <OPTION>");
        this.appendLine(result, "<OPTION>            ::= [ <PROJECT-OPTION> ]  [ <PACKAGE-MAP> ] [ <PACKAGES> ]");
        this.appendLine(result, "                        { <REF-GEN-MODEL> }*");
        this.appendLine(result, "                        [ <TEMPLATE-PATH> ] [ <MODEL-PLUGIN-ID> ] [ <COPYRIGHT> ]");
        this.appendLine(result, "                        [ <SDO> ] [ <QUIET> ]");
        this.appendLine(result, "<PROJECT-OPTION>    ::= <MODEL-PROJECT> [ <EDIT-PROJECT> ] [ <EDITOR-PROJECT> ]");
        this.appendLine(result, "                        [ <TESTS-PROJECT> ]");
        this.appendLine(result, "<MODEL-PROJECT>     ::= -modelProject <model-directory> <fragment-path>");
        this.appendLine(result, "<EDIT-PROJECT>      ::= -editProject <edit-directory> <fragment-path>");
        this.appendLine(result, "<EDITOR-PROJECT>    ::= -editorProject <editor-directory> <fragment-path>");
        this.appendLine(result, "<TESTS-PROJECT>     ::= -testsProject <tests-directory> <fragment-path>");
        this.appendLine(result, "<PACKAGE-MAP>       ::= -packageMap { <nsURI> <qualified-package-name> }+");
        this.appendLine(result, "<PACKAGES>          ::= -packages { <nsURI> }+");
        this.appendLine(result, "<REF-GEN-MODEL>     ::= -refGenModel <model.genmodel> { <nsURI> }+");
        this.appendLine(result, "<TEMPLATE-PATH>     ::= -templatePath <template-directory>");
        this.appendLine(result, "<MODEL-PLUGIN-ID>   ::= -modelPluginID <plugin-ID>");
        this.appendLine(result, "<COPYRIGHT>         ::= -copyright <copyright-string>");
        this.appendLine(result, "<JDK-LEVEL>         ::= -jdkLevel <jdk level: 1.4 5.0 6.0>");
        this.appendLine(result, "<IMPORT-ORGANIZING> ::= -sdo");
        this.appendLine(result, "<VALIDATE-MODEL>    ::= -validateModel <true|false>");
        this.appendLine(result, "<SDO>               ::= -sdo");
        this.appendLine(result, "<QUIET>             ::= -quiet");
        this.appendLine(result, "");
        this.appendLine(result, "Specifying no -packages is the same as specifying them all");
        this.appendLine(result, "Use ##local to represent the null nsURI");
        this.appendLine(result, "");
        this.appendLine(result, "For example:");
        this.appendLine(result, "");
        this.appendLine(result, "  xsd2genmodel");
        this.appendLine(result, "    example.xsd");
        this.appendLine(result, "    result/model/Example.genmodel");
        this.appendLine(result, "    -modelProject result src");
        this.appendLine(result, "    -editProject result.edit src");
        this.appendLine(result, "    -editorProject result.editor src");
        this.appendLine(result, "    -packages http://www.example.com/Example1");
        return result;
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-packagemap")) {
            if (this.nsURIToPackageName == null) {
                this.nsURIToPackageName = new HashMap<String, String>();
            }
            do {
                String nsURI = this.interpretNsURI(arguments[++index]);
                this.nsURIToPackageName.put(nsURI, arguments[++index]);
            } while (index + 1 < arguments.length && !arguments[index + 1].startsWith("-"));
        } else if (arguments[index].equalsIgnoreCase("-packages")) {
            if (this.packages == null) {
                this.packages = new HashSet<String>();
            }
            do {
                this.packages.add(this.interpretNsURI(arguments[++index]));
            } while (index + 1 < arguments.length && !arguments[index + 1].startsWith("-"));
        } else {
            return super.processArgument(arguments, index);
        }
        return index + 1;
    }

    protected String interpretNsURI(String nsURI) {
        return "##local".equals(nsURI) ? null : nsURI;
    }

    protected void adjustEPackages(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            for (EPackage ePackage : this.getModelImporter().getEPackages()) {
                String packageName;
                String nsURI = ExtendedMetaData.INSTANCE.getNamespace(ePackage);
                if (this.nsURIToPackageName != null && (packageName = this.nsURIToPackageName.get(nsURI)) != null) {
                    ePackage.setName(packageName);
                }
                this.handleQualifiedEPackageName(ePackage);
                boolean isNotReferencedEPackage = this.packages == null || this.packages.isEmpty() || this.packages.contains(nsURI);
                this.handleEPackage(ePackage, isNotReferencedEPackage);
            }
            this.getModelImporter().adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }
}

