/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.AbstractElement;

public enum GrammarCardinality {
    ONE("1", 0),
    ZERO_OR_ONE("?", 1),
    ZERO_OR_MORE("*", 3),
    ONE_OR_MORE("+", 2);

    private final @NonNull String name;
    private final int state;

    public static @NonNull GrammarCardinality toEnum(@NonNull AbstractElement abstractElement) {
        String cardinality = abstractElement.getCardinality();
        if ("*".equals(cardinality)) {
            return ZERO_OR_MORE;
        }
        if ("+".equals(cardinality)) {
            return ONE_OR_MORE;
        }
        if ("?".equals(cardinality)) {
            return ZERO_OR_ONE;
        }
        if ("1".equals(cardinality)) {
            return ONE;
        }
        if (cardinality == null) {
            return ONE;
        }
        throw new UnsupportedOperationException("Grammar cardinality '" + cardinality + "'");
    }

    public static @NonNull GrammarCardinality max(@NonNull GrammarCardinality grammarCardinality1, @NonNull GrammarCardinality grammarCardinality2) {
        int newState = grammarCardinality1.state | grammarCardinality2.state;
        return GrammarCardinality.valueOf(newState);
    }

    private GrammarCardinality(String name, int state) {
        this.name = name;
        this.state = state;
    }

    public boolean isOne() {
        return (this.state & 3) == GrammarCardinality.ONE.state;
    }

    public boolean isOneOrMore() {
        return (this.state & 3) == GrammarCardinality.ONE_OR_MORE.state;
    }

    public boolean isZeroOrMore() {
        return (this.state & 3) == GrammarCardinality.ZERO_OR_MORE.state;
    }

    public boolean isZeroOrOne() {
        return (this.state & 3) == GrammarCardinality.ZERO_OR_ONE.state;
    }

    public boolean mayBeMany() {
        return (this.state & 2) != 0;
    }

    public boolean mayBeZero() {
        return (this.state & 1) != 0;
    }

    public @NonNull String toString() {
        return this.name;
    }

    public static GrammarCardinality valueOf(String string) {
        return Enum.valueOf(GrammarCardinality.class, string);
    }
}

