/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.m2m.atl.adt.ui.preferences.AbstractPreferencePage;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlPreferencesMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class AtlSyntaxPreferencePage
extends AbstractPreferencePage {
    private Button backgroundColorButton;
    private ColorSelector backgroundColorSelector;
    private Button backgroundCustomRadioButton;
    private Button backgroundDefaultRadioButton;
    private Button foregroundBoldCheckBox;
    private Button foregroundColorButton;
    private Button foregroundItalicCheckBox;

    public AtlSyntaxPreferencePage() {
        super(AtlPreferencesMessages.getString("SyntaxPreferencePage.description"));
        this.colorListModel = new String[][]{{AtlPreferencesMessages.getString("SyntaxPreferencePage.brackets"), "Atl.Syntax.Bracket"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.constants"), "Atl.Syntax.Constant"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.identifiers"), "Atl.Syntax.Identifier"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.keywords"), "Atl.Syntax.Keyword"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.literals"), "Atl.Syntax.Literal"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.numbers"), "Atl.Syntax.Number"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.operators"), "Atl.Syntax.Operator"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.others"), "Atl.Syntax.Default"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.singleLineComments"), "Atl.Syntax.SingleLineComment"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.strings"), "Atl.Syntax.String"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.symbols"), "Atl.Syntax.Symbol"}, {AtlPreferencesMessages.getString("SyntaxPreferencePage.types"), "Atl.Syntax.Type"}};
    }

    protected Control createContents(Composite parent) {
        Composite control = this.newComposite(parent, 1);
        Group background = this.newGroup(control, AtlPreferencesMessages.getString("SyntaxPreferencePage.backgroundColor"));
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean custom = AtlSyntaxPreferencePage.this.backgroundCustomRadioButton.getSelection();
                AtlSyntaxPreferencePage.this.backgroundColorButton.setEnabled(custom);
                AtlSyntaxPreferencePage.this.fPreferenceeStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }
        };
        this.backgroundDefaultRadioButton = this.newRadioButton((Composite)background, AtlPreferencesMessages.getString("SyntaxPreferencePage.systemDefault"), backgroundSelectionListener);
        this.backgroundCustomRadioButton = this.newRadioButton((Composite)background, AtlPreferencesMessages.getString("SyntaxPreferencePage.custom"), backgroundSelectionListener);
        this.backgroundColorSelector = new ColorSelector((Composite)background);
        this.backgroundColorButton = this.backgroundColorSelector.getButton();
        this.backgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)AtlSyntaxPreferencePage.this.fPreferenceeStore, (String)"AbstractTextEditor.Color.Background", (RGB)AtlSyntaxPreferencePage.this.backgroundColorSelector.getColorValue());
            }
        });
        Composite foreground1 = this.newComposite(control, 1);
        Composite foreground2 = this.newComposite(foreground1, 2);
        this.colorList = this.newScrollList(foreground2);
        this.colorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AtlSyntaxPreferencePage.this.handleColorListSelection();
            }
        });
        Composite foreground3 = this.newComposite(foreground2, 1);
        Composite foreground4 = this.newComposite(foreground3, 2);
        this.colorSelector = new ColorSelector(foreground4);
        this.foregroundColorButton = this.colorSelector.getButton();
        this.foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AtlSyntaxPreferencePage.this.colorList.getSelectionIndex();
                String key = AtlSyntaxPreferencePage.this.colorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AtlSyntaxPreferencePage.this.fPreferenceeStore, (String)(String.valueOf(key) + ".Color"), (RGB)AtlSyntaxPreferencePage.this.colorSelector.getColorValue());
            }
        });
        this.foregroundBoldCheckBox = this.newCheckBoxField(foreground3, AtlPreferencesMessages.getString("SyntaxPreferencePage.bold"));
        this.foregroundBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AtlSyntaxPreferencePage.this.colorList.getSelectionIndex();
                String key = AtlSyntaxPreferencePage.this.colorListModel[i][1];
                AtlSyntaxPreferencePage.this.fPreferenceeStore.setValue(String.valueOf(key) + ".Bold", AtlSyntaxPreferencePage.this.foregroundBoldCheckBox.getSelection());
            }
        });
        this.foregroundItalicCheckBox = this.newCheckBoxField(foreground3, AtlPreferencesMessages.getString("SyntaxPreferencePage.italic"));
        this.foregroundItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AtlSyntaxPreferencePage.this.colorList.getSelectionIndex();
                String key = AtlSyntaxPreferencePage.this.colorListModel[i][1];
                AtlSyntaxPreferencePage.this.fPreferenceeStore.setValue(String.valueOf(key) + ".Italic", AtlSyntaxPreferencePage.this.foregroundItalicCheckBox.getSelection());
            }
        });
        this.initialize();
        return control;
    }

    protected void handleColorListSelection() {
        String key = this.colorListModel[this.colorList.getSelectionIndex()][1];
        this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceeStore, (String)(String.valueOf(key) + ".Color")));
        this.foregroundBoldCheckBox.setSelection(this.fPreferenceeStore.getBoolean(String.valueOf(key) + ".Bold"));
        this.foregroundItalicCheckBox.setSelection(this.fPreferenceeStore.getBoolean(String.valueOf(key) + ".Italic"));
    }

    protected void initialize() {
        super.initialize();
        this.backgroundColorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceeStore, (String)"AbstractTextEditor.Color.Background"));
        boolean _default_ = this.fPreferenceeStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.backgroundDefaultRadioButton.setSelection(_default_);
        this.backgroundCustomRadioButton.setSelection(!_default_);
        this.backgroundColorSelector.setEnabled(!_default_);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fPreferenceeStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", true);
        this.backgroundDefaultRadioButton.setSelection(true);
        this.backgroundCustomRadioButton.setSelection(false);
        this.backgroundColorSelector.setEnabled(false);
        int i = 0;
        while (i < this.colorListModel.length) {
            String key = this.colorListModel[i][1];
            PreferenceConverter.setValue((IPreferenceStore)this.fPreferenceeStore, (String)(String.valueOf(key) + ".Color"), (RGB)PreferenceConverter.getDefaultColor((IPreferenceStore)this.fPreferenceeStore, (String)(String.valueOf(key) + ".Color")));
            this.fPreferenceeStore.setValue(String.valueOf(key) + ".Bold", this.fPreferenceeStore.getDefaultBoolean(String.valueOf(key) + ".Bold"));
            this.fPreferenceeStore.setValue(String.valueOf(key) + ".Italic", this.fPreferenceeStore.getDefaultBoolean(String.valueOf(key) + ".Italic"));
            ++i;
        }
        this.handleColorListSelection();
    }
}

