/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.VMException;

public class EMFUtils {
    private static final boolean allowInterModelReferences = false;

    public static Object get(StackFrame frame, EObject eo, String name) {
        Object ret = null;
        EClass ec = eo.eClass();
        try {
            if ("__xmiID__".equals(name)) {
                ret = frame.execEnv.getModelOf((EObject)eo).resource.getURIFragment(eo);
            } else {
                EStructuralFeature sf = ec.getEStructuralFeature(name);
                Object val = eo.eGet(sf);
                if (val == null) {
                    val = OclUndefined.SINGLETON;
                }
                ret = val;
            }
        }
        catch (Exception exception) {
            throw new VMException(frame, "error accessing " + ec + "." + name);
        }
        return ret;
    }

    public static void set(StackFrame frame, EObject eo, String name, Object value) {
        String targetType;
        EStructuralFeature feature = eo.eClass().getEStructuralFeature(name);
        if (value instanceof Integer && ("java.lang.Double".equals(targetType = feature.getEType().getInstanceClassName()) || "java.lang.Float".equals(targetType))) {
            value = new Double(((Integer)value).doubleValue());
        }
        EClassifier type = feature.getEType();
        boolean targetIsEnum = type instanceof EEnum;
        try {
            Object oldValue = eo.eGet(feature);
            if (oldValue instanceof Collection) {
                Collection oldCol = (Collection)oldValue;
                if (value instanceof Collection) {
                    if (targetIsEnum) {
                        EEnum eenum = (EEnum)type;
                        for (Object v : (Collection)value) {
                            oldCol.add(eenum.getEEnumLiteral(v.toString()).getInstance());
                        }
                    } else {
                        for (Object v : (Collection)value) {
                            if (v instanceof EObject) {
                                if (frame.execEnv.getModelOf(eo) != frame.execEnv.getModelOf((EObject)v)) continue;
                                oldCol.add(v);
                                continue;
                            }
                            oldCol.add(v);
                        }
                    }
                } else if (targetIsEnum) {
                    EEnum eenum = (EEnum)type;
                    oldCol.add(eenum.getEEnumLiteral(value.toString()).getInstance());
                } else if (!(value instanceof EObject)) {
                    oldCol.add(value);
                } else if (frame.execEnv.getModelOf(eo) == frame.execEnv.getModelOf((EObject)value)) {
                    oldCol.add(value);
                }
            } else {
                if (value instanceof Collection) {
                    frame.execEnv.out.println("Warning: assigning a Collection to a single-valued feature");
                    Collection c = (Collection)value;
                    value = !c.isEmpty() ? c.iterator().next() : null;
                }
                if (targetIsEnum) {
                    EEnum eenum = (EEnum)type;
                    eo.eSet(feature, (Object)eenum.getEEnumLiteral(value.toString()).getInstance());
                } else if (!(value instanceof EObject)) {
                    eo.eSet(feature, value);
                } else if (frame.execEnv.getModelOf(eo) == frame.execEnv.getModelOf((EObject)value)) {
                    eo.eSet(feature, value);
                }
            }
        }
        catch (Exception exception) {
            frame.execEnv.out.println("Warning: could not assign " + value + " to " + frame.execEnv.toPrettyPrintedString(eo) + "." + name);
        }
    }

    public static void delete(StackFrame frame, EObject eo) {
        eo.eAdapters().clear();
        EcoreUtil.remove((EObject)eo);
    }
}

