/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.atl.engine.vm.ClassNativeOperation;
import org.eclipse.m2m.atl.engine.vm.InstanceNativeOperation;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMMap;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public abstract class NativeOperation
extends Operation {
    private static Map trans;
    private List parameters;
    private ASMOclType returnType;
    private ASMOclType contextType;
    private Method method;
    private String name;

    private static Map getTrans() {
        if (trans == null) {
            trans = new HashMap();
            trans.put("operatorMinus", "-");
            trans.put("operatorPlus", "+");
            trans.put("operatorMul", "*");
            trans.put("operatorDiv", "/");
            trans.put("operatorEQ", "=");
            trans.put("operatorNE", "<>");
            trans.put("operatorLT", "<");
            trans.put("operatorLE", "<=");
            trans.put("operatorGT", ">");
            trans.put("operatorGE", ">=");
        }
        return trans;
    }

    public NativeOperation(Method method, List parameters, ASMOclType returnType, ASMOclType contextType) {
        this.method = method;
        this.parameters = parameters;
        this.returnType = returnType;
        this.contextType = contextType;
        this.name = method.getName();
        if (NativeOperation.getTrans().containsKey(this.name)) {
            this.name = (String)NativeOperation.getTrans().get(this.name);
        }
    }

    public static void registerOperations(ASMOclType t, Class c) {
        NativeOperation.registerOperations(t, c, true, false, false, false);
    }

    public static void registerOperations(ASMOclType t, Class c, boolean allowClassLevel, boolean allowInstanceLevel, boolean allowTypeTranslation, boolean allowDontUseFrame) {
        for (Method m : Arrays.asList(c.getDeclaredMethods())) {
            Class<?> pt;
            boolean isStatic;
            boolean bl = isStatic = (8 & m.getModifiers()) != 0;
            if (!allowClassLevel && isStatic || !allowInstanceLevel && !isStatic || (1 & m.getModifiers()) == 0) continue;
            boolean dontUseFrame = false;
            boolean notGood = false;
            Iterator<Class<?>> j = Arrays.asList(m.getParameterTypes()).iterator();
            ArrayList<ASMOclType> parameters = new ArrayList<ASMOclType>();
            if (j.hasNext()) {
                pt = j.next();
                if (!pt.equals(StackFrame.class)) {
                    if (allowDontUseFrame) {
                        dontUseFrame = true;
                    } else {
                        notGood = true;
                    }
                    j = Arrays.asList(m.getParameterTypes()).iterator();
                }
                if (!isStatic) {
                    j = Arrays.asList(m.getParameterTypes()).iterator();
                }
            } else if (allowDontUseFrame) {
                dontUseFrame = true;
            } else {
                notGood = true;
            }
            while (j.hasNext() && !notGood) {
                pt = j.next();
                ASMOclType paramType = NativeOperation.getASMType(pt, allowTypeTranslation);
                if (paramType == null) {
                    notGood = true;
                    continue;
                }
                parameters.add(paramType);
            }
            Class<?> rt = m.getReturnType();
            ASMOclType returnType = NativeOperation.getASMType(rt, allowTypeTranslation);
            if (!(returnType != null || rt.isPrimitive() && rt.getName().equals("void"))) {
                notGood = true;
            }
            if (notGood) continue;
            if ((8 & m.getModifiers()) != 0) {
                parameters.remove(0);
                t.registerVMOperation(new ClassNativeOperation(m, parameters, returnType, NativeOperation.getASMType(c, allowTypeTranslation)));
                continue;
            }
            t.registerVMOperation(new InstanceNativeOperation(m, allowTypeTranslation, dontUseFrame, parameters, returnType, NativeOperation.getASMType(c, allowTypeTranslation)));
        }
    }

    protected static ASMOclType getASMType(Class pt, boolean allowTypeTranslation) {
        ASMOclType ret = null;
        if (ASMOclAny.class.isAssignableFrom(pt)) {
            if (ASMOclAny.class.equals((Object)pt)) {
                ret = ASMOclAny.getOclAnyType();
            } else {
                try {
                    ret = (ASMOclType)pt.getField("myType").get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        } else if (allowTypeTranslation) {
            if (pt.equals(Integer.TYPE) || pt.equals(Integer.class)) {
                ret = ASMInteger.myType;
            } else if (pt.equals(Double.TYPE) || pt.equals(Double.class) || pt.equals(Float.TYPE) || pt.equals(Float.class)) {
                ret = ASMReal.myType;
            } else if (pt.equals(Boolean.TYPE) || pt.equals(Boolean.class)) {
                ret = ASMBoolean.myType;
            } else if (pt.equals(String.class)) {
                ret = ASMString.myType;
            } else if (pt.equals(List.class)) {
                ret = ASMSequence.myType;
            } else if (pt.equals(Set.class)) {
                ret = ASMSet.myType;
            } else if (pt.equals(Collection.class)) {
                ret = ASMBag.myType;
            } else if (pt.equals(Map.class)) {
                ret = ASMMap.myType;
            }
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public String getContextSignature() {
        return null;
    }

    public String getSignature() {
        return null;
    }

    public abstract ASMOclAny exec(StackFrame var1);

    public String toString() {
        return "NativeOperation " + this.method;
    }

    public Method getMethod() {
        return this.method;
    }

    public List getParameters() {
        return this.parameters;
    }

    public ASMOclType getReturnType() {
        return this.returnType;
    }

    public ASMOclType getContextType() {
        return this.contextType;
    }
}

