/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BagType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BooleanType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.CollectionType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.IntegerType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.MapType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModelElementType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OrderedSetType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.RealType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SequenceType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SetType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.StringType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.TupleType;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OclAnyType {
    private static OclAnyType instance;
    private static List<Operation> operations;
    protected OclType oclType;

    private OclAnyType() {
    }

    protected OclAnyType(OclType oclType) {
        this.oclType = oclType;
    }

    public OclType getOclType() {
        return this.oclType;
    }

    public OclAnyType[] getSupertypes() {
        return new OclAnyType[0];
    }

    public List<Feature> getFeatures() {
        return Collections.emptyList();
    }

    public Set<Operation> getOperations() {
        LinkedHashSet<Operation> res = new LinkedHashSet<Operation>();
        List<Operation> localOperations = this.getTypeOperations();
        Collections.sort(localOperations);
        res.addAll(localOperations);
        OclAnyType[] oclAnyTypeArray = this.getSupertypes();
        int n = oclAnyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OclAnyType supertype = oclAnyTypeArray[n2];
            res.addAll(supertype.getOperations());
            ++n2;
        }
        return res;
    }

    protected List<Operation> getTypeOperations() {
        if (operations == null) {
            operations = new ArrayList<Operation>(){
                {
                    this.add(new Operation("oclIsKindOf", OclAnyType.getInstance(), BooleanType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("t", OclType.getInstance());
                        }
                    }));
                    this.add(new Operation("oclIsTypeOf", OclAnyType.getInstance(), BooleanType.getInstance(), (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("t", OclType.getInstance());
                        }
                    }));
                    this.add(new Operation("oclIsUndefined", OclAnyType.getInstance(), BooleanType.getInstance()));
                    this.add(new Operation("toString", OclAnyType.getInstance(), StringType.getInstance()));
                    this.add(new Operation("debug", OclAnyType.getInstance(), null));
                    this.add(new Operation("oclType", OclAnyType.getInstance(), OclType.getInstance()));
                    this.add(new Operation("refSetValue", OclAnyType.getInstance(), null, (Map<String, OclAnyType>)new LinkedHashMap<String, OclAnyType>(){
                        {
                            this.put("name", StringType.getInstance());
                            this.put("value", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("refUnsetValue", OclAnyType.getInstance(), null, (Map<String, OclAnyType>)new LinkedHashMap<String, OclAnyType>(){
                        {
                            this.put("name", StringType.getInstance());
                            this.put("value", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("refGetValue", OclAnyType.getInstance(), null, new HashMap<String, OclAnyType>(){
                        {
                            this.put("name", StringType.getInstance());
                        }
                    }){

                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            return OclAnyType.getInstance();
                        }
                    });
                    this.add(new Operation("refImmediateComposite", OclAnyType.getInstance(), OclAnyType.getInstance()));
                    this.add(new Operation("refInvokeOperation", OclAnyType.getInstance(), OclAnyType.getInstance(), (Map<String, OclAnyType>)new LinkedHashMap<String, OclAnyType>(){
                        {
                            this.put("opName", StringType.getInstance());
                            this.put("args", SequenceType.getInstance());
                        }
                    }));
                }
            };
        }
        return operations;
    }

    public String toString() {
        return this.getOclType().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OclAnyType) {
            return this.getOclType().equals(((OclAnyType)obj).getOclType());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getOclType().hashCode();
    }

    public static OclAnyType getInstance() {
        if (instance == null) {
            instance = new OclAnyType();
            OclAnyType.instance.oclType = new OclType("OclAny");
        }
        return instance;
    }

    public static OclAnyType create(AtlSourceManager manager, EObject atlType) {
        OclAnyType res = OclAnyType.getInstance();
        if (atlType != null) {
            String atlTypeName = atlType.eClass().getName();
            if (atlTypeName.equals("OclModelElement")) {
                EObject model = (EObject)AtlTypesProcessor.eGet(atlType, "model");
                if (model != null) {
                    List packages;
                    String metamodelName = AtlTypesProcessor.eGet(model, "name").toString();
                    String elementName = AtlTypesProcessor.eGet(atlType, "name").toString();
                    String classifierName = null;
                    if (elementName.contains("::")) {
                        String[] fragments = elementName.split("::");
                        classifierName = fragments[fragments.length - 1];
                    } else {
                        classifierName = elementName;
                    }
                    if (manager != null && (packages = manager.getMetamodelPackages(metamodelName)) != null) {
                        for (EPackage pack : packages) {
                            EClassifier classifier = pack.getEClassifier(classifierName);
                            if (classifier == null) continue;
                            res = ModelElementType.create(classifier, metamodelName);
                        }
                    }
                }
            } else if (atlTypeName.equals("StringType")) {
                res = StringType.getInstance();
            } else if (atlTypeName.equals("BooleanType")) {
                res = BooleanType.getInstance();
            } else if (atlTypeName.equals("DoubleType")) {
                res = RealType.getInstance();
            } else if (atlTypeName.equals("IntegerType")) {
                res = IntegerType.getInstance();
            } else if (atlTypeName.equals("SequenceType")) {
                EObject parameterType = (EObject)AtlTypesProcessor.eGet(atlType, "elementType");
                OclAnyType parameter = OclAnyType.create(manager, parameterType);
                res = new SequenceType(parameter);
            } else if (atlTypeName.equals("BagType")) {
                EObject parameterType = (EObject)AtlTypesProcessor.eGet(atlType, "elementType");
                OclAnyType parameter = OclAnyType.create(manager, parameterType);
                res = new BagType(parameter);
            } else if (atlTypeName.equals("CollectionType")) {
                EObject parameterType = (EObject)AtlTypesProcessor.eGet(atlType, "elementType");
                OclAnyType parameter = OclAnyType.create(manager, parameterType);
                res = new CollectionType(parameter);
            } else if (atlTypeName.equals("SetType")) {
                EObject parameterType = (EObject)AtlTypesProcessor.eGet(atlType, "elementType");
                OclAnyType parameter = OclAnyType.create(manager, parameterType);
                res = new SetType(parameter);
            } else if (atlTypeName.equals("OrderedSetType")) {
                EObject parameterType = (EObject)AtlTypesProcessor.eGet(atlType, "elementType");
                OclAnyType parameter = OclAnyType.create(manager, parameterType);
                res = new OrderedSetType(parameter);
            } else if (atlTypeName.equals("MapType")) {
                EObject keyType = (EObject)AtlTypesProcessor.eGet(atlType, "keyType");
                EObject valueType = (EObject)AtlTypesProcessor.eGet(atlType, "valueType");
                OclAnyType key = OclAnyType.create(manager, keyType);
                OclAnyType value = OclAnyType.create(manager, valueType);
                res = new MapType(key, value);
            } else if (atlTypeName.equals("TupleType")) {
                EList attributesMap = (EList)AtlTypesProcessor.eGet(atlType, "attributes");
                HashMap<String, OclAnyType> attributes = new HashMap<String, OclAnyType>();
                HashMap<String, EObject> eAttributes = new HashMap<String, EObject>();
                for (EObject o : attributesMap) {
                    EObject type = (EObject)AtlTypesProcessor.eGet(o, "type");
                    String name = (String)AtlTypesProcessor.eGet(o, "name");
                    OclAnyType t = OclAnyType.create(manager, type);
                    attributes.put(name, t);
                    eAttributes.put(name, type);
                }
                res = new TupleType(attributes, eAttributes);
            }
        }
        return res;
    }
}

