/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/*
* generated by Xtext
*/
package org.eclipse.qvtd.xtext.qvtcore.services;

import com.google.inject.Singleton;
import com.google.inject.Inject;

import java.util.List;

import org.eclipse.xtext.*;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.service.AbstractElementFinder.*;

import org.eclipse.qvtd.xtext.qvtcorebase.services.QVTcoreBaseGrammarAccess;
import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLGrammarAccess;

@Singleton
public class QVTcoreGrammarAccess extends AbstractGrammarElementFinder {
	
	
	public class TopLevelCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "TopLevelCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cOwnedImportAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final RuleCall cOwnedImportImportCSParserRuleCall_0_0_0 = (RuleCall)cOwnedImportAssignment_0_0.eContents().get(0);
		private final Assignment cOwnedLibraryAssignment_0_1 = (Assignment)cAlternatives_0.eContents().get(1);
		private final RuleCall cOwnedLibraryLibraryCSParserRuleCall_0_1_0 = (RuleCall)cOwnedLibraryAssignment_0_1.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cMappingsAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final RuleCall cMappingsMappingCSParserRuleCall_1_0_0 = (RuleCall)cMappingsAssignment_1_0.eContents().get(0);
		private final Assignment cTransformationsAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final RuleCall cTransformationsTransformationCSParserRuleCall_1_1_0 = (RuleCall)cTransformationsAssignment_1_1.eContents().get(0);
		private final Assignment cQueriesAssignment_1_2 = (Assignment)cAlternatives_1.eContents().get(2);
		private final RuleCall cQueriesQueryCSParserRuleCall_1_2_0 = (RuleCall)cQueriesAssignment_1_2.eContents().get(0);
		
		//TopLevelCS:
		//	(ownedImport+=ImportCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* (mappings+=MappingCS |
		//	transformations+=TransformationCS | queries+=QueryCS)*;
		public ParserRule getRule() { return rule; }

		//(ownedImport+=ImportCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* (mappings+=MappingCS |
		//transformations+=TransformationCS | queries+=QueryCS)*
		public Group getGroup() { return cGroup; }

		//(ownedImport+=ImportCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)*
		public Alternatives getAlternatives_0() { return cAlternatives_0; }

		//ownedImport+=ImportCS
		public Assignment getOwnedImportAssignment_0_0() { return cOwnedImportAssignment_0_0; }

		//ImportCS
		public RuleCall getOwnedImportImportCSParserRuleCall_0_0_0() { return cOwnedImportImportCSParserRuleCall_0_0_0; }

		/// *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS
		public Assignment getOwnedLibraryAssignment_0_1() { return cOwnedLibraryAssignment_0_1; }

		//LibraryCS
		public RuleCall getOwnedLibraryLibraryCSParserRuleCall_0_1_0() { return cOwnedLibraryLibraryCSParserRuleCall_0_1_0; }

		//(mappings+=MappingCS | transformations+=TransformationCS | queries+=QueryCS)*
		public Alternatives getAlternatives_1() { return cAlternatives_1; }

		//mappings+=MappingCS
		public Assignment getMappingsAssignment_1_0() { return cMappingsAssignment_1_0; }

		//MappingCS
		public RuleCall getMappingsMappingCSParserRuleCall_1_0_0() { return cMappingsMappingCSParserRuleCall_1_0_0; }

		//transformations+=TransformationCS
		public Assignment getTransformationsAssignment_1_1() { return cTransformationsAssignment_1_1; }

		//TransformationCS
		public RuleCall getTransformationsTransformationCSParserRuleCall_1_1_0() { return cTransformationsTransformationCSParserRuleCall_1_1_0; }

		//queries+=QueryCS
		public Assignment getQueriesAssignment_1_2() { return cQueriesAssignment_1_2; }

		//QueryCS
		public RuleCall getQueriesQueryCSParserRuleCall_1_2_0() { return cQueriesQueryCSParserRuleCall_1_2_0; }
	}

	public class MappingCSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "MappingCS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMappingCSAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cMapKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameUnrestrictedNameParserRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cInKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cInAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final CrossReference cInTransformationCrossReference_3_1_0 = (CrossReference)cInAssignment_3_1.eContents().get(0);
		private final RuleCall cInTransformationUnrestrictedNameParserRuleCall_3_1_0_1 = (RuleCall)cInTransformationCrossReference_3_1_0.eContents().get(1);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cRefinesKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Assignment cRefinesAssignment_4_1 = (Assignment)cGroup_4.eContents().get(1);
		private final CrossReference cRefinesMappingCrossReference_4_1_0 = (CrossReference)cRefinesAssignment_4_1.eContents().get(0);
		private final RuleCall cRefinesMappingUnrestrictedNameParserRuleCall_4_1_0_1 = (RuleCall)cRefinesMappingCrossReference_4_1_0.eContents().get(1);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Keyword cCommaKeyword_4_2_0 = (Keyword)cGroup_4_2.eContents().get(0);
		private final Assignment cRefinesAssignment_4_2_1 = (Assignment)cGroup_4_2.eContents().get(1);
		private final CrossReference cRefinesMappingCrossReference_4_2_1_0 = (CrossReference)cRefinesAssignment_4_2_1.eContents().get(0);
		private final RuleCall cRefinesMappingUnrestrictedNameParserRuleCall_4_2_1_0_1 = (RuleCall)cRefinesMappingCrossReference_4_2_1_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cDomainsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cDomainsNamedDomainCSParserRuleCall_6_0 = (RuleCall)cDomainsAssignment_6.eContents().get(0);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Keyword cWhereKeyword_7_0 = (Keyword)cGroup_7.eContents().get(0);
		private final Assignment cMiddleAssignment_7_1 = (Assignment)cGroup_7.eContents().get(1);
		private final RuleCall cMiddleUnnamedDomainCSParserRuleCall_7_1_0 = (RuleCall)cMiddleAssignment_7_1.eContents().get(0);
		private final Assignment cComposedMappingsAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cComposedMappingsMappingCSParserRuleCall_8_0 = (RuleCall)cComposedMappingsAssignment_8.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_9 = (Keyword)cGroup.eContents().get(9);
		
		//MappingCS:
		//	{MappingCS} "map" name=UnrestrictedName? ("in" in=[qvtbase::Transformation|UnrestrictedName])? ("refines"
		//	refines+=[qvtcore::Mapping|UnrestrictedName] ("," refines+=[qvtcore::Mapping|UnrestrictedName])*)? "{"
		//	domains+=NamedDomainCS* ("where" middle=UnnamedDomainCS)? composedMappings+=MappingCS* "}";
		public ParserRule getRule() { return rule; }

		//{MappingCS} "map" name=UnrestrictedName? ("in" in=[qvtbase::Transformation|UnrestrictedName])? ("refines"
		//refines+=[qvtcore::Mapping|UnrestrictedName] ("," refines+=[qvtcore::Mapping|UnrestrictedName])*)? "{"
		//domains+=NamedDomainCS* ("where" middle=UnnamedDomainCS)? composedMappings+=MappingCS* "}"
		public Group getGroup() { return cGroup; }

		//{MappingCS}
		public Action getMappingCSAction_0() { return cMappingCSAction_0; }

		//"map"
		public Keyword getMapKeyword_1() { return cMapKeyword_1; }

		//name=UnrestrictedName?
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }

		//UnrestrictedName
		public RuleCall getNameUnrestrictedNameParserRuleCall_2_0() { return cNameUnrestrictedNameParserRuleCall_2_0; }

		//("in" in=[qvtbase::Transformation|UnrestrictedName])?
		public Group getGroup_3() { return cGroup_3; }

		//"in"
		public Keyword getInKeyword_3_0() { return cInKeyword_3_0; }

		//in=[qvtbase::Transformation|UnrestrictedName]
		public Assignment getInAssignment_3_1() { return cInAssignment_3_1; }

		//[qvtbase::Transformation|UnrestrictedName]
		public CrossReference getInTransformationCrossReference_3_1_0() { return cInTransformationCrossReference_3_1_0; }

		//UnrestrictedName
		public RuleCall getInTransformationUnrestrictedNameParserRuleCall_3_1_0_1() { return cInTransformationUnrestrictedNameParserRuleCall_3_1_0_1; }

		//("refines" refines+=[qvtcore::Mapping|UnrestrictedName] ("," refines+=[qvtcore::Mapping|UnrestrictedName])*)?
		public Group getGroup_4() { return cGroup_4; }

		//"refines"
		public Keyword getRefinesKeyword_4_0() { return cRefinesKeyword_4_0; }

		//refines+=[qvtcore::Mapping|UnrestrictedName]
		public Assignment getRefinesAssignment_4_1() { return cRefinesAssignment_4_1; }

		//[qvtcore::Mapping|UnrestrictedName]
		public CrossReference getRefinesMappingCrossReference_4_1_0() { return cRefinesMappingCrossReference_4_1_0; }

		//UnrestrictedName
		public RuleCall getRefinesMappingUnrestrictedNameParserRuleCall_4_1_0_1() { return cRefinesMappingUnrestrictedNameParserRuleCall_4_1_0_1; }

		//("," refines+=[qvtcore::Mapping|UnrestrictedName])*
		public Group getGroup_4_2() { return cGroup_4_2; }

		//","
		public Keyword getCommaKeyword_4_2_0() { return cCommaKeyword_4_2_0; }

		//refines+=[qvtcore::Mapping|UnrestrictedName]
		public Assignment getRefinesAssignment_4_2_1() { return cRefinesAssignment_4_2_1; }

		//[qvtcore::Mapping|UnrestrictedName]
		public CrossReference getRefinesMappingCrossReference_4_2_1_0() { return cRefinesMappingCrossReference_4_2_1_0; }

		//UnrestrictedName
		public RuleCall getRefinesMappingUnrestrictedNameParserRuleCall_4_2_1_0_1() { return cRefinesMappingUnrestrictedNameParserRuleCall_4_2_1_0_1; }

		//"{"
		public Keyword getLeftCurlyBracketKeyword_5() { return cLeftCurlyBracketKeyword_5; }

		//domains+=NamedDomainCS*
		public Assignment getDomainsAssignment_6() { return cDomainsAssignment_6; }

		//NamedDomainCS
		public RuleCall getDomainsNamedDomainCSParserRuleCall_6_0() { return cDomainsNamedDomainCSParserRuleCall_6_0; }

		//("where" middle=UnnamedDomainCS)?
		public Group getGroup_7() { return cGroup_7; }

		//"where"
		public Keyword getWhereKeyword_7_0() { return cWhereKeyword_7_0; }

		//middle=UnnamedDomainCS
		public Assignment getMiddleAssignment_7_1() { return cMiddleAssignment_7_1; }

		//UnnamedDomainCS
		public RuleCall getMiddleUnnamedDomainCSParserRuleCall_7_1_0() { return cMiddleUnnamedDomainCSParserRuleCall_7_1_0; }

		//composedMappings+=MappingCS*
		public Assignment getComposedMappingsAssignment_8() { return cComposedMappingsAssignment_8; }

		//MappingCS
		public RuleCall getComposedMappingsMappingCSParserRuleCall_8_0() { return cComposedMappingsMappingCSParserRuleCall_8_0; }

		//"}"
		public Keyword getRightCurlyBracketKeyword_9() { return cRightCurlyBracketKeyword_9; }
	}
	
	
	private TopLevelCSElements pTopLevelCS;
	private MappingCSElements pMappingCS;
	
	private final Grammar grammar;

	private QVTcoreBaseGrammarAccess gaQVTcoreBase;

	@Inject
	public QVTcoreGrammarAccess(GrammarProvider grammarProvider,
		QVTcoreBaseGrammarAccess gaQVTcoreBase) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaQVTcoreBase = gaQVTcoreBase;
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.qvtd.xtext.qvtcore.QVTcore".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	
	public Grammar getGrammar() {
		return grammar;
	}
	

	public QVTcoreBaseGrammarAccess getQVTcoreBaseGrammarAccess() {
		return gaQVTcoreBase;
	}

	
	//TopLevelCS:
	//	(ownedImport+=ImportCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* (mappings+=MappingCS |
	//	transformations+=TransformationCS | queries+=QueryCS)*;
	public TopLevelCSElements getTopLevelCSAccess() {
		return (pTopLevelCS != null) ? pTopLevelCS : (pTopLevelCS = new TopLevelCSElements());
	}
	
	public ParserRule getTopLevelCSRule() {
		return getTopLevelCSAccess().getRule();
	}

	//MappingCS:
	//	{MappingCS} "map" name=UnrestrictedName? ("in" in=[qvtbase::Transformation|UnrestrictedName])? ("refines"
	//	refines+=[qvtcore::Mapping|UnrestrictedName] ("," refines+=[qvtcore::Mapping|UnrestrictedName])*)? "{"
	//	domains+=NamedDomainCS* ("where" middle=UnnamedDomainCS)? composedMappings+=MappingCS* "}";
	public MappingCSElements getMappingCSAccess() {
		return (pMappingCS != null) ? pMappingCS : (pMappingCS = new MappingCSElements());
	}
	
	public ParserRule getMappingCSRule() {
		return getMappingCSAccess().getRule();
	}

	//BottomPatternCS:
	//	"{" (unrealizedVariables+=UnrealizedVariableCS | realizedVariables+=RealizedVariableCS) (","
	//	(unrealizedVariables+=UnrealizedVariableCS | realizedVariables+=RealizedVariableCS))* "|" constraints+=AssignmentCS*
	//	"}" | {BottomPatternCS} "{" constraints+=AssignmentCS* "}";
	public QVTcoreBaseGrammarAccess.BottomPatternCSElements getBottomPatternCSAccess() {
		return gaQVTcoreBase.getBottomPatternCSAccess();
	}
	
	public ParserRule getBottomPatternCSRule() {
		return getBottomPatternCSAccess().getRule();
	}

	////Constraint ::= Predicate | Assignment
	////Predicate ::= BooleanOCLExpr
	////Assignement ::= [�default�] SlotOwnerOCLExpr�.�PropertyName �:=� ValueOCLExpr
	//AssignmentCS:
	//	default?="default"? target=ExpCS (":=" initialiser=ExpCS)? ";";
	public QVTcoreBaseGrammarAccess.AssignmentCSElements getAssignmentCSAccess() {
		return gaQVTcoreBase.getAssignmentCSAccess();
	}
	
	public ParserRule getAssignmentCSRule() {
		return getAssignmentCSAccess().getRule();
	}

	//DirectionCS:
	//	{DirectionCS} name=UnrestrictedName? ("imports" imports+=[pivot::Package|UnrestrictedName] (","
	//	imports+=[pivot::Package|UnrestrictedName])*)? ("uses" uses+=[qvtcorebase::CoreDomain|UnrestrictedName] (","
	//	uses+=[qvtcorebase::CoreDomain|UnrestrictedName])*)?;
	public QVTcoreBaseGrammarAccess.DirectionCSElements getDirectionCSAccess() {
		return gaQVTcoreBase.getDirectionCSAccess();
	}
	
	public ParserRule getDirectionCSRule() {
		return getDirectionCSAccess().getRule();
	}

	////EnforcementOperationCS: ('creation'|'deletion') ExpCS ';';
	//GuardPatternCS:
	//	"(" unrealizedVariables+=UnrealizedVariableCS ("," unrealizedVariables+=UnrealizedVariableCS)* "|"
	//	constraints+=AssignmentCS* ")" | {GuardPatternCS} "(" constraints+=AssignmentCS* ")";
	public QVTcoreBaseGrammarAccess.GuardPatternCSElements getGuardPatternCSAccess() {
		return gaQVTcoreBase.getGuardPatternCSAccess();
	}
	
	public ParserRule getGuardPatternCSRule() {
		return getGuardPatternCSAccess().getRule();
	}

	//ImportCS returns base::ImportCS:
	//	"import" (name=Identifier ":")? pathName=URIPathNameCS (all?="::" "*")? ";";
	public QVTcoreBaseGrammarAccess.ImportCSElements getImportCSAccess() {
		return gaQVTcoreBase.getImportCSAccess();
	}
	
	public ParserRule getImportCSRule() {
		return getImportCSAccess().getRule();
	}

	////IncludeCS returns IncludeCS:
	////	'include' namespace=[pivot::Namespace|URI] ';';
	//LibraryCS returns base::LibraryCS:
	//	"library" package=[pivot::Package|URI] ";";
	public QVTcoreBaseGrammarAccess.LibraryCSElements getLibraryCSAccess() {
		return gaQVTcoreBase.getLibraryCSAccess();
	}
	
	public ParserRule getLibraryCSRule() {
		return getLibraryCSAccess().getRule();
	}

	//NamedDomainCS returns DomainCS:
	//	check?="check"? enforce?="enforce"? direction=[qvtbase::TypedModel|UnrestrictedName] guardPattern=GuardPatternCS
	//	bottomPattern=BottomPatternCS;
	public QVTcoreBaseGrammarAccess.NamedDomainCSElements getNamedDomainCSAccess() {
		return gaQVTcoreBase.getNamedDomainCSAccess();
	}
	
	public ParserRule getNamedDomainCSRule() {
		return getNamedDomainCSAccess().getRule();
	}

	//ParamDeclarationCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public QVTcoreBaseGrammarAccess.ParamDeclarationCSElements getParamDeclarationCSAccess() {
		return gaQVTcoreBase.getParamDeclarationCSAccess();
	}
	
	public ParserRule getParamDeclarationCSRule() {
		return getParamDeclarationCSAccess().getRule();
	}

	//QueryCS:
	//	"query" pathName=ScopeNameCS name=UnrestrictedName "(" (inputParamDeclaration+=ParamDeclarationCS (","
	//	inputParamDeclaration+=ParamDeclarationCS)*)? ")" ":" ownedType=TypeExpCS (";" | "{" expression=ExpCS "}");
	public QVTcoreBaseGrammarAccess.QueryCSElements getQueryCSAccess() {
		return gaQVTcoreBase.getQueryCSAccess();
	}
	
	public ParserRule getQueryCSRule() {
		return getQueryCSAccess().getRule();
	}

	////<query> ::= 'query' <PathNameCS> 
	////            '(' [<paramDeclaration> (',' <paramDeclaration>)*] ')'
	////      	  ':' <TypeCS>
	////            (';' | '{' <OCLExpressionCS> '}')
	//ScopeNameCS returns base::PathNameCS:
	//	path+=FirstPathElementCS "::" (path+=NextPathElementCS "::")*;
	public QVTcoreBaseGrammarAccess.ScopeNameCSElements getScopeNameCSAccess() {
		return gaQVTcoreBase.getScopeNameCSAccess();
	}
	
	public ParserRule getScopeNameCSRule() {
		return getScopeNameCSAccess().getRule();
	}

	//TransformationCS:
	//	"transformation" pathName=ScopeNameCS? name=UnreservedName "{" (directions+=DirectionCS ";")* "}";
	public QVTcoreBaseGrammarAccess.TransformationCSElements getTransformationCSAccess() {
		return gaQVTcoreBase.getTransformationCSAccess();
	}
	
	public ParserRule getTransformationCSRule() {
		return getTransformationCSAccess().getRule();
	}

	////Variable := VariableName �:� TypeDeclaration
	//UnrealizedVariableCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public QVTcoreBaseGrammarAccess.UnrealizedVariableCSElements getUnrealizedVariableCSAccess() {
		return gaQVTcoreBase.getUnrealizedVariableCSAccess();
	}
	
	public ParserRule getUnrealizedVariableCSRule() {
		return getUnrealizedVariableCSAccess().getRule();
	}

	////RealizedVariable := �realized� VariableName �:� TypeDeclaration
	//RealizedVariableCS:
	//	"realize" name=UnrestrictedName ":" ownedType=TypeExpCS;
	public QVTcoreBaseGrammarAccess.RealizedVariableCSElements getRealizedVariableCSAccess() {
		return gaQVTcoreBase.getRealizedVariableCSAccess();
	}
	
	public ParserRule getRealizedVariableCSRule() {
		return getRealizedVariableCSAccess().getRule();
	}

	//UnnamedDomainCS returns DomainCS:
	//	{DomainCS} guardPattern=GuardPatternCS bottomPattern=BottomPatternCS;
	public QVTcoreBaseGrammarAccess.UnnamedDomainCSElements getUnnamedDomainCSAccess() {
		return gaQVTcoreBase.getUnnamedDomainCSAccess();
	}
	
	public ParserRule getUnnamedDomainCSRule() {
		return getUnnamedDomainCSAccess().getRule();
	}

	////|	'where'
	//UnrestrictedName returns ecore::EString:
	//	EssentialOCLUnrestrictedName //|	'creation'
	//	//|	'default'
	//	//|	'deletion'
	//	//|	'include'
	//	| "check" | "enforce" | "import" | "imports" | "library" | "map" | "query" | "realize" | "refines" | "transformation" |
	//	"uses";
	public QVTcoreBaseGrammarAccess.UnrestrictedNameElements getUnrestrictedNameAccess() {
		return gaQVTcoreBase.getUnrestrictedNameAccess();
	}
	
	public ParserRule getUnrestrictedNameRule() {
		return getUnrestrictedNameAccess().getRule();
	}

	////generate essentialOCLCST "http://www.eclipse.org/ocl/3.0.0/EssentialOCLCST"
	//Model returns ContextCS:
	//	ownedExpression=ExpCS;
	public EssentialOCLGrammarAccess.ModelElements getModelAccess() {
		return gaQVTcoreBase.getModelAccess();
	}
	
	public ParserRule getModelRule() {
		return getModelAccess().getRule();
	}

	//terminal fragment ESCAPED_CHARACTER:
	//	"\\" ("b" | "t" | "n" | "f" | "r" | "u" | "\"" | "\'" | "\\");
	public TerminalRule getESCAPED_CHARACTERRule() {
		return gaQVTcoreBase.getESCAPED_CHARACTERRule();
	} 

	//terminal fragment LETTER_CHARACTER:
	//	"a".."z" | "A".."Z" | "_";
	public TerminalRule getLETTER_CHARACTERRule() {
		return gaQVTcoreBase.getLETTER_CHARACTERRule();
	} 

	//terminal DOUBLE_QUOTED_STRING:
	//	"\"" (ESCAPED_CHARACTER | !("\\" | "\""))* "\"";
	public TerminalRule getDOUBLE_QUOTED_STRINGRule() {
		return gaQVTcoreBase.getDOUBLE_QUOTED_STRINGRule();
	} 

	//terminal SINGLE_QUOTED_STRING:
	//	"\'" (ESCAPED_CHARACTER | !("\\" | "\'"))* "\'";
	public TerminalRule getSINGLE_QUOTED_STRINGRule() {
		return gaQVTcoreBase.getSINGLE_QUOTED_STRINGRule();
	} 

	//terminal ML_SINGLE_QUOTED_STRING:
	//	"/\'"->"\'/";
	public TerminalRule getML_SINGLE_QUOTED_STRINGRule() {
		return gaQVTcoreBase.getML_SINGLE_QUOTED_STRINGRule();
	} 

	//terminal SIMPLE_ID:
	//	LETTER_CHARACTER (LETTER_CHARACTER | "0".."9")*;
	public TerminalRule getSIMPLE_IDRule() {
		return gaQVTcoreBase.getSIMPLE_IDRule();
	} 

	//terminal ESCAPED_ID:
	//	"_" SINGLE_QUOTED_STRING;
	public TerminalRule getESCAPED_IDRule() {
		return gaQVTcoreBase.getESCAPED_IDRule();
	} 

	//ID:
	//	SIMPLE_ID | ESCAPED_ID;
	public EssentialOCLGrammarAccess.IDElements getIDAccess() {
		return gaQVTcoreBase.getIDAccess();
	}
	
	public ParserRule getIDRule() {
		return getIDAccess().getRule();
	}

	//// String to allow diverse re-use
	//// multiple leading zeroes occur as floating point fractional part
	//terminal INT:
	//	"0".."9"+;
	public TerminalRule getINTRule() {
		return gaQVTcoreBase.getINTRule();
	} 

	//LOWER returns ecore::EInt:
	//	INT;
	public EssentialOCLGrammarAccess.LOWERElements getLOWERAccess() {
		return gaQVTcoreBase.getLOWERAccess();
	}
	
	public ParserRule getLOWERRule() {
		return getLOWERAccess().getRule();
	}

	//UPPER returns ecore::EInt:
	//	INT | "*";
	public EssentialOCLGrammarAccess.UPPERElements getUPPERAccess() {
		return gaQVTcoreBase.getUPPERAccess();
	}
	
	public ParserRule getUPPERRule() {
		return getUPPERAccess().getRule();
	}

	//// Not terminal to allow parser backtracking to sort out "5..7"
	//// EssentialOCLTokenSource pieces this together ('.' INT)? (('e' | 'E') ('+' | '-')? INT)?;
	//NUMBER_LITERAL returns BigNumber:
	//	INT;
	public EssentialOCLGrammarAccess.NUMBER_LITERALElements getNUMBER_LITERALAccess() {
		return gaQVTcoreBase.getNUMBER_LITERALAccess();
	}
	
	public ParserRule getNUMBER_LITERALRule() {
		return getNUMBER_LITERALAccess().getRule();
	}

	//terminal ML_COMMENT:
	//	"/ *"->"* /";
	public TerminalRule getML_COMMENTRule() {
		return gaQVTcoreBase.getML_COMMENTRule();
	} 

	//terminal SL_COMMENT:
	//	"--" !("\n" | "\r")* ("\r"? "\n")?;
	public TerminalRule getSL_COMMENTRule() {
		return gaQVTcoreBase.getSL_COMMENTRule();
	} 

	//terminal WS:
	//	(" " | "\t" | "\r" | "\n")+;
	public TerminalRule getWSRule() {
		return gaQVTcoreBase.getWSRule();
	} 

	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaQVTcoreBase.getANY_OTHERRule();
	} 

	//URI:
	//	SINGLE_QUOTED_STRING;
	public EssentialOCLGrammarAccess.URIElements getURIAccess() {
		return gaQVTcoreBase.getURIAccess();
	}
	
	public ParserRule getURIRule() {
		return getURIAccess().getRule();
	}

	//EssentialOCLReservedKeyword:
	//	"and" | "else" | "endif" | "if" | "implies" | "in" | "let" | "not" | "or" | "then" | "xor";
	public EssentialOCLGrammarAccess.EssentialOCLReservedKeywordElements getEssentialOCLReservedKeywordAccess() {
		return gaQVTcoreBase.getEssentialOCLReservedKeywordAccess();
	}
	
	public ParserRule getEssentialOCLReservedKeywordRule() {
		return getEssentialOCLReservedKeywordAccess().getRule();
	}

	//EssentialOCLUnaryOperatorCS returns UnaryOperatorCS:
	//	name=("-" | "not");
	public EssentialOCLGrammarAccess.EssentialOCLUnaryOperatorCSElements getEssentialOCLUnaryOperatorCSAccess() {
		return gaQVTcoreBase.getEssentialOCLUnaryOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLUnaryOperatorCSRule() {
		return getEssentialOCLUnaryOperatorCSAccess().getRule();
	}

	//EssentialOCLInfixOperatorCS returns BinaryOperatorCS:
	//	name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies");
	public EssentialOCLGrammarAccess.EssentialOCLInfixOperatorCSElements getEssentialOCLInfixOperatorCSAccess() {
		return gaQVTcoreBase.getEssentialOCLInfixOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLInfixOperatorCSRule() {
		return getEssentialOCLInfixOperatorCSAccess().getRule();
	}

	//EssentialOCLNavigationOperatorCS returns NavigationOperatorCS:
	//	name=("." | "->");
	public EssentialOCLGrammarAccess.EssentialOCLNavigationOperatorCSElements getEssentialOCLNavigationOperatorCSAccess() {
		return gaQVTcoreBase.getEssentialOCLNavigationOperatorCSAccess();
	}
	
	public ParserRule getEssentialOCLNavigationOperatorCSRule() {
		return getEssentialOCLNavigationOperatorCSAccess().getRule();
	}

	//Identifier:
	//	ID;
	public EssentialOCLGrammarAccess.IdentifierElements getIdentifierAccess() {
		return gaQVTcoreBase.getIdentifierAccess();
	}
	
	public ParserRule getIdentifierRule() {
		return getIdentifierAccess().getRule();
	}

	//StringLiteral:
	//	SINGLE_QUOTED_STRING;
	public EssentialOCLGrammarAccess.StringLiteralElements getStringLiteralAccess() {
		return gaQVTcoreBase.getStringLiteralAccess();
	}
	
	public ParserRule getStringLiteralRule() {
		return getStringLiteralAccess().getRule();
	}

	//BinaryOperatorCS:
	//	InfixOperatorCS | NavigationOperatorCS;
	public EssentialOCLGrammarAccess.BinaryOperatorCSElements getBinaryOperatorCSAccess() {
		return gaQVTcoreBase.getBinaryOperatorCSAccess();
	}
	
	public ParserRule getBinaryOperatorCSRule() {
		return getBinaryOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	//InfixOperatorCS returns BinaryOperatorCS:
	//	EssentialOCLInfixOperatorCS;
	public EssentialOCLGrammarAccess.InfixOperatorCSElements getInfixOperatorCSAccess() {
		return gaQVTcoreBase.getInfixOperatorCSAccess();
	}
	
	public ParserRule getInfixOperatorCSRule() {
		return getInfixOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	//NavigationOperatorCS:
	//	EssentialOCLNavigationOperatorCS;
	public EssentialOCLGrammarAccess.NavigationOperatorCSElements getNavigationOperatorCSAccess() {
		return gaQVTcoreBase.getNavigationOperatorCSAccess();
	}
	
	public ParserRule getNavigationOperatorCSRule() {
		return getNavigationOperatorCSAccess().getRule();
	}

	//// Intended to be overrideable
	//UnaryOperatorCS:
	//	EssentialOCLUnaryOperatorCS;
	public EssentialOCLGrammarAccess.UnaryOperatorCSElements getUnaryOperatorCSAccess() {
		return gaQVTcoreBase.getUnaryOperatorCSAccess();
	}
	
	public ParserRule getUnaryOperatorCSRule() {
		return getUnaryOperatorCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Names
	////---------------------------------------------------------------------
	//EssentialOCLUnrestrictedName returns ecore::EString:
	//	Identifier;
	public EssentialOCLGrammarAccess.EssentialOCLUnrestrictedNameElements getEssentialOCLUnrestrictedNameAccess() {
		return gaQVTcoreBase.getEssentialOCLUnrestrictedNameAccess();
	}
	
	public ParserRule getEssentialOCLUnrestrictedNameRule() {
		return getEssentialOCLUnrestrictedNameAccess().getRule();
	}

	//EssentialOCLUnreservedName returns ecore::EString:
	//	UnrestrictedName | CollectionTypeIdentifier | PrimitiveTypeIdentifier | "Tuple";
	public EssentialOCLGrammarAccess.EssentialOCLUnreservedNameElements getEssentialOCLUnreservedNameAccess() {
		return gaQVTcoreBase.getEssentialOCLUnreservedNameAccess();
	}
	
	public ParserRule getEssentialOCLUnreservedNameRule() {
		return getEssentialOCLUnreservedNameAccess().getRule();
	}

	//// Intended to be overridden
	//UnreservedName returns ecore::EString:
	//	EssentialOCLUnreservedName;
	public EssentialOCLGrammarAccess.UnreservedNameElements getUnreservedNameAccess() {
		return gaQVTcoreBase.getUnreservedNameAccess();
	}
	
	public ParserRule getUnreservedNameRule() {
		return getUnreservedNameAccess().getRule();
	}

	//PathNameCS returns base::PathNameCS:
	//	path+=FirstPathElementCS ("::" path+=NextPathElementCS)*;
	public EssentialOCLGrammarAccess.PathNameCSElements getPathNameCSAccess() {
		return gaQVTcoreBase.getPathNameCSAccess();
	}
	
	public ParserRule getPathNameCSRule() {
		return getPathNameCSAccess().getRule();
	}

	//FirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName];
	public EssentialOCLGrammarAccess.FirstPathElementCSElements getFirstPathElementCSAccess() {
		return gaQVTcoreBase.getFirstPathElementCSAccess();
	}
	
	public ParserRule getFirstPathElementCSRule() {
		return getFirstPathElementCSAccess().getRule();
	}

	//NextPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnreservedName];
	public EssentialOCLGrammarAccess.NextPathElementCSElements getNextPathElementCSAccess() {
		return gaQVTcoreBase.getNextPathElementCSAccess();
	}
	
	public ParserRule getNextPathElementCSRule() {
		return getNextPathElementCSAccess().getRule();
	}

	//URIPathNameCS returns base::PathNameCS:
	//	path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*;
	public EssentialOCLGrammarAccess.URIPathNameCSElements getURIPathNameCSAccess() {
		return gaQVTcoreBase.getURIPathNameCSAccess();
	}
	
	public ParserRule getURIPathNameCSRule() {
		return getURIPathNameCSAccess().getRule();
	}

	//URIFirstPathElementCS returns base::PathElementCS:
	//	element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI];
	public EssentialOCLGrammarAccess.URIFirstPathElementCSElements getURIFirstPathElementCSAccess() {
		return gaQVTcoreBase.getURIFirstPathElementCSAccess();
	}
	
	public ParserRule getURIFirstPathElementCSRule() {
		return getURIFirstPathElementCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Types
	////---------------------------------------------------------------------
	//PrimitiveTypeIdentifier:
	//	"Boolean" | "Integer" | "Real" | "String" | "UnlimitedNatural" | "OclAny" | "OclInvalid" | "OclVoid";
	public EssentialOCLGrammarAccess.PrimitiveTypeIdentifierElements getPrimitiveTypeIdentifierAccess() {
		return gaQVTcoreBase.getPrimitiveTypeIdentifierAccess();
	}
	
	public ParserRule getPrimitiveTypeIdentifierRule() {
		return getPrimitiveTypeIdentifierAccess().getRule();
	}

	//PrimitiveTypeCS returns base::PrimitiveTypeRefCS:
	//	name=PrimitiveTypeIdentifier;
	public EssentialOCLGrammarAccess.PrimitiveTypeCSElements getPrimitiveTypeCSAccess() {
		return gaQVTcoreBase.getPrimitiveTypeCSAccess();
	}
	
	public ParserRule getPrimitiveTypeCSRule() {
		return getPrimitiveTypeCSAccess().getRule();
	}

	//CollectionTypeIdentifier returns ecore::EString:
	//	"Set" | "Bag" | "Sequence" | "Collection" | "OrderedSet";
	public EssentialOCLGrammarAccess.CollectionTypeIdentifierElements getCollectionTypeIdentifierAccess() {
		return gaQVTcoreBase.getCollectionTypeIdentifierAccess();
	}
	
	public ParserRule getCollectionTypeIdentifierRule() {
		return getCollectionTypeIdentifierAccess().getRule();
	}

	//CollectionTypeCS:
	//	name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?;
	public EssentialOCLGrammarAccess.CollectionTypeCSElements getCollectionTypeCSAccess() {
		return gaQVTcoreBase.getCollectionTypeCSAccess();
	}
	
	public ParserRule getCollectionTypeCSRule() {
		return getCollectionTypeCSAccess().getRule();
	}

	//MultiplicityBoundsCS returns base::MultiplicityBoundsCS:
	//	lowerBound=LOWER (".." upperBound=UPPER)?;
	public EssentialOCLGrammarAccess.MultiplicityBoundsCSElements getMultiplicityBoundsCSAccess() {
		return gaQVTcoreBase.getMultiplicityBoundsCSAccess();
	}
	
	public ParserRule getMultiplicityBoundsCSRule() {
		return getMultiplicityBoundsCSAccess().getRule();
	}

	//MultiplicityCS returns base::MultiplicityCS:
	//	"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]";
	public EssentialOCLGrammarAccess.MultiplicityCSElements getMultiplicityCSAccess() {
		return gaQVTcoreBase.getMultiplicityCSAccess();
	}
	
	public ParserRule getMultiplicityCSRule() {
		return getMultiplicityCSAccess().getRule();
	}

	//MultiplicityStringCS returns base::MultiplicityStringCS:
	//	stringBounds=("*" | "+" | "?");
	public EssentialOCLGrammarAccess.MultiplicityStringCSElements getMultiplicityStringCSAccess() {
		return gaQVTcoreBase.getMultiplicityStringCSAccess();
	}
	
	public ParserRule getMultiplicityStringCSRule() {
		return getMultiplicityStringCSAccess().getRule();
	}

	//TupleTypeCS returns base::TupleTypeCS:
	//	name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?;
	public EssentialOCLGrammarAccess.TupleTypeCSElements getTupleTypeCSAccess() {
		return gaQVTcoreBase.getTupleTypeCSAccess();
	}
	
	public ParserRule getTupleTypeCSRule() {
		return getTupleTypeCSAccess().getRule();
	}

	//TuplePartCS returns base::TuplePartCS:
	//	name=UnrestrictedName ":" ownedType=TypeExpCS;
	public EssentialOCLGrammarAccess.TuplePartCSElements getTuplePartCSAccess() {
		return gaQVTcoreBase.getTuplePartCSAccess();
	}
	
	public ParserRule getTuplePartCSRule() {
		return getTuplePartCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Literals
	////---------------------------------------------------------------------
	//CollectionLiteralExpCS:
	//	ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}";
	public EssentialOCLGrammarAccess.CollectionLiteralExpCSElements getCollectionLiteralExpCSAccess() {
		return gaQVTcoreBase.getCollectionLiteralExpCSAccess();
	}
	
	public ParserRule getCollectionLiteralExpCSRule() {
		return getCollectionLiteralExpCSAccess().getRule();
	}

	//CollectionLiteralPartCS:
	//	expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?;
	public EssentialOCLGrammarAccess.CollectionLiteralPartCSElements getCollectionLiteralPartCSAccess() {
		return gaQVTcoreBase.getCollectionLiteralPartCSAccess();
	}
	
	public ParserRule getCollectionLiteralPartCSRule() {
		return getCollectionLiteralPartCSAccess().getRule();
	}

	//ConstructorPartCS:
	//	property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.ConstructorPartCSElements getConstructorPartCSAccess() {
		return gaQVTcoreBase.getConstructorPartCSAccess();
	}
	
	public ParserRule getConstructorPartCSRule() {
		return getConstructorPartCSAccess().getRule();
	}

	//PrimitiveLiteralExpCS:
	//	NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
	//	NullLiteralExpCS;
	public EssentialOCLGrammarAccess.PrimitiveLiteralExpCSElements getPrimitiveLiteralExpCSAccess() {
		return gaQVTcoreBase.getPrimitiveLiteralExpCSAccess();
	}
	
	public ParserRule getPrimitiveLiteralExpCSRule() {
		return getPrimitiveLiteralExpCSAccess().getRule();
	}

	//TupleLiteralExpCS:
	//	"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}";
	public EssentialOCLGrammarAccess.TupleLiteralExpCSElements getTupleLiteralExpCSAccess() {
		return gaQVTcoreBase.getTupleLiteralExpCSAccess();
	}
	
	public ParserRule getTupleLiteralExpCSRule() {
		return getTupleLiteralExpCSAccess().getRule();
	}

	//TupleLiteralPartCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.TupleLiteralPartCSElements getTupleLiteralPartCSAccess() {
		return gaQVTcoreBase.getTupleLiteralPartCSAccess();
	}
	
	public ParserRule getTupleLiteralPartCSRule() {
		return getTupleLiteralPartCSAccess().getRule();
	}

	//NumberLiteralExpCS:
	//	name=NUMBER_LITERAL;
	public EssentialOCLGrammarAccess.NumberLiteralExpCSElements getNumberLiteralExpCSAccess() {
		return gaQVTcoreBase.getNumberLiteralExpCSAccess();
	}
	
	public ParserRule getNumberLiteralExpCSRule() {
		return getNumberLiteralExpCSAccess().getRule();
	}

	//StringLiteralExpCS:
	//	name+=StringLiteral+;
	public EssentialOCLGrammarAccess.StringLiteralExpCSElements getStringLiteralExpCSAccess() {
		return gaQVTcoreBase.getStringLiteralExpCSAccess();
	}
	
	public ParserRule getStringLiteralExpCSRule() {
		return getStringLiteralExpCSAccess().getRule();
	}

	//BooleanLiteralExpCS:
	//	name="true" | name="false";
	public EssentialOCLGrammarAccess.BooleanLiteralExpCSElements getBooleanLiteralExpCSAccess() {
		return gaQVTcoreBase.getBooleanLiteralExpCSAccess();
	}
	
	public ParserRule getBooleanLiteralExpCSRule() {
		return getBooleanLiteralExpCSAccess().getRule();
	}

	//UnlimitedNaturalLiteralExpCS:
	//	{UnlimitedNaturalLiteralExpCS} "*";
	public EssentialOCLGrammarAccess.UnlimitedNaturalLiteralExpCSElements getUnlimitedNaturalLiteralExpCSAccess() {
		return gaQVTcoreBase.getUnlimitedNaturalLiteralExpCSAccess();
	}
	
	public ParserRule getUnlimitedNaturalLiteralExpCSRule() {
		return getUnlimitedNaturalLiteralExpCSAccess().getRule();
	}

	//InvalidLiteralExpCS:
	//	{InvalidLiteralExpCS} "invalid";
	public EssentialOCLGrammarAccess.InvalidLiteralExpCSElements getInvalidLiteralExpCSAccess() {
		return gaQVTcoreBase.getInvalidLiteralExpCSAccess();
	}
	
	public ParserRule getInvalidLiteralExpCSRule() {
		return getInvalidLiteralExpCSAccess().getRule();
	}

	//NullLiteralExpCS:
	//	{NullLiteralExpCS} "null";
	public EssentialOCLGrammarAccess.NullLiteralExpCSElements getNullLiteralExpCSAccess() {
		return gaQVTcoreBase.getNullLiteralExpCSAccess();
	}
	
	public ParserRule getNullLiteralExpCSRule() {
		return getNullLiteralExpCSAccess().getRule();
	}

	//TypeLiteralCS returns base::TypedRefCS:
	//	PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS;
	public EssentialOCLGrammarAccess.TypeLiteralCSElements getTypeLiteralCSAccess() {
		return gaQVTcoreBase.getTypeLiteralCSAccess();
	}
	
	public ParserRule getTypeLiteralCSRule() {
		return getTypeLiteralCSAccess().getRule();
	}

	//TypeLiteralWithMultiplicityCS returns base::TypedRefCS:
	//	TypeLiteralCS multiplicity=MultiplicityCS?;
	public EssentialOCLGrammarAccess.TypeLiteralWithMultiplicityCSElements getTypeLiteralWithMultiplicityCSAccess() {
		return gaQVTcoreBase.getTypeLiteralWithMultiplicityCSAccess();
	}
	
	public ParserRule getTypeLiteralWithMultiplicityCSRule() {
		return getTypeLiteralWithMultiplicityCSAccess().getRule();
	}

	//TypeLiteralExpCS:
	//	ownedType=TypeLiteralWithMultiplicityCS;
	public EssentialOCLGrammarAccess.TypeLiteralExpCSElements getTypeLiteralExpCSAccess() {
		return gaQVTcoreBase.getTypeLiteralExpCSAccess();
	}
	
	public ParserRule getTypeLiteralExpCSRule() {
		return getTypeLiteralExpCSAccess().getRule();
	}

	//TypeNameExpCS:
	//	pathName=PathNameCS;
	public EssentialOCLGrammarAccess.TypeNameExpCSElements getTypeNameExpCSAccess() {
		return gaQVTcoreBase.getTypeNameExpCSAccess();
	}
	
	public ParserRule getTypeNameExpCSRule() {
		return getTypeNameExpCSAccess().getRule();
	}

	//TypeExpCS returns base::TypedRefCS:
	//	(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?;
	public EssentialOCLGrammarAccess.TypeExpCSElements getTypeExpCSAccess() {
		return gaQVTcoreBase.getTypeExpCSAccess();
	}
	
	public ParserRule getTypeExpCSRule() {
		return getTypeExpCSAccess().getRule();
	}

	////---------------------------------------------------------------------
	////  Expressions
	////---------------------------------------------------------------------
	//// An ExpCS permits a LetExpCS only in the final term to ensure
	////  that let is right associative, whereas infix operators are left associative.
	////   a = 64 / 16 / let b : Integer in 8 / let c : Integer in 4 
	//// is
	////   a = (64 / 16) / (let b : Integer in 8 / (let c : Integer in 4 ))
	//ExpCS:
	//	PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
	//	(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
	//	ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
	//	ownedExpression=LetExpCS | LetExpCS;
	public EssentialOCLGrammarAccess.ExpCSElements getExpCSAccess() {
		return gaQVTcoreBase.getExpCSAccess();
	}
	
	public ParserRule getExpCSRule() {
		return getExpCSAccess().getRule();
	}

	//PrefixedExpCS returns ExpCS:
	//	{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS;
	public EssentialOCLGrammarAccess.PrefixedExpCSElements getPrefixedExpCSAccess() {
		return gaQVTcoreBase.getPrefixedExpCSAccess();
	}
	
	public ParserRule getPrefixedExpCSRule() {
		return getPrefixedExpCSAccess().getRule();
	}

	//PrimaryExpCS returns ExpCS:
	//	NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
	//	TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
	//	firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
	//	{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
	//	value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
	//	argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
	//	(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?);
	public EssentialOCLGrammarAccess.PrimaryExpCSElements getPrimaryExpCSAccess() {
		return gaQVTcoreBase.getPrimaryExpCSAccess();
	}
	
	public ParserRule getPrimaryExpCSRule() {
		return getPrimaryExpCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingArgCS:
	//	name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingArgCSElements getNavigatingArgCSAccess() {
		return gaQVTcoreBase.getNavigatingArgCSAccess();
	}
	
	public ParserRule getNavigatingArgCSRule() {
		return getNavigatingArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingBarArgCS returns NavigatingArgCS:
	//	prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingBarArgCSElements getNavigatingBarArgCSAccess() {
		return gaQVTcoreBase.getNavigatingBarArgCSAccess();
	}
	
	public ParserRule getNavigatingBarArgCSRule() {
		return getNavigatingBarArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingCommaArgCS returns NavigatingArgCS:
	//	prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingCommaArgCSElements getNavigatingCommaArgCSAccess() {
		return gaQVTcoreBase.getNavigatingCommaArgCSAccess();
	}
	
	public ParserRule getNavigatingCommaArgCSRule() {
		return getNavigatingCommaArgCSAccess().getRule();
	}

	//// Type-less init is an illegal infix expression
	//NavigatingSemiArgCS returns NavigatingArgCS:
	//	prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
	public EssentialOCLGrammarAccess.NavigatingSemiArgCSElements getNavigatingSemiArgCSAccess() {
		return gaQVTcoreBase.getNavigatingSemiArgCSAccess();
	}
	
	public ParserRule getNavigatingSemiArgCSRule() {
		return getNavigatingSemiArgCSAccess().getRule();
	}

	//// Intended to be overridden
	////	'?'	-- defined by Complete OCL
	//NavigatingArgExpCS returns ExpCS:
	//	ExpCS;
	public EssentialOCLGrammarAccess.NavigatingArgExpCSElements getNavigatingArgExpCSAccess() {
		return gaQVTcoreBase.getNavigatingArgExpCSAccess();
	}
	
	public ParserRule getNavigatingArgExpCSRule() {
		return getNavigatingArgExpCSAccess().getRule();
	}

	//IfExpCS:
	//	"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif";
	public EssentialOCLGrammarAccess.IfExpCSElements getIfExpCSAccess() {
		return gaQVTcoreBase.getIfExpCSAccess();
	}
	
	public ParserRule getIfExpCSRule() {
		return getIfExpCSAccess().getRule();
	}

	//LetExpCS:
	//	"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS;
	public EssentialOCLGrammarAccess.LetExpCSElements getLetExpCSAccess() {
		return gaQVTcoreBase.getLetExpCSAccess();
	}
	
	public ParserRule getLetExpCSRule() {
		return getLetExpCSAccess().getRule();
	}

	//LetVariableCS:
	//	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
	public EssentialOCLGrammarAccess.LetVariableCSElements getLetVariableCSAccess() {
		return gaQVTcoreBase.getLetVariableCSAccess();
	}
	
	public ParserRule getLetVariableCSRule() {
		return getLetVariableCSAccess().getRule();
	}

	//NestedExpCS:
	//	"(" source=ExpCS ")";
	public EssentialOCLGrammarAccess.NestedExpCSElements getNestedExpCSAccess() {
		return gaQVTcoreBase.getNestedExpCSAccess();
	}
	
	public ParserRule getNestedExpCSRule() {
		return getNestedExpCSAccess().getRule();
	}

	//SelfExpCS:
	//	{SelfExpCS} "self";
	public EssentialOCLGrammarAccess.SelfExpCSElements getSelfExpCSAccess() {
		return gaQVTcoreBase.getSelfExpCSAccess();
	}
	
	public ParserRule getSelfExpCSRule() {
		return getSelfExpCSAccess().getRule();
	}
}
