/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractSlotState;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Execution;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyInvocationManager;

public class LazyObjectManager
extends AbstractObjectManager {
    private @NonNull Map<@NonNull Object, @NonNull Map<@NonNull EStructuralFeature, @NonNull SlotState>> object2feature2slotState = new HashMap<Object, Map<EStructuralFeature, SlotState>>();
    private @NonNull Map<@NonNull EReference, @NonNull EOppositeReferenceImpl> eReference2eOppositeReference = new HashMap<EReference, EOppositeReferenceImpl>();

    public LazyObjectManager(@NonNull LazyInvocationManager invocationManager) {
        super(invocationManager);
    }

    @Override
    public synchronized void assigned(@NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, @Nullable Object childKey) {
        Map<EStructuralFeature, SlotState> objectState;
        SlotState slotState;
        assert (eFeature != null);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("assigned " + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + " for " + LabelUtil.getLabel((Object)eObject) + " = " + LabelUtil.getLabel((Object)ecoreValue));
        }
        if ((slotState = (objectState = this.getObjectState(eObject)).get(eFeature)) != null) {
            slotState.assigned(eObject, eFeature, ecoreValue);
        } else {
            if (eFeature instanceof EAttribute) {
                slotState = new SimpleSlotState(eObject, (EAttribute)eFeature, ecoreValue);
            } else {
                Object ecoreValue2 = ecoreValue;
                EReference eReference = (EReference)eFeature;
                EReference eOppositeReference = this.getEOppositeReference(eReference);
                if (!(eOppositeReference instanceof EOppositeReferenceImpl)) {
                    if (eReference.isMany()) {
                        assert (ecoreValue2 != null);
                        slotState = eOppositeReference.isMany() ? this.createManyToManySlotState(eObject, eReference, eOppositeReference) : this.createOneToManyAggregatorSlotState(eObject, eReference, eOppositeReference, ecoreValue2);
                    } else {
                        slotState = ecoreValue2 != null ? (eOppositeReference.isMany() ? this.createOneToManyElementSlotState(eObject, eReference, eOppositeReference, ecoreValue2) : this.createOneToOneSlotState(eObject, eReference, eOppositeReference, ecoreValue2)) : this.createOneToOneSlotState(eObject, eReference, eOppositeReference, ecoreValue2);
                    }
                } else if (eReference.isContainment()) {
                    assert (ecoreValue2 != null);
                    eOppositeReference = OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER;
                    assert (eOppositeReference != null);
                    if (eReference.isMany()) {
                        assert (eOppositeReference != null);
                        slotState = this.createOneToManyAggregatorSlotState(eObject, eReference, eOppositeReference, ecoreValue2);
                    } else {
                        Map<@NonNull EStructuralFeature, @NonNull SlotState> oppositeObjectState = this.getObjectState(ecoreValue2);
                        slotState = oppositeObjectState.get(eOppositeReference);
                        if (slotState != null) {
                            assert (eOppositeReference != null);
                            slotState.assigned(ecoreValue2, (EStructuralFeature)eOppositeReference, eObject);
                        } else {
                            assert (eOppositeReference != null);
                            slotState = this.createOneToOneSlotState(eObject, eReference, eOppositeReference, (EObject)ecoreValue2);
                        }
                    }
                } else if (ecoreValue2 != null) {
                    Map<@NonNull EStructuralFeature, @NonNull SlotState> oppositeObjectState = this.getObjectState(ecoreValue2);
                    slotState = oppositeObjectState.get(eOppositeReference);
                    if (slotState == null) {
                        if (eOppositeReference.isMany()) {
                            slotState = this.createOneToManyElementSlotState(eObject, eReference, eOppositeReference, ecoreValue2);
                        } else if (eReference.isMany()) {
                            slotState = new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eReference, ecoreValue2);
                            oppositeObjectState.put((EStructuralFeature)eOppositeReference, slotState);
                        } else {
                            slotState = new OneToOneSlotState(eObject, eReference, ecoreValue2);
                            oppositeObjectState.put((EStructuralFeature)eOppositeReference, slotState);
                        }
                    } else {
                        slotState.assigned(ecoreValue2, (EStructuralFeature)eOppositeReference, eObject);
                    }
                } else {
                    slotState = this.createOneToOneSlotState(eObject, eReference, eOppositeReference, ecoreValue2);
                }
            }
            objectState.put(eFeature, slotState);
        }
    }

    @Override
    public void assigned(@NonNull Invocation.Incremental invocation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, @Nullable Object childKey) {
        this.assigned(eObject, eFeature, ecoreValue, childKey);
    }

    @NonNull SlotState createManyToManySlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature) {
        throw new UnsupportedOperationException();
    }

    @NonNull SlotState createOneToManyAggregatorSlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature, @Nullable Object eContents) {
        return new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eFeature, eContents);
    }

    @NonNull SlotState createOneToManyElementSlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature, @NonNull Object eAggregator) {
        OneToManyAggregatorSlotState aggregatorSlotState = (OneToManyAggregatorSlotState)this.getSlotState(eAggregator, (EStructuralFeature)eOppositeFeature);
        aggregatorSlotState.assignedElement(eAggregator, eOppositeFeature, eObject);
        return new OneToManyElementSlotState(eObject, eFeature, eAggregator);
    }

    <G, S> @NonNull SlotState createOneToOneSlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature, @Nullable Object eOpposite) {
        SlotState slotState;
        Map<EStructuralFeature, SlotState> oppositeObjectState = null;
        if (eOpposite != null && (slotState = (oppositeObjectState = this.getObjectState(eOpposite)).get(eOppositeFeature)) != null) {
            return slotState;
        }
        slotState = new OneToOneSlotState(eObject, eFeature, eOpposite);
        if (oppositeObjectState != null) {
            oppositeObjectState.put((EStructuralFeature)eOppositeFeature, slotState);
        }
        return slotState;
    }

    @NonNull SlotState createReferenceSlotState(@NonNull Object eObject, @NonNull EReference eReference, @NonNull EReference eOppositeReference) {
        if (eReference.isMany()) {
            if (eOppositeReference.isMany()) {
                return new ManyToManySlotState(eObject, (EStructuralFeature)eReference);
            }
            return new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eReference);
        }
        if (eOppositeReference.isMany()) {
            return new OneToManyElementSlotState(eObject, eReference);
        }
        return new OneToOneSlotState(eObject, eReference);
    }

    @Override
    public void created(@NonNull Invocation.Incremental invocation, @NonNull Object eObject) {
    }

    @Override
    public void destroyed(@NonNull Object eObject) {
    }

    protected @NonNull EReference getEOppositeReference(@NonNull EReference eReference) {
        Object eOppositeReference = eReference.getEOpposite();
        if (eOppositeReference == null) {
            EOppositeReferenceImpl eOppositeReference2 = this.eReference2eOppositeReference.get(eReference);
            if (eOppositeReference2 == null) {
                EMap details;
                String oppositeName;
                eOppositeReference2 = new EOppositeReferenceImpl(eReference);
                EAnnotation oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
                if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)"body")) != null) {
                    UnlimitedNaturalValue upper;
                    IntegerValue lower;
                    eOppositeReference2.setName(oppositeName);
                    String lowerValue = (String)details.get((Object)"lower");
                    IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf((String)lowerValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                    if (lower.isInvalid()) {
                        lower = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                    }
                    eOppositeReference2.setLowerBound(lower.intValue());
                    String upperValue = (String)details.get((Object)"upper");
                    UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf((String)upperValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                    if (upper.isInvalid()) {
                        upper = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                    }
                    eOppositeReference2.setUpperBound(upper.isUnlimited() ? -1 : upper.intValue());
                    if (!upper.equals(ValueUtil.ONE_VALUE)) {
                        String uniqueValue = (String)details.get((Object)"unique");
                        boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                        eOppositeReference2.setUnique(isUnique);
                        String orderedValue = (String)details.get((Object)"ordered");
                        boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                        eOppositeReference2.setOrdered(isOrdered);
                    }
                }
                this.eReference2eOppositeReference.put(eReference, eOppositeReference2);
            }
            eOppositeReference = eOppositeReference2;
        }
        return eOppositeReference;
    }

    public @NonNull Map<@NonNull EStructuralFeature, @NonNull SlotState> getObjectState(@NonNull Object eObject) {
        Map<@NonNull EStructuralFeature, @NonNull SlotState> feature2state = this.object2feature2slotState.get(eObject);
        if (feature2state == null) {
            feature2state = new HashMap<EStructuralFeature, SlotState>();
            this.object2feature2slotState.put(eObject, feature2state);
        }
        return feature2state;
    }

    @Override
    public @NonNull Iterable<@NonNull ? extends Object> getObjects() {
        @NonNull Set<@NonNull Object> keySet = this.object2feature2slotState.keySet();
        return keySet;
    }

    public synchronized @NonNull SlotState getSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
        assert (eFeature != null);
        Map<@NonNull EStructuralFeature, @NonNull SlotState> objectState = this.getObjectState(eObject);
        SlotState slotState = objectState.get(eFeature);
        if (slotState == null) {
            if (eFeature instanceof EAttribute) {
                slotState = new SimpleSlotState(eObject, (EAttribute)eFeature);
            } else {
                EReference eReference = (EReference)eFeature;
                EReference eOppositeReference = this.getEOppositeReference(eReference);
                slotState = eReference instanceof EOppositeReferenceImpl ? this.createReferenceSlotState(eObject, eReference, eOppositeReference) : (!(eOppositeReference instanceof EOppositeReferenceImpl) ? this.createReferenceSlotState(eObject, eReference, eOppositeReference) : (eReference.isContainment() ? (eReference.isMany() ? new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eReference) : new OneToOneSlotState(eObject, eReference)) : (eReference == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER ? new OneToManyElementSlotState(eObject, eReference) : this.createReferenceSlotState(eObject, eReference, eOppositeReference))));
            }
            objectState.put(eFeature, slotState);
        }
        return slotState;
    }

    public @NonNull Iterable<@NonNull SlotState> getSlotStates(@NonNull Object object) {
        Map<@NonNull EStructuralFeature, @NonNull SlotState> feature2slotState = this.object2feature2slotState.get(object);
        if (feature2slotState != null) {
            @NonNull Collection<@NonNull SlotState> values = feature2slotState.values();
            return values;
        }
        return EMPTY_SLOT_STATE_LIST;
    }

    @Override
    public synchronized void getting(@NonNull Object eObject, EStructuralFeature eFeature, boolean isOpposite) {
        assert (eFeature != null);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("getting " + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + (isOpposite ? "<opposite> " : "") + " for " + LabelUtil.getLabel((Object)eObject));
        }
        if (isOpposite) {
            eFeature = this.getEOppositeReference((EReference)eFeature);
        }
        SlotState slotState = this.getSlotState(eObject, eFeature);
        slotState.getting(eObject, eFeature);
    }

    @Override
    public void got(@NonNull Execution.Incremental computation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue) {
    }

    public static abstract class BasicSlotState
    extends AbstractSlotState {
        protected final @NonNull Object debug_eObject;
        protected final @NonNull EStructuralFeature debug_eFeature;
        protected @NonNull SlotMode mode;
        private @Nullable Object blockedInvocations = null;

        protected BasicSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            this.mode = SlotMode.ASSIGNABLE;
            this.debug_eObject = eObject;
            this.debug_eFeature = eFeature;
        }

        protected BasicSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            this.mode = SlotMode.ASSIGNED;
            this.debug_eObject = eObject;
            this.debug_eFeature = eFeature;
        }

        public synchronized void assigned(@NonNull LazyObjectManager objectManager, @NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    this.mode = SlotMode.ASSIGNED;
                    this.unblock(objectManager);
                    break;
                }
                case ASSIGNED: {
                    if (eFeature instanceof EOppositeReferenceImpl) break;
                    System.out.println("Re-assignment of " + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + " for " + eObject + " with " + ecoreValue);
                }
            }
        }

        @Override
        public synchronized void block(@NonNull Invocation invocation) {
            Object blockedInvocations2 = this.blockedInvocations;
            if (blockedInvocations2 == null) {
                this.blockedInvocations = invocation;
            } else if (blockedInvocations2 instanceof Invocation) {
                ArrayList<Invocation> blockedInvocationList = new ArrayList<Invocation>();
                blockedInvocationList.add((Invocation)blockedInvocations2);
                blockedInvocationList.add(invocation);
                this.blockedInvocations = blockedInvocationList;
            } else {
                List blockedInvocationList = (List)blockedInvocations2;
                blockedInvocationList.add(invocation);
            }
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    throw new InvocationFailedException(this);
                }
            }
        }

        protected boolean isAssigned() {
            return this.mode == SlotMode.ASSIGNED;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.getClass().getSimpleName());
            s.append("@");
            s.append(Integer.toHexString(System.identityHashCode(this)));
            s.append("[");
            s.append(this.debug_eFeature.getEContainingClass().getName());
            s.append("::");
            s.append(this.debug_eFeature.getName());
            s.append(" for ");
            s.append(LabelUtil.getLabel((Object)this.debug_eObject));
            s.append("]");
            return s.toString();
        }

        protected synchronized void unblock(@NonNull ObjectManager objectManager) {
            Object blockedInvocations2 = this.blockedInvocations;
            if (blockedInvocations2 instanceof Invocation) {
                ((Invocation)blockedInvocations2).unblock();
            } else if (blockedInvocations2 != null) {
                List blockedInvocationList = (List)blockedInvocations2;
                for (Invocation invocation : blockedInvocationList) {
                    invocation.unblock();
                }
            }
            this.blockedInvocations = null;
        }

        public static enum SlotMode {
            ASSIGNABLE,
            ASSIGNED;

        }
    }

    protected static class EOppositeReferenceImpl
    extends EReferenceImpl {
        public EOppositeReferenceImpl(@NonNull EReference eReference) {
            assert (this.eOpposite == null);
            this.setEOpposite(eReference);
            assert (this.eOpposite == eReference);
        }

        public EClass basicGetEReferenceType() {
            throw new UnsupportedOperationException();
        }

        public EClassifier basicGetEType() {
            throw new UnsupportedOperationException();
        }

        public EClass getEContainingClass() {
            return this.eOpposite.getEReferenceType();
        }

        public EGenericType getEGenericType() {
            throw new UnsupportedOperationException();
        }

        public EClass getEReferenceType() {
            return this.eOpposite.getEContainingClass();
        }

        public EClassifier getEType() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "\u00abopposite\u00bb" + this.eOpposite.getName();
        }

        public String getNameGen() {
            throw new UnsupportedOperationException();
        }

        public boolean isChangeable() {
            throw new UnsupportedOperationException();
        }

        public boolean isContainer() {
            throw new UnsupportedOperationException();
        }

        public boolean isContainment() {
            throw new UnsupportedOperationException();
        }

        public boolean isDerived() {
            throw new UnsupportedOperationException();
        }

        public boolean isTransient() {
            throw new UnsupportedOperationException();
        }

        public boolean isVolatile() {
            throw new UnsupportedOperationException();
        }
    }

    class ManyToManySlotState
    extends BasicSlotState {
        public ManyToManySlotState(@NonNull Object eObject, EStructuralFeature eFeature) {
            super(eObject, eFeature);
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            throw new UnsupportedOperationException();
        }
    }

    class OneToManyAggregatorSlotState
    extends BasicSlotState {
        public OneToManyAggregatorSlotState(@NonNull Object eContainer, EStructuralFeature eFeature) {
            super(eContainer, eFeature);
            assert (eFeature.isMany());
        }

        private OneToManyAggregatorSlotState(@NonNull Object eContainer, @Nullable EStructuralFeature eFeature, Object eContents) {
            super(eContainer, eFeature, eContents);
            assert (eFeature.isMany());
            assert (((EObject)eContainer).eGet(eFeature).equals(eContents));
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            EReference eOppositeReference = LazyObjectManager.this.getEOppositeReference((EReference)eFeature);
            assert (ecoreValue != null);
            if (ecoreValue instanceof Iterable) {
                Iterable ecoreValues = (Iterable)ecoreValue;
                for (EObject element : ecoreValues) {
                    if (element == null) continue;
                    Map<@NonNull EStructuralFeature, @NonNull SlotState> elementObjectState = LazyObjectManager.this.getObjectState(element);
                    elementObjectState.put((EStructuralFeature)eOppositeReference, this);
                }
            } else {
                Map<@NonNull EStructuralFeature, @NonNull SlotState> elementObjectState = LazyObjectManager.this.getObjectState(ecoreValue);
                elementObjectState.put((EStructuralFeature)eOppositeReference, this);
            }
            this.assignedElement(eObject, (EReference)eFeature, (EObject)ecoreValue);
        }

        public void assignedElement(@NonNull Object eContainer, @NonNull EReference eReference, Object eObject) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    this.mode = BasicSlotState.SlotMode.ASSIGNED;
                    this.unblock(LazyObjectManager.this);
                    break;
                }
            }
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    this.mode = BasicSlotState.SlotMode.ASSIGNED;
                    this.unblock(LazyObjectManager.this);
                    break;
                }
            }
        }
    }

    class OneToManyElementSlotState
    extends BasicSlotState {
        public OneToManyElementSlotState(@NonNull Object eObject, EReference eFeature) {
            super(eObject, (EStructuralFeature)eFeature);
            assert (!eFeature.isMany());
            if (eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER ? !$assertionsDisabled && eFeature.getEOpposite() != null : !$assertionsDisabled && !LazyObjectManager.this.getEOppositeReference(eFeature).isMany()) {
                throw new AssertionError();
            }
        }

        public OneToManyElementSlotState(@NonNull Object eObject, @NonNull EReference eFeature, Object eAggregator) {
            super(eObject, (EStructuralFeature)eFeature, eAggregator);
            assert (!eFeature.isMany());
            assert (LazyObjectManager.this.getEOppositeReference(eFeature).isMany());
            if (eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER ? !$assertionsDisabled && ((EObject)eObject).eContainer() != eAggregator : !$assertionsDisabled && ((EObject)eObject).eGet((EStructuralFeature)eFeature) != eAggregator) {
                throw new AssertionError();
            }
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            if (!this.isAssigned() && ecoreValue != null) {
                EObject eOpposite = (EObject)ecoreValue;
                EReference eOppositeReference = LazyObjectManager.this.getEOppositeReference((EReference)eFeature);
                if (eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) {
                    eOppositeReference = ((EObject)eObject).eContainmentFeature();
                    assert (eOppositeReference != null);
                    SlotState aggregatorSlotState = LazyObjectManager.this.getSlotState(eOpposite, (EStructuralFeature)eOppositeReference);
                    aggregatorSlotState.assigned(eOpposite, (EStructuralFeature)eOppositeReference, eObject);
                } else {
                    assert (eOppositeReference != null);
                    OneToManyAggregatorSlotState aggregatorSlotState = (OneToManyAggregatorSlotState)LazyObjectManager.this.getSlotState(eOpposite, (EStructuralFeature)eOppositeReference);
                    aggregatorSlotState.assignedElement(eOpposite, eOppositeReference, eObject);
                }
            }
            this.assigned(LazyObjectManager.this, eObject, eFeature, ecoreValue);
        }
    }

    class OneToOneSlotState
    extends BasicSlotState {
        public OneToOneSlotState(@NonNull Object eObject, EReference eFeature) {
            super(eObject, (EStructuralFeature)eFeature);
            if (eFeature instanceof EOppositeReferenceImpl) {
                assert (!((EOppositeReferenceImpl)eFeature).getEOpposite().isMany());
            } else {
                assert (!eFeature.isMany());
                if (!eFeature.isContainer() && !eFeature.isContainment() && eFeature != OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) assert (!LazyObjectManager.this.getEOppositeReference(eFeature).isMany());
            }
        }

        private OneToOneSlotState(@NonNull Object eObject, @Nullable EReference eFeature, Object eOpposite) {
            super(eObject, (EStructuralFeature)eFeature, eOpposite);
            assert (!eFeature.isMany());
            if (eFeature.isContainer()) {
                assert (((EObject)eObject).eContainer() == eOpposite);
            } else if (eFeature.isContainment()) {
                assert (eOpposite == null || eObject == ((EObject)eOpposite).eContainer());
            } else {
                assert (!LazyObjectManager.this.getEOppositeReference(eFeature).isMany());
                assert (((EObject)eObject).eGet((EStructuralFeature)eFeature) == eOpposite);
            }
        }

        @Override
        public void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            this.assigned(LazyObjectManager.this, eObject, eFeature, ecoreValue);
        }
    }

    class SimpleSlotState
    extends BasicSlotState {
        public SimpleSlotState(@NonNull Object eObject, EAttribute eFeature) {
            super(eObject, (EStructuralFeature)eFeature);
        }

        public SimpleSlotState(@NonNull Object eObject, @Nullable EAttribute eFeature, Object ecoreValue) {
            super(eObject, (EStructuralFeature)eFeature, ecoreValue);
        }

        @Override
        public void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            this.assigned(LazyObjectManager.this, eObject, eFeature, ecoreValue);
        }
    }
}

