/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.DatumCaches;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.graphs.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcore.analysis.QVTcoreDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.AbstractDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingAction;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToCallGraphVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToRegionGraphVisitor;

public abstract class ScheduleManager
implements Adapter {
    private final @NonNull ScheduleModel scheduleModel;
    private final @NonNull EnvironmentFactory environmentFactory;
    private final @NonNull Transformation transformation;
    private @Nullable Map<@NonNull CompilerChain.Key<? extends Object>, @Nullable Object> schedulerOptions;
    private final @NonNull RootDomainUsageAnalysis domainAnalysis;
    private final @NonNull DatumCaches datumCaches;
    private final @NonNull DomainUsage inputUsage;
    protected final @NonNull StandardLibraryHelper standardLibraryHelper;
    private final @NonNull ClassDatumAnalysis oclVoidClassDatumAnalysis;
    private final @NonNull Map<ClassDatum, ClassDatumAnalysis> classDatum2classDatumAnalysis = new HashMap<ClassDatum, ClassDatumAnalysis>();
    private final @NonNull Map<Type, Property> type2castProperty = new HashMap<Type, Property>();
    private final @NonNull Map<Type, Property> type2iterateProperty = new HashMap<Type, Property>();
    private final @NonNull Map<String, Property> name2argumentProperty = new HashMap<String, Property>();
    private OperationDependencyAnalysis operationDependencyAnalysis = null;
    private List<@NonNull Mapping> orderedMappings;

    public static @NonNull ScheduleManager get(@NonNull ScheduleModel scheduleModel) {
        ScheduleManager adapter = (ScheduleManager)ClassUtil.getAdapter(ScheduleManager.class, (Notifier)scheduleModel);
        return (ScheduleManager)ClassUtil.nonNullState((Object)adapter);
    }

    protected ScheduleManager(@NonNull ScheduleModel scheduleModel, @NonNull EnvironmentFactory environmentFactory, @NonNull Transformation asTransformation, @Nullable Map<@NonNull CompilerChain.Key<? extends Object>, @Nullable Object> schedulerOptions) {
        this.scheduleModel = scheduleModel;
        scheduleModel.eAdapters().add((Object)this);
        this.environmentFactory = environmentFactory;
        this.transformation = asTransformation;
        this.schedulerOptions = schedulerOptions;
        this.domainAnalysis = new QVTcoreDomainUsageAnalysis(environmentFactory);
        asTransformation.getModelParameter().add((Object)this.domainAnalysis.getPrimitiveTypeModel());
        this.domainAnalysis.analyzeTransformation(asTransformation);
        this.datumCaches = new DatumCaches(this);
        this.datumCaches.analyzeTransformation(asTransformation);
        this.analyzeCallTree();
        this.inputUsage = this.domainAnalysis.getInputUsage();
        StandardLibrary standardLibrary = environmentFactory.getStandardLibrary();
        this.standardLibraryHelper = new StandardLibraryHelper(standardLibrary);
        this.oclVoidClassDatumAnalysis = this.getClassDatumAnalysis(standardLibrary.getOclVoidType(), this.domainAnalysis.getPrimitiveTypeModel());
    }

    public void addRegionError(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        throw new UnsupportedOperationException();
    }

    private void analyzeCallTree() {
        HashMap<@NonNull Mapping, @NonNull ArrayList<@NonNull E>> consumer2producers = new HashMap();
        ArrayList<@NonNull ClassDatum> middleClassDatums = new ArrayList<ClassDatum>();
        StringBuilder s = QVTm2QVTs.CALL_TREE.isActive() ? new StringBuilder() : null;
        for (ClassDatum classDatum : QVTscheduleUtil.getOwnedClassDatums((ScheduleModel)this.scheduleModel)) {
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            DomainUsage usage = this.domainAnalysis.getUsage((Element)typedModel);
            if (!usage.isMiddle()) continue;
            middleClassDatums.add(classDatum);
            if (s != null) {
                s.append("middle: " + classDatum.getProducedByActions() + "\n");
            }
            for (MappingAction consumerAction : QVTscheduleUtil.getRequiredByActions((AbstractDatum)classDatum)) {
                Mapping consumer = QVTscheduleUtil.getReferredMapping((MappingAction)consumerAction);
                ArrayList<@NonNull Mapping> producers = (ArrayList<Mapping>)consumer2producers.get(consumer);
                if (producers == null) {
                    producers = new ArrayList<Mapping>();
                    consumer2producers.put(consumer, producers);
                }
                for (MappingAction producerAction : QVTscheduleUtil.getProducedByActions((AbstractDatum)classDatum)) {
                    Mapping producer = QVTscheduleUtil.getReferredMapping((MappingAction)producerAction);
                    if (producers.contains(producer)) continue;
                    producers.add(producer);
                }
            }
        }
        if (s != null) {
            s.append("consumer2producers: " + consumer2producers);
            QVTm2QVTs.CALL_TREE.println(s.toString());
        }
    }

    protected abstract @NonNull ClassDatumAnalysis createClassDatumAnalysis(@NonNull ClassDatum var1);

    protected @NonNull Property createProperty(@NonNull String name, @NonNull Type type, boolean isRequired) {
        Property property = PivotUtil.createProperty((String)name, (Type)type);
        property.setIsRequired(isRequired);
        return property;
    }

    public @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatums(@NonNull ClassDatum classDatum) {
        return this.datumCaches.getAllPropertyDatums(classDatum);
    }

    public @NonNull Property getArgumentProperty(@NonNull String argumentName) {
        Property argumentProperty = this.name2argumentProperty.get(argumentName);
        if (argumentProperty == null) {
            argumentProperty = this.createProperty(argumentName, (Type)this.getStandardLibrary().getOclAnyType(), true);
            this.name2argumentProperty.put(argumentName, argumentProperty);
        }
        return argumentProperty;
    }

    public @NonNull Property getCastProperty(@NonNull Type type) {
        Property castProperty = this.type2castProperty.get(type);
        if (castProperty == null) {
            castProperty = this.createProperty("\u00abcast\u00bb\\n" + type.toString(), type, true);
            this.type2castProperty.put(type, castProperty);
        }
        return castProperty;
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedElement asTypedElement) {
        TypedModel typedModel;
        Class asType = (Class)asTypedElement.getType();
        assert (asType != null);
        Type elementType = PivotUtil.getElementalType((Type)asType);
        if (elementType instanceof DataType) {
            typedModel = this.getDomainAnalysis().getPrimitiveTypeModel();
        } else {
            DomainUsage domainUsage = this.getDomainUsage((Element)asTypedElement);
            assert (domainUsage != null);
            typedModel = domainUsage.getTypedModel((Element)asTypedElement);
            assert (typedModel != null);
        }
        return this.datumCaches.getClassDatum(typedModel, asType);
    }

    public @NonNull ClassDatum getClassDatum(@NonNull Class asType, @NonNull TypedModel typedModel) {
        return this.datumCaches.getClassDatum(typedModel, asType);
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull ClassDatum classDatum) {
        ClassDatumAnalysis classDatumAnalysis = this.classDatum2classDatumAnalysis.get(classDatum);
        if (classDatumAnalysis == null) {
            classDatumAnalysis = this.createClassDatumAnalysis(classDatum);
            this.classDatum2classDatumAnalysis.put(classDatum, classDatumAnalysis);
        }
        return classDatumAnalysis;
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull TypedElement typedElement) {
        ClassDatum classDatum = this.getClassDatum(typedElement);
        return this.getClassDatumAnalysis(classDatum);
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull Class type, @NonNull TypedModel typedModel) {
        ClassDatum classDatum = this.datumCaches.getClassDatum(typedModel, type);
        return this.getClassDatumAnalysis(classDatum);
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull CompleteClass completeClass, @NonNull TypedModel typedModel) {
        ClassDatum classDatum = this.datumCaches.getClassDatum(typedModel, completeClass);
        return this.getClassDatumAnalysis(classDatum);
    }

    public @NonNull Iterable<ClassDatumAnalysis> getClassDatumAnalyses() {
        return this.classDatum2classDatumAnalysis.values();
    }

    public @NonNull ContainmentAnalysis getContainmentAnalysis() {
        return this.datumCaches.getContainmentAnalysis();
    }

    public @NonNull RootDomainUsageAnalysis getDomainAnalysis() {
        return this.domainAnalysis;
    }

    public @NonNull DomainUsage getDomainUsage(@NonNull Element element) {
        RootDomainUsageAnalysis analysis = this.domainAnalysis;
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            analysis = this.domainAnalysis.getAnalysis(operation);
        }
        return (DomainUsage)ClassUtil.nonNullState((Object)analysis.getUsage(element));
    }

    public @NonNull ClassDatumAnalysis getElementalClassDatumAnalysis(@NonNull Node calledNode) {
        ClassDatumAnalysis classDatumAnalysis = RegionUtil.getClassDatumAnalysis(calledNode);
        CompleteClass completeClass = classDatumAnalysis.getClassDatum().getCompleteClass();
        Class primaryClass = completeClass.getPrimaryClass();
        if (primaryClass instanceof CollectionType) {
            Class elementType = (Class)((CollectionType)primaryClass).getElementType();
            assert (elementType != null);
            classDatumAnalysis = this.getClassDatumAnalysis(elementType, RegionUtil.getTypedModel(classDatumAnalysis));
        }
        return classDatumAnalysis;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull URI getGraphsBaseURI() {
        return this.transformation.eResource().getURI().trimSegments(1).appendSegment("graphs").appendSegment("");
    }

    public @NonNull Property getIterateProperty(@NonNull Type type) {
        Property iterateProperty = this.type2iterateProperty.get(type);
        if (iterateProperty == null) {
            iterateProperty = this.createProperty("\u00abiterate\u00bb", type, true);
            this.type2iterateProperty.put(type, iterateProperty);
        }
        return iterateProperty;
    }

    public @NonNull ClassDatumAnalysis getOclVoidClassDatumAnalysis() {
        return this.oclVoidClassDatumAnalysis;
    }

    public @NonNull OperationDependencyAnalysis getOperationDependencyAnalysis() {
        OperationDependencyAnalysis operationDependencyAnalysis2 = this.operationDependencyAnalysis;
        if (operationDependencyAnalysis2 == null) {
            this.operationDependencyAnalysis = operationDependencyAnalysis2 = new OperationDependencyAnalysis(this.getContainmentAnalysis(), this.getDomainAnalysis());
        }
        return operationDependencyAnalysis2;
    }

    protected @NonNull Iterable<@NonNull Mapping> getOrderedMappings() {
        List<@NonNull Mapping> orderedMappings2 = this.orderedMappings;
        if (orderedMappings2 == null) {
            orderedMappings2 = this.orderedMappings = new ArrayList<Mapping>();
            for (Rule rule : ClassUtil.nullFree((EList)this.transformation.getRule())) {
                this.orderedMappings.add((Mapping)rule);
            }
            Collections.sort(orderedMappings2, NameUtil.NAMEABLE_COMPARATOR);
        }
        return orderedMappings2;
    }

    public @NonNull PropertyDatum getPropertyDatum(@NonNull ClassDatum classDatum, @NonNull Property property) {
        return this.datumCaches.getPropertyDatum(classDatum, property);
    }

    public @NonNull ScheduleModel getScheduleModel() {
        return this.scheduleModel;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    public Notifier getTarget() {
        return this.scheduleModel;
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public boolean isAdapterForType(Object type) {
        return type == ScheduleManager.class;
    }

    public boolean isDirty(@NonNull Property property) {
        return this.domainAnalysis.isDirty(property);
    }

    public boolean isNoEarlyMerge() {
        Map<@NonNull CompilerChain.Key<? extends Object>, @Nullable Object> schedulerOptions2 = this.schedulerOptions;
        if (schedulerOptions2 == null) {
            return false;
        }
        return schedulerOptions2.get(CompilerChain.SCHEDULER_NO_EARLY_MERGE) == Boolean.TRUE;
    }

    public boolean isNoLateConsumerMerge() {
        Map<@NonNull CompilerChain.Key<? extends Object>, @Nullable Object> schedulerOptions2 = this.schedulerOptions;
        if (schedulerOptions2 == null) {
            return false;
        }
        return schedulerOptions2.get(CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE) == Boolean.TRUE;
    }

    public boolean isKnown(@NonNull VariableDeclaration sourceVariable) {
        if (sourceVariable.eContainer() == null) {
            return false;
        }
        DomainUsage usage = this.getDomainUsage((Element)sourceVariable);
        assert (usage != null);
        return !usage.isOutput();
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
    }

    public void writeCallDOTfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".dot")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            ToCallGraphVisitor visitor = new ToCallGraphVisitor((GraphStringBuilder)new DOTStringBuilder());
            String s = visitor.visit(region);
            outputStream.write(s.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeCallGraphMLfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".graphml")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            ToCallGraphVisitor visitor = new ToCallGraphVisitor((GraphStringBuilder)new GraphMLStringBuilder());
            String s = visitor.visit(region);
            outputStream.write(s.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeDebugGraphs(@NonNull ScheduledRegion scheduledRegion, @NonNull String context, boolean doNodesGraph, boolean doRegionGraph, boolean doCallGraph) {
        String suffix;
        if (doNodesGraph) {
            this.writeDebugGraphs((Region)scheduledRegion, context);
        }
        if (doRegionGraph) {
            suffix = "-r-" + context;
            this.writeRegionDOTfile(scheduledRegion, suffix);
            this.writeRegionGraphMLfile(scheduledRegion, suffix);
        }
        if (doCallGraph) {
            suffix = "-c-" + context;
            this.writeCallDOTfile(scheduledRegion, suffix);
            this.writeCallGraphMLfile(scheduledRegion, suffix);
        }
    }

    public void writeDebugGraphs(@NonNull Region region, @Nullable String context) {
        String suffix = context != null ? "-" + context : null;
        this.writeDOTfile(region, suffix);
        this.writeGraphMLfile(region, suffix);
    }

    public void writeDOTfile(@NonNull Region region, @Nullable String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        String symbolName = region.getSymbolName();
        if (suffix != null) {
            symbolName = String.valueOf(symbolName) + suffix;
        }
        URI dotURI = URI.createURI((String)(String.valueOf(symbolName) + ".dot")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            DOTStringBuilder s = new DOTStringBuilder();
            region.toGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeGraphMLfile(@NonNull Region region, @Nullable String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        String symbolName = region.getSymbolName();
        if (suffix != null) {
            symbolName = String.valueOf(symbolName) + suffix;
        }
        URI dotURI = URI.createURI((String)(String.valueOf(symbolName) + ".graphml")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            GraphMLStringBuilder s = new GraphMLStringBuilder();
            region.toGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeRegionDOTfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".dot")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            ToRegionGraphVisitor visitor = new ToRegionGraphVisitor((GraphStringBuilder)new DOTStringBuilder());
            String s = visitor.visit(region);
            outputStream.write(s.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
        for (Region nestedRegion : RegionUtil.getOwnedRegions((ScheduledRegion)region)) {
            if (!(nestedRegion instanceof ScheduledRegion)) continue;
            this.writeRegionDOTfile((ScheduledRegion)nestedRegion, suffix);
        }
    }

    public void writeRegionGraphMLfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".graphml")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            ToRegionGraphVisitor visitor = new ToRegionGraphVisitor((GraphStringBuilder)new GraphMLStringBuilder());
            String s = visitor.visit(region);
            outputStream.write(s.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
        for (Region nestedRegion : RegionUtil.getOwnedRegions((ScheduledRegion)region)) {
            if (!(nestedRegion instanceof ScheduledRegion)) continue;
            this.writeRegionGraphMLfile((ScheduledRegion)nestedRegion, suffix);
        }
    }
}

